/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.widgets;

import com.android.tools.idea.editors.gfxtrace.renderers.CellRenderer;
import com.android.tools.idea.editors.gfxtrace.widgets.CellWidget;
import com.intellij.openapi.ui.ComboBox;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class CellComboBox<T extends CellWidget.Data>
extends CellWidget<T, ComboBox> {
    public CellComboBox(CellRenderer.CellLoader<T> loader) {
        super(new ComboBox(){

            public Object getPrototypeDisplayValue() {
                ComboBoxModel model = this.getModel();
                return model.getSize() == 0 ? null : model.getElementAt(0);
            }
        }, loader);
        ((ComboBox)this.myComponent).setRenderer((ListCellRenderer)this.myRenderer);
        ((ComboBox)this.myComponent).setMaximumRowCount(5);
        JList<Object> list = ((ComboBox)this.myComponent).getPopup().getList();
        Dimension initialSize = this.myRenderer.getInitialCellSize();
        list.setFixedCellHeight(initialSize.height);
        list.setFixedCellWidth(initialSize.width);
    }

    @Override
    public int getSelectedItem() {
        return ((ComboBox)this.myComponent).getSelectedIndex();
    }

    @Override
    protected void addSelectionListener(ComboBox component, final CellWidget.SelectionListener<T> selectionListener) {
        component.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                selectionListener.selected((CellWidget.Data)itemEvent.getItem());
            }
        });
    }

    @Override
    protected void setSelectedIndex(ComboBox component, int index) {
        component.setSelectedIndex(index);
    }

    @Override
    public void setData(@NotNull List<T> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/editors/gfxtrace/widgets/CellComboBox", "setData"));
        }
        super.setData(data);
        DefaultComboBoxModel<CellWidget.Data> model = new DefaultComboBoxModel<CellWidget.Data>();
        for (CellWidget.Data item : data) {
            model.addElement(item);
        }
        ((ComboBox)this.myComponent).setModel(model);
    }
}

