/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.service.MemoryInfo;
import com.android.tools.idea.editors.gfxtrace.service.path.MemoryRangePath;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.reference.SoftReference;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Range;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Segment;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryController
extends Controller {
    @NotNull
    private static final Logger LOG = Logger.getInstance(MemoryController.class);
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final JBLoadingPanel myLoading;
    @NotNull
    private final EmptyPanel myEmptyPanel;
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private DataType myDataType;
    private MemoryDataModel myMemoryData;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new MemoryController((GfxTraceEditor)editor).myPanel;
    }

    private MemoryController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/MemoryController", "<init>"));
        }
        super(editor);
        this.myPanel = new JPanel(new BorderLayout());
        this.myLoading = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this.myEditor.getProject(), 50);
        this.myEmptyPanel = new EmptyPanel();
        this.myScrollPane = new JBScrollPane((Component)this.myEmptyPanel);
        this.myDataType = DataType.Bytes;
        this.myLoading.add((Component)this.myScrollPane, (Object)"Center");
        this.myPanel.add((Component)new ComboBox((Object[])DataType.values()){
            {
                this.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        MemoryController.this.setDataType((DataType)((Object)e.getItem()));
                    }
                });
            }
        }, "North");
        this.myPanel.add((Component)this.myLoading, "Center");
        this.myPanel.setBorder(BorderFactory.createTitledBorder(this.myScrollPane.getBorder(), "Memory"));
        this.myScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    private void setDataType(DataType dataType) {
        if (this.myDataType != dataType) {
            this.myDataType = dataType;
            Component component = this.myScrollPane.getViewport().getView();
            if (component instanceof MemoryPanel) {
                ((MemoryPanel)component).setModel(dataType.getMemoryModel(this.myMemoryData));
            }
        }
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
        final MemoryRangePath memoryPath = event.findMemoryPath();
        if (memoryPath != null) {
            this.myLoading.startLoading();
            PagedMemoryDataModel.MemoryFetcher fetcher = new PagedMemoryDataModel.MemoryFetcher(){

                @Override
                public ListenableFuture<byte[]> get(long address, long count) {
                    return Futures.transform(MemoryController.this.myEditor.getClient().get(new MemoryRangePath().setAfter(memoryPath.getAfter()).setPool(memoryPath.getPool()).setAddress(address).setSize(count)), (Function)new Function<MemoryInfo, byte[]>(){

                        public byte[] apply(MemoryInfo input) {
                            return input.getData();
                        }
                    });
                }
            };
            if (PagedMemoryDataModel.shouldUsePagedModel(memoryPath.getSize())) {
                this.myMemoryData = new PagedMemoryDataModel(fetcher, memoryPath.getAddress(), memoryPath.getSize());
                this.update();
            } else {
                Futures.addCallback(fetcher.get(memoryPath.getAddress(), memoryPath.getSize()), (FutureCallback)new FutureCallback<byte[]>(){

                    public void onSuccess(byte[] data) {
                        MemoryController.this.myMemoryData = new ImmediateMemoryDataModel(memoryPath.getAddress(), data);
                        MemoryController.this.update();
                    }

                    public void onFailure(Throwable t) {
                        LOG.error("Failed to load memory " + memoryPath, t);
                    }
                }, (Executor)EdtExecutor.INSTANCE);
            }
        } else {
            this.myScrollPane.setViewportView(this.myEmptyPanel);
        }
    }

    private void update() {
        this.myLoading.stopLoading();
        this.myScrollPane.setViewportView(new MemoryPanel(this.myDataType.getMemoryModel(this.myMemoryData)));
    }

    private static class DoublesMemoryModel
    extends CharBufferMemoryModel {
        private static final int DOUBLES_PER_ROW = 2;
        private static final int CHARS_PER_DOUBLE = 24;
        private static final int DOUBLE_SEPARATOR = 1;
        private static final int DOUBLES_CHARS = 50;
        private static final int CHARS_PER_ROW = 67;
        private static final Range<Integer> DOUBLES_RANGE = new Range((Comparable)Integer.valueOf(18), (Comparable)Integer.valueOf(67));

        public DoublesMemoryModel(MemoryDataModel data) {
            super(data.align(8), 67, DOUBLES_RANGE);
        }

        @Override
        protected void formatMemory(char[] buffer, MemorySegment memory) {
            StringBuilder sb = new StringBuilder(50);
            int i = 0;
            int j = 17;
            while (i < memory.myLength) {
                sb.setLength(0);
                sb.append(Double.longBitsToDouble(memory.getLong(i)));
                int count = Math.min(24, sb.length());
                sb.getChars(0, count, buffer, j + 24 - count + 1);
                i += 8;
                j += 25;
            }
        }
    }

    private static class FloatsMemoryModel
    extends CharBufferMemoryModel {
        private static final int FLOATS_PER_ROW = 4;
        private static final int CHARS_PER_FLOAT = 15;
        private static final int FLOAT_SEPARATOR = 1;
        private static final int FLOATS_CHARS = 64;
        private static final int CHARS_PER_ROW = 81;
        private static final Range<Integer> FLOATS_RANGE = new Range((Comparable)Integer.valueOf(18), (Comparable)Integer.valueOf(81));

        public FloatsMemoryModel(MemoryDataModel data) {
            super(data.align(4), 81, FLOATS_RANGE);
        }

        @Override
        protected void formatMemory(char[] buffer, MemorySegment memory) {
            StringBuilder sb = new StringBuilder(50);
            int i = 0;
            int j = 17;
            while (i < memory.myLength) {
                sb.setLength(0);
                sb.append(Float.intBitsToFloat(memory.getInt(i)));
                int count = Math.min(15, sb.length());
                sb.getChars(0, count, buffer, j + 15 - count + 1);
                i += 4;
                j += 16;
            }
        }
    }

    private static class IntsMemoryModel
    extends CharBufferMemoryModel {
        private static final int INTS_PER_ROW = 4;
        private static final int CHARS_PER_INT = 8;
        private static final int INT_SEPARATOR = 1;
        private static final int INTS_CHARS = 36;
        private static final int CHARS_PER_ROW = 53;
        private static final Range<Integer> INTS_RANGE = new Range((Comparable)Integer.valueOf(18), (Comparable)Integer.valueOf(53));

        public IntsMemoryModel(MemoryDataModel data) {
            super(data.align(4), 53, INTS_RANGE);
        }

        @Override
        protected void formatMemory(char[] buffer, MemorySegment memory) {
            int i = 0;
            int j = 17;
            while (i < memory.myLength) {
                int v = memory.getInt(i);
                buffer[j + 1] = HEX_DIGITS[v >> 28 & 0xF];
                buffer[j + 2] = HEX_DIGITS[v >> 24 & 0xF];
                buffer[j + 3] = HEX_DIGITS[v >> 20 & 0xF];
                buffer[j + 4] = HEX_DIGITS[v >> 16 & 0xF];
                buffer[j + 5] = HEX_DIGITS[v >> 12 & 0xF];
                buffer[j + 6] = HEX_DIGITS[v >> 8 & 0xF];
                buffer[j + 7] = HEX_DIGITS[v >> 4 & 0xF];
                buffer[j + 8] = HEX_DIGITS[v >> 0 & 0xF];
                i += 4;
                j += 9;
            }
        }
    }

    private static class ShortsMemoryModel
    extends CharBufferMemoryModel {
        private static final int SHORTS_PER_ROW = 8;
        private static final int CHARS_PER_SHORT = 4;
        private static final int SHORT_SEPARATOR = 1;
        private static final int SHORTS_CHARS = 40;
        private static final int CHARS_PER_ROW = 57;
        private static final Range<Integer> SHORTS_RANGE = new Range((Comparable)Integer.valueOf(18), (Comparable)Integer.valueOf(57));

        public ShortsMemoryModel(MemoryDataModel data) {
            super(data.align(2), 57, SHORTS_RANGE);
        }

        @Override
        protected void formatMemory(char[] buffer, MemorySegment memory) {
            int i = 0;
            int j = 17;
            while (i < memory.myLength) {
                int s = memory.getShort(i);
                buffer[j + 1] = HEX_DIGITS[s >> 12 & 0xF];
                buffer[j + 2] = HEX_DIGITS[s >> 8 & 0xF];
                buffer[j + 3] = HEX_DIGITS[s >> 4 & 0xF];
                buffer[j + 4] = HEX_DIGITS[s >> 0 & 0xF];
                i += 2;
                j += 5;
            }
        }
    }

    private static class BytesMemoryModel
    extends CharBufferMemoryModel {
        private static final int CHARS_PER_BYTE = 2;
        private static final int BYTE_SEPARATOR = 1;
        private static final int ASCII_SEPARATOR = 2;
        private static final int BYTES_CHARS = 48;
        private static final int ASCII_CHARS = 18;
        private static final int CHARS_PER_ROW = 83;
        private static final Range<Integer> BYTES_RANGE = new Range((Comparable)Integer.valueOf(18), (Comparable)Integer.valueOf(65));
        private static final Range<Integer> ASCII_RANGE = new Range((Comparable)Integer.valueOf(67), (Comparable)Integer.valueOf(83));

        public BytesMemoryModel(MemoryDataModel data) {
            super(data, 83, BYTES_RANGE);
        }

        @Override
        public Range<Integer> getSelectableRegion(int column) {
            if (ASCII_RANGE.isWithin((Comparable)Integer.valueOf(column))) {
                return ASCII_RANGE;
            }
            return super.getSelectableRegion(column);
        }

        @Override
        public ListenableFuture<Transferable> getTransferable(Range<Integer> selectionRange, final Point start, final Point end) {
            if (selectionRange == ASCII_RANGE) {
                return Futures.transform(this.myData.get(start.y * 16, (end.y - start.y + 1) * 16), (Function)new Function<MemorySegment, Transferable>(){

                    public Transferable apply(MemorySegment s) {
                        return new StringSelection(s.asString(start.x - (Integer)ASCII_RANGE.getFrom(), s.myLength - start.x + (Integer)ASCII_RANGE.getFrom() - (Integer)ASCII_RANGE.getTo() + end.x));
                    }
                });
            }
            return super.getTransferable(selectionRange, start, end);
        }

        @Override
        protected void formatMemory(char[] buffer, MemorySegment memory) {
            int b;
            int i = 0;
            int j = 17;
            while (i < memory.myLength) {
                b = memory.getByte(i);
                buffer[j + 1] = HEX_DIGITS[b >> 4 & 0xF];
                buffer[j + 2] = HEX_DIGITS[b >> 0 & 0xF];
                ++i;
                j += 3;
            }
            i = 0;
            j = 67;
            while (i < memory.myLength) {
                b = memory.getByte(i);
                buffer[j] = b >= 32 && b < 127 ? (int)b : 46;
                ++i;
                ++j;
            }
        }
    }

    private static abstract class CharBufferMemoryModel
    extends MemoryModel {
        protected static final int CHARS_PER_ADDRESS = 16;
        protected static final int ADDRESS_SEPARATOR = 1;
        protected static final int ADDRESS_CHARS = 17;
        protected static final Range<Integer> ADDRESS_RANGE = new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(16));
        protected static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
        protected final int myCharsPerRow;
        protected final Range<Integer> myMemoryRange;

        public CharBufferMemoryModel(MemoryDataModel data, int charsPerRow, Range<Integer> memoryRange) {
            super(data);
            this.myCharsPerRow = charsPerRow;
            this.myMemoryRange = memoryRange;
        }

        @Override
        public int getLineLength() {
            return this.myCharsPerRow;
        }

        @Override
        protected void getLine(Segment segment, MemorySegment memory, int line) {
            segment.array = new char[this.myCharsPerRow];
            segment.offset = 0;
            segment.count = this.myCharsPerRow;
            this.formatLine(segment.array, memory, line);
        }

        private void formatLine(char[] array, MemorySegment memory, int line) {
            Arrays.fill(array, ' ');
            long address = this.myData.getAddress() + (long)(line * 16);
            int i = 15;
            while (i >= 0) {
                array[i] = HEX_DIGITS[(int)address & 0xF];
                --i;
                address >>>= 4;
            }
            array[16] = 58;
            this.formatMemory(array, memory);
        }

        protected abstract void formatMemory(char[] var1, MemorySegment var2);

        @Override
        public Range<Integer> getSelectableRegion(int column) {
            if (ADDRESS_RANGE.isWithin((Comparable)Integer.valueOf(column))) {
                return ADDRESS_RANGE;
            }
            if (this.myMemoryRange.isWithin((Comparable)Integer.valueOf(column))) {
                return this.myMemoryRange;
            }
            return null;
        }

        @Override
        public ListenableFuture<Transferable> getTransferable(final Range<Integer> selectionRange, final Point start, final Point end) {
            return Futures.transform(this.myData.get(start.y * 16, (end.y - start.y + 1) * 16), (Function)new Function<MemorySegment, Transferable>(){

                public Transferable apply(MemorySegment memory) {
                    StringBuilder buffer = new StringBuilder();
                    Iterator<Segment> lines = this.getLines(start.y, end.y + 1, memory);
                    if (lines.hasNext()) {
                        Segment segment = lines.next();
                        if (start.y == end.y) {
                            buffer.append(segment.array, segment.offset + start.x, end.x - start.x);
                        } else {
                            buffer.append(segment.array, segment.offset + start.x, (Integer)selectionRange.getTo() - start.x).append('\n');
                        }
                    }
                    int rangeWidth = (Integer)selectionRange.getTo() - (Integer)selectionRange.getFrom();
                    for (int line = start.y + 1; lines.hasNext() && line < end.y; ++line) {
                        Segment segment = lines.next();
                        buffer.append(segment.array, segment.offset + (Integer)selectionRange.getFrom(), rangeWidth).append('\n');
                    }
                    if (lines.hasNext()) {
                        Segment segment = lines.next();
                        buffer.append(segment.array, segment.offset + (Integer)selectionRange.getFrom(), end.x - (Integer)selectionRange.getFrom()).append('\n');
                    }
                    return new StringSelection(buffer.toString());
                }
            });
        }
    }

    private static abstract class MemoryModel {
        protected static final int BYTES_PER_ROW = 16;
        protected final MemoryDataModel myData;
        protected final int myRows;

        public MemoryModel(MemoryDataModel data) {
            this.myData = data;
            this.myRows = (data.getByteCount() + 16 - 1) / 16;
        }

        public int getLineCount() {
            return this.myRows;
        }

        public abstract int getLineLength();

        public Iterator<Segment> getLines(int start, int end, Runnable onChange) {
            if (start < 0 || end < start || end > this.getLineCount()) {
                throw new IndexOutOfBoundsException("[" + start + ", " + end + ") outside of [0, " + this.getLineCount() + ")");
            }
            ListenableFuture<MemorySegment> future = this.myData.get(start * 16, (end - start) * 16);
            if (future.isDone()) {
                return this.getLines(start, end, (MemorySegment)Futures.getUnchecked(future));
            }
            future.addListener(onChange, (Executor)EdtExecutor.INSTANCE);
            return EmptyIterator.getInstance();
        }

        protected Iterator<Segment> getLines(final int start, final int end, final MemorySegment memory) {
            return new Iterator<Segment>(){
                private int pos;
                private int offset;
                private final Segment segment;
                {
                    this.pos = start;
                    this.offset = 0;
                    this.segment = new Segment(null, 0, 0);
                }

                @Override
                public boolean hasNext() {
                    return this.pos < end;
                }

                @Override
                public Segment next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.getLine(this.segment, memory.subSegment(this.offset, 16), this.pos);
                    ++this.pos;
                    this.offset += 16;
                    return this.segment;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        protected abstract void getLine(Segment var1, MemorySegment var2, int var3);

        public abstract Range<Integer> getSelectableRegion(int var1);

        public abstract ListenableFuture<Transferable> getTransferable(Range<Integer> var1, Point var2, Point var3);
    }

    private static class MemorySegment {
        public final byte[] myData;
        public final int myOffset;
        public final int myLength;

        public MemorySegment(byte[] data, int offset, int length) {
            this.myData = data;
            this.myOffset = offset;
            this.myLength = length;
        }

        public MemorySegment subSegment(int start, int count) {
            return new MemorySegment(this.myData, this.myOffset + start, Math.min(count, this.myLength - start));
        }

        public String asString(int start, int count) {
            return new String(this.myData, this.myOffset + start, Math.min(count, this.myLength - start), Charset.forName("US-ASCII"));
        }

        public int getByte(int off) {
            return this.myData[this.myOffset + off] & 0xFF;
        }

        public int getShort(int off) {
            return this.myData[(off += this.myOffset) + 0] & 0xFF | (this.myData[off + 1] & 0xFF) << 8;
        }

        public int getInt(int off) {
            return this.myData[(off += this.myOffset) + 0] & 0xFF | (this.myData[off + 1] & 0xFF) << 8 | (this.myData[off + 2] & 0xFF) << 16 | this.myData[off + 3] << 24;
        }

        public long getLong(int off) {
            return (long)this.getInt(off) & 0xFFFFFFFFL | (long)this.getInt(off + 4) << 32;
        }
    }

    private static class PagedMemoryDataModel
    implements MemoryDataModel {
        private static final int PAGE_SIZE = 65536;
        private static final int PAGE_SHIFT = 16;
        private final MemoryFetcher fetcher;
        private final long address;
        private final int size;
        private final Map<Integer, SoftReference<byte[]>> pageCache = Maps.newHashMap();

        public PagedMemoryDataModel(MemoryFetcher fetcher, long address, long size) {
            this.fetcher = fetcher;
            this.address = address;
            this.size = (int)size;
        }

        public static boolean shouldUsePagedModel(long size) {
            return size >= 131072L;
        }

        @Override
        public long getAddress() {
            return this.address;
        }

        @Override
        public int getByteCount() {
            return this.size;
        }

        @Override
        public ListenableFuture<MemorySegment> get(int offset, int length) {
            int lastPage;
            offset = Math.min(this.size - 1, offset);
            length = Math.min(this.size - offset, length);
            int firstPage = PagedMemoryDataModel.getPageForOffset(offset);
            if (firstPage == (lastPage = PagedMemoryDataModel.getPageForOffset(offset + length))) {
                return this.getPage(firstPage, PagedMemoryDataModel.getOffsetInPage(offset), length);
            }
            ArrayList futures = Lists.newArrayList();
            futures.add(this.getPage(firstPage, PagedMemoryDataModel.getOffsetInPage(offset), 65536 - PagedMemoryDataModel.getOffsetInPage(offset)));
            int page = firstPage + 1;
            int left = length - 65536 + PagedMemoryDataModel.getOffsetInPage(offset);
            while (page <= lastPage) {
                futures.add(this.getPage(page, 0, Math.min(left, 65536)));
                ++page;
                left -= 65536;
            }
            final int totalLength = length;
            return Futures.transform((ListenableFuture)Futures.allAsList((Iterable)futures), (Function)new Function<List<MemorySegment>, MemorySegment>(){

                public MemorySegment apply(List<MemorySegment> segments) {
                    int done;
                    int count;
                    byte[] data = new byte[totalLength];
                    Iterator<MemorySegment> it = segments.iterator();
                    for (done = 0; it.hasNext() && done < totalLength; done += count) {
                        MemorySegment segment = it.next();
                        count = Math.min(totalLength - done, segment.myLength);
                        System.arraycopy(segment.myData, segment.myOffset, data, done, count);
                    }
                    return new MemorySegment(data, 0, done);
                }
            });
        }

        private static int getPageForOffset(int offset) {
            return offset >>> 16;
        }

        private static int getOffsetForPage(int page) {
            return page << 16;
        }

        private static int getOffsetInPage(int offset) {
            return offset & 0xFFFF;
        }

        private ListenableFuture<MemorySegment> getPage(final int page, final int offset, final int length) {
            byte[] data = this.getFromCache(page);
            if (data != null) {
                return Futures.immediateFuture((Object)new MemorySegment(data, offset, length));
            }
            long base = this.address + (long)PagedMemoryDataModel.getOffsetForPage(page);
            return Futures.transform(this.fetcher.get(base, (int)Math.min(this.address + (long)this.size - base, 65536L)), (Function)new Function<byte[], MemorySegment>(){

                public MemorySegment apply(byte[] data) {
                    this.addToCache(page, data);
                    return new MemorySegment(data, offset, length);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getFromCache(int page) {
            byte[] result = null;
            Map<Integer, SoftReference<byte[]>> map = this.pageCache;
            synchronized (map) {
                SoftReference<byte[]> reference = this.pageCache.get(page);
                if (reference != null && (result = (byte[])reference.get()) == null) {
                    this.pageCache.remove(page);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addToCache(int page, byte[] data) {
            Map<Integer, SoftReference<byte[]>> map = this.pageCache;
            synchronized (map) {
                this.pageCache.put(page, (SoftReference<byte[]>)new SoftReference((Object)data));
            }
        }

        @Override
        public MemoryDataModel align(int byteAlign) {
            return this;
        }

        public static interface MemoryFetcher {
            public ListenableFuture<byte[]> get(long var1, long var3);
        }
    }

    private static class ImmediateMemoryDataModel
    implements MemoryDataModel {
        private final long address;
        private final byte[] data;

        public ImmediateMemoryDataModel(long address, byte[] data) {
            this.address = address;
            this.data = data;
        }

        @Override
        public long getAddress() {
            return this.address;
        }

        @Override
        public int getByteCount() {
            return this.data.length;
        }

        @Override
        public ListenableFuture<MemorySegment> get(int offset, int length) {
            return Futures.immediateFuture((Object)new MemorySegment(this.data, offset, Math.min(this.data.length - offset, length)));
        }

        @Override
        public MemoryDataModel align(int align) {
            int remainder = this.data.length % align;
            return remainder == 0 ? this : new ImmediateMemoryDataModel(this.address, Arrays.copyOf(this.data, this.data.length + align - remainder));
        }
    }

    private static interface MemoryDataModel {
        public long getAddress();

        public int getByteCount();

        public ListenableFuture<MemorySegment> get(int var1, int var2);

        public MemoryDataModel align(int var1);
    }

    private static class MemoryPanel
    extends JComponent
    implements Scrollable,
    DataProvider,
    CopyProvider {
        private MemoryModel myModel;
        private final EditorColorsScheme myTheme;
        private Range<Integer> mySelectionRange = null;
        private final Point mySelectionStart = new Point();
        private final Point mySelectionEnd = new Point();
        private final Runnable myRepainter = new Runnable(){

            @Override
            public void run() {
                this.repaint();
            }
        };
        private int myLineHeight;
        private int myAscent;
        private int myCharWidth;

        public MemoryPanel(MemoryModel model) {
            this.myModel = model;
            this.myTheme = EditorColorsManager.getInstance().getGlobalScheme();
            this.setCursor(new Cursor(2));
            this.setFocusable(true);
            MouseAdapter mouseHandler = new MouseAdapter(){
                private final Point mySelectionInitiation = new Point();
                private boolean mySelecting;

                @Override
                public void mousePressed(MouseEvent e) {
                    this.requestFocus();
                    if (this.isSelectionButton(e)) {
                        if ((e.getModifiersEx() & 0x40) != 0 && mySelectionRange != null) {
                            this.mySelecting = true;
                            this.updateSelection(e);
                        } else {
                            this.startSelecting(e);
                        }
                        this.repaint();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (!this.isSelectionButton(e)) {
                        this.mySelecting = false;
                        if (mySelectionRange != null && mySelectionStart.equals(mySelectionEnd)) {
                            mySelectionRange = null;
                            this.repaint();
                        }
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (this.isSelectionButton(e)) {
                        if (mySelectionRange == null) {
                            this.startSelecting(e);
                        } else {
                            this.updateSelection(e);
                        }
                    }
                }

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    JBScrollPane ancestor;
                    if (this.mySelecting) {
                        if (mySelectionRange == null) {
                            this.startSelecting(e);
                        } else {
                            this.updateSelection(e);
                        }
                    }
                    if ((ancestor = (JBScrollPane)SwingUtilities.getAncestorOfClass(JBScrollPane.class, this)) != null) {
                        MouseWheelEvent converted = (MouseWheelEvent)SwingUtilities.convertMouseEvent(this, e, (Component)ancestor);
                        for (MouseWheelListener listener : ancestor.getMouseWheelListeners()) {
                            listener.mouseWheelMoved(converted);
                        }
                    }
                }

                private void startSelecting(MouseEvent e) {
                    this.mySelecting = true;
                    int y = e.getY() / this.getLineHeight();
                    if (y < 0 || y >= myModel.getLineCount()) {
                        mySelectionRange = null;
                        return;
                    }
                    this.mySelectionInitiation.setLocation(this.getX(e), e.getY() / this.getLineHeight());
                    mySelectionStart.setLocation(this.mySelectionInitiation);
                    mySelectionEnd.setLocation(mySelectionStart);
                    mySelectionRange = myModel.getSelectableRegion(((MemoryPanel)this).mySelectionStart.x);
                }

                private void updateSelection(MouseEvent e) {
                    int x = Math.max((Integer)mySelectionRange.getFrom(), Math.min((Integer)mySelectionRange.getTo(), this.getX(e)));
                    int y = Math.max(0, e.getY() / this.getLineHeight());
                    if (y >= myModel.getLineCount()) {
                        y = myModel.getLineCount() - 1;
                        x = (Integer)mySelectionRange.getTo();
                    }
                    if (y < this.mySelectionInitiation.y || y == this.mySelectionInitiation.y && x < this.mySelectionInitiation.x) {
                        mySelectionStart.setLocation(x, y);
                        mySelectionEnd.setLocation(this.mySelectionInitiation);
                    } else {
                        mySelectionStart.setLocation(this.mySelectionInitiation);
                        mySelectionEnd.setLocation(x, y);
                    }
                    this.repaint();
                }

                private int getX(MouseEvent e) {
                    int charWidth = this.getCharWidth();
                    return (e.getX() + charWidth / 2) / charWidth;
                }

                private boolean isSelectionButton(MouseEvent e) {
                    return (e.getModifiersEx() & 0x400) != 0;
                }
            };
            this.addMouseListener(mouseHandler);
            this.addMouseMotionListener(mouseHandler);
            this.addMouseWheelListener(mouseHandler);
        }

        public void setModel(MemoryModel model) {
            this.myModel = model;
            this.mySelectionRange = null;
            this.revalidate();
            this.repaint();
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return this;
            }
            return null;
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/editors/gfxtrace/controllers/MemoryController$MemoryPanel", "isCopyEnabled"));
            }
            return this.mySelectionRange != null && !this.mySelectionStart.equals(this.mySelectionEnd);
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/editors/gfxtrace/controllers/MemoryController$MemoryPanel", "isCopyVisible"));
            }
            return true;
        }

        public void performCopy(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/editors/gfxtrace/controllers/MemoryController$MemoryPanel", "performCopy"));
            }
            if (this.isCopyEnabled(dataContext)) {
                Futures.addCallback(this.myModel.getTransferable(this.mySelectionRange, this.mySelectionStart, this.mySelectionEnd), (FutureCallback)new FutureCallback<Transferable>(){

                    public void onFailure(Throwable t) {
                        LOG.error("Failed to load memory", t);
                    }

                    public void onSuccess(Transferable result) {
                        CopyPasteManager.getInstance().setContents(result);
                    }
                });
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension result = new Dimension(this.myModel.getLineLength() * this.getCharWidth(), this.myModel.getLineCount() * this.getLineHeight());
            if (this.getParent() instanceof JViewport) {
                Dimension parent = ((JViewport)this.getParent()).getExtentSize();
                result.width = Math.max(parent.width, result.width);
                result.height = Math.max(parent.height, result.height);
            }
            return result;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.setFont(this.myTheme.getFont(EditorFontType.PLAIN));
            this.initMeasurements();
            this.setBackground(this.myTheme.getDefaultBackground());
            this.setForeground(this.myTheme.getDefaultForeground());
            Rectangle clip = g.getClipBounds();
            g.setColor(this.getBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            g.setColor(this.getForeground());
            int lineHeight = this.getLineHeight();
            int charWidth = this.getCharWidth();
            int startRow = Math.max(0, Math.min(this.myModel.getLineCount() - 1, clip.y / lineHeight));
            int endRow = Math.max(0, Math.min(this.myModel.getLineCount(), (clip.y + clip.height + lineHeight - 1) / lineHeight));
            boolean selectionVisible = false;
            if (this.mySelectionRange != null && startRow <= this.mySelectionEnd.y && this.mySelectionStart.y <= endRow) {
                selectionVisible = true;
                g.setColor(this.myTheme.getColor(EditorColors.SELECTION_BACKGROUND_COLOR));
                if (this.mySelectionStart.y == this.mySelectionEnd.y) {
                    g.fillRect(this.mySelectionStart.x * charWidth, this.mySelectionStart.y * lineHeight, (this.mySelectionEnd.x - this.mySelectionStart.x) * charWidth, lineHeight);
                } else {
                    g.fillRect(this.mySelectionStart.x * charWidth, this.mySelectionStart.y * lineHeight, ((Integer)this.mySelectionRange.getTo() - this.mySelectionStart.x) * charWidth, lineHeight);
                    g.fillRect((Integer)this.mySelectionRange.getFrom() * charWidth, this.mySelectionEnd.y * lineHeight, (this.mySelectionEnd.x - (Integer)this.mySelectionRange.getFrom()) * charWidth, lineHeight);
                    g.fillRect((Integer)this.mySelectionRange.getFrom() * charWidth, (this.mySelectionStart.y + 1) * lineHeight, ((Integer)this.mySelectionRange.getTo() - (Integer)this.mySelectionRange.getFrom()) * charWidth, (this.mySelectionEnd.y - this.mySelectionStart.y - 1) * lineHeight);
                }
                g.setColor(this.getForeground());
            }
            g.translate(0, startRow * lineHeight);
            int y = this.getAscent();
            if (!selectionVisible) {
                Iterator<Segment> it = this.myModel.getLines(startRow, endRow, this.myRepainter);
                while (it.hasNext()) {
                    Segment segment = it.next();
                    g.drawChars(segment.array, segment.offset, segment.count, 0, y);
                    y += lineHeight;
                }
            } else {
                Segment segment;
                int row = startRow;
                int rangeWidth = (Integer)this.mySelectionRange.getTo() - (Integer)this.mySelectionRange.getFrom();
                int fromWidth = (Integer)this.mySelectionRange.getFrom() * charWidth;
                int toWidth = (Integer)this.mySelectionRange.getTo() * charWidth;
                Iterator<Segment> it = this.myModel.getLines(startRow, endRow, this.myRepainter);
                while (it.hasNext() && row < this.mySelectionStart.y) {
                    segment = it.next();
                    g.drawChars(segment.array, segment.offset, segment.count, 0, y);
                    ++row;
                    y += lineHeight;
                }
                while (it.hasNext() && row == this.mySelectionStart.y) {
                    segment = it.next();
                    g.drawChars(segment.array, segment.offset, this.mySelectionStart.x, 0, y);
                    g.setColor(this.myTheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR));
                    if (this.mySelectionStart.y == this.mySelectionEnd.y) {
                        g.drawChars(segment.array, segment.offset + this.mySelectionStart.x, this.mySelectionEnd.x - this.mySelectionStart.x, this.mySelectionStart.x * charWidth, y);
                        g.setColor(this.getForeground());
                        g.drawChars(segment.array, segment.offset + this.mySelectionEnd.x, segment.count - this.mySelectionEnd.x, this.mySelectionEnd.x * charWidth, y);
                    } else {
                        g.drawChars(segment.array, segment.offset + this.mySelectionStart.x, (Integer)this.mySelectionRange.getTo() - this.mySelectionStart.x, this.mySelectionStart.x * charWidth, y);
                        g.setColor(this.getForeground());
                        g.drawChars(segment.array, segment.offset + (Integer)this.mySelectionRange.getTo(), segment.count - (Integer)this.mySelectionRange.getTo(), toWidth, y);
                    }
                    ++row;
                    y += lineHeight;
                }
                while (it.hasNext() && row < this.mySelectionEnd.y) {
                    segment = it.next();
                    g.drawChars(segment.array, segment.offset, (Integer)this.mySelectionRange.getFrom(), 0, y);
                    g.setColor(this.myTheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR));
                    g.drawChars(segment.array, segment.offset + (Integer)this.mySelectionRange.getFrom(), rangeWidth, fromWidth, y);
                    g.setColor(this.getForeground());
                    g.drawChars(segment.array, segment.offset + (Integer)this.mySelectionRange.getTo(), segment.count - (Integer)this.mySelectionRange.getTo(), toWidth, y);
                    ++row;
                    y += lineHeight;
                }
                while (it.hasNext() && row == this.mySelectionEnd.y) {
                    segment = it.next();
                    g.drawChars(segment.array, segment.offset, (Integer)this.mySelectionRange.getFrom(), 0, y);
                    g.setColor(this.myTheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR));
                    g.drawChars(segment.array, segment.offset + (Integer)this.mySelectionRange.getFrom(), this.mySelectionEnd.x - (Integer)this.mySelectionRange.getFrom(), fromWidth, y);
                    g.setColor(this.getForeground());
                    g.drawChars(segment.array, segment.offset + this.mySelectionEnd.x, segment.count - this.mySelectionEnd.x, this.mySelectionEnd.x * charWidth, y);
                    ++row;
                    y += lineHeight;
                }
                while (it.hasNext()) {
                    segment = it.next();
                    g.drawChars(segment.array, segment.offset, segment.count, 0, y);
                    ++row;
                    y += lineHeight;
                }
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return orientation == 1 ? this.getLineHeight() : this.getCharWidth();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return orientation == 1 ? visibleRect.height - visibleRect.height % this.getLineHeight() : visibleRect.width - visibleRect.width % this.getCharWidth();
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        private int getLineHeight() {
            if (this.myLineHeight <= 0) {
                this.initMeasurements();
            }
            return this.myLineHeight;
        }

        public int getAscent() {
            if (this.myAscent <= 0) {
                this.initMeasurements();
            }
            return this.myAscent;
        }

        private int getCharWidth() {
            if (this.myCharWidth <= 0) {
                this.initMeasurements();
            }
            return this.myCharWidth;
        }

        private void initMeasurements() {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.myLineHeight = metrics.getHeight();
            this.myAscent = metrics.getAscent();
            this.myCharWidth = metrics.charWidth(' ');
        }
    }

    private static class EmptyPanel
    extends JComponent {
        private final StatusText myEmptyText = new StatusText(){

            protected boolean isStatusVisible() {
                return true;
            }
        };

        public EmptyPanel() {
            this.myEmptyText.setText("Select a memory range in the command list");
            this.myEmptyText.attachTo((Component)this);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.myEmptyText.paint((Component)this, graphics);
        }
    }

    private static enum DataType {
        Bytes{

            @Override
            public MemoryModel getMemoryModel(MemoryDataModel memory) {
                return new BytesMemoryModel(memory);
            }
        }
        ,
        Shorts{

            @Override
            public MemoryModel getMemoryModel(MemoryDataModel memory) {
                return new ShortsMemoryModel(memory);
            }
        }
        ,
        Ints{

            @Override
            public MemoryModel getMemoryModel(MemoryDataModel memory) {
                return new IntsMemoryModel(memory);
            }
        }
        ,
        Floats{

            @Override
            public MemoryModel getMemoryModel(MemoryDataModel memory) {
                return new FloatsMemoryModel(memory);
            }
        }
        ,
        Doubles{

            @Override
            public MemoryModel getMemoryModel(MemoryDataModel memory) {
                return new DoublesMemoryModel(memory);
            }
        };


        public abstract MemoryModel getMemoryModel(MemoryDataModel var1);
    }
}

