/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.PreciseRevision;
import com.android.tools.idea.actions.AndroidAssetStudioAction;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.npw.VectorAssetStudioWizard;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;

public class AndroidVectorAssetStudioAction
extends AndroidAssetStudioAction {
    private static final String updateMessage = "<html><p>To support vector assets when minimal SDK version is less than 21,<br>Android plugin for Gradle version must be 1.4 or above,<br>such that Android Studio will convert vector assets into PNG images at build time.</p><p>See <a href=\"https://developer.android.com/tools/building/plugin-for-gradle.html#projectBuildFile\">here</a> for how to update the version of Android plugin for Gradle.</p></html>";
    private static final FullRevision VECTOR_ASSET_GENERATION_REVISION = new FullRevision(1, 4, 0);
    private static final int VECTOR_DRAWABLE_API_LEVEL = 21;

    public AndroidVectorAssetStudioAction() {
        super("Vector Asset", "Open Vector Asset Studio to create an image asset", AndroidIcons.Android);
    }

    @Override
    protected void showWizardAndCreateAsset(Project project, Module module, VirtualFile targetFile) {
        VectorAssetStudioWizard dialog;
        AndroidGradleModel androidModel = AndroidGradleModel.get(module);
        if (androidModel != null) {
            AndroidVersion minSdkVersion = androidModel.getMinSdkVersion();
            String version = androidModel.getAndroidProject().getModelVersion();
            PreciseRevision revision = PreciseRevision.parseRevision((String)version);
            if (revision.compareTo(VECTOR_ASSET_GENERATION_REVISION, FullRevision.PreviewComparison.IGNORE) < 0 && (minSdkVersion == null || minSdkVersion.getApiLevel() < 21)) {
                Messages.showErrorDialog((Project)project, (String)updateMessage, (String)"Need Newer Android Plugin for Gradle");
                return;
            }
        }
        if (!(dialog = new VectorAssetStudioWizard(project, module, targetFile)).showAndGet()) {
            return;
        }
        dialog.createAssets();
    }
}

