/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Optional;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.TypeCompatibilityModelProjectionSupport;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class UnmanagedModelProjection<M>
extends TypeCompatibilityModelProjectionSupport<M> {
    public static <M> ModelProjection of(ModelType<M> type) {
        return new UnmanagedModelProjection<M>(type);
    }

    public static <M> ModelProjection of(Class<M> type) {
        return UnmanagedModelProjection.of(ModelType.of(type));
    }

    public UnmanagedModelProjection(ModelType<M> type) {
        super(type, true, true);
    }

    public UnmanagedModelProjection(ModelType<M> type, boolean canBeViewedAsReadOnly, boolean canBeViewedAsWritable) {
        super(type, canBeViewedAsReadOnly, canBeViewedAsWritable);
    }

    @Override
    protected ModelView<M> toView(MutableModelNode modelNode, ModelRuleDescriptor ruleDescriptor, boolean writable) {
        Object instance = Cast.uncheckedCast((Object)modelNode.getPrivateData());
        return InstanceModelView.of(modelNode.getPath(), this.getType(), instance);
    }

    @Override
    public Optional<String> getValueDescription(MutableModelNode modelNodeInternal) {
        ModelView<Object> modelView = this.asImmutable(ModelType.untyped(), modelNodeInternal, null);
        Object instance = modelView.getInstance();
        if (null != instance && !JavaReflectionUtil.hasDefaultToString((Object)instance)) {
            return Optional.fromNullable((Object)instance.toString());
        }
        return Optional.absent();
    }
}

