/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.AbstractScrollBarUI;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.TwoWayAnimator;
import com.intellij.util.ui.RegionPainter;
import java.awt.Graphics2D;
import javax.swing.JComponent;

final class DefaultScrollBarUI
extends AbstractScrollBarUI {
    private float myTrackValue;
    private float myThumbValue;
    private TwoWayAnimator myTrackAnimator = new TwoWayAnimator("ScrollBarTrack", 6, 125, 150, 300){

        @Override
        void onFrame(int frame, int maxFrame) {
            DefaultScrollBarUI.this.myTrackValue = (float)frame / (float)maxFrame;
            DefaultScrollBarUI.this.setTrackVisible(frame > 0);
            DefaultScrollBarUI.this.repaint();
        }
    };
    private TwoWayAnimator myThumbAnimator = new TwoWayAnimator("ScrollBarThumb", 6, 125, 150, 300){

        @Override
        void onFrame(int frame, int maxFrame) {
            DefaultScrollBarUI.this.myThumbValue = (float)frame / (float)maxFrame;
            DefaultScrollBarUI.this.repaint();
        }
    };

    DefaultScrollBarUI() {
    }

    @Override
    int getThickness() {
        return this.scale(this.isOpaque() ? 13 : 14);
    }

    @Override
    int getMinimalThickness() {
        return this.scale(10);
    }

    @Override
    void onTrackHover(boolean hover) {
        if (hover) {
            this.myTrackAnimator.startForward();
        } else {
            this.myTrackAnimator.startBackward();
        }
    }

    @Override
    void onThumbHover(boolean hover) {
        if (hover) {
            this.myThumbAnimator.startForward();
        } else {
            this.myThumbAnimator.startBackward();
        }
    }

    @Override
    void paintTrack(Graphics2D g, int x, int y, int width, int height, JComponent c) {
        RegionPainter<Float> p = DefaultScrollBarUI.isDark(c) ? JBScrollPane.TRACK_DARK_PAINTER : JBScrollPane.TRACK_PAINTER;
        this.paint(p, g, x, y, width, height, c, this.myTrackValue, false);
    }

    @Override
    void paintThumb(Graphics2D g, int x, int y, int width, int height, JComponent c) {
        RegionPainter<Float> p = DefaultScrollBarUI.isDark(c) ? JBScrollPane.THUMB_DARK_PAINTER : JBScrollPane.THUMB_PAINTER;
        this.paint(p, g, x, y, width, height, c, this.myThumbValue, Registry.is((String)"ide.scroll.thumb.small.if.opaque"));
    }

    private void paint(RegionPainter<Float> p, Graphics2D g, int x, int y, int width, int height, JComponent c, float value, boolean small) {
        if (!c.isOpaque()) {
            JBScrollPane.Alignment alignment = JBScrollPane.Alignment.get(c);
            if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
                int offset = this.getAnimatedValue(width - this.getMinimalThickness());
                if (offset > 0) {
                    width -= offset;
                    if (alignment == JBScrollPane.Alignment.RIGHT) {
                        x += offset;
                    }
                }
            } else {
                int offset = this.getAnimatedValue(height - this.getMinimalThickness());
                if (offset > 0) {
                    height -= offset;
                    if (alignment == JBScrollPane.Alignment.BOTTOM) {
                        y += offset;
                    }
                }
            }
        } else if (small) {
            ++x;
            ++y;
            width -= 2;
            height -= 2;
        }
        p.paint(g, x, y, width, height, Float.valueOf(value));
    }

    private int getAnimatedValue(int value) {
        if (!Registry.is((String)"ide.scroll.bar.expand.animation")) {
            return value;
        }
        if (this.myTrackValue <= 0.0f) {
            return value;
        }
        if (this.myTrackValue >= 1.0f) {
            return 0;
        }
        return (int)(0.5f + (float)value * (1.0f - this.myTrackValue));
    }
}

