/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;

public class VcsDescriptor
implements Comparable<VcsDescriptor> {
    private static final Logger LOG = Logger.getInstance(VcsDescriptor.class);
    private final String myName;
    private final boolean myCrawlUpToCheckUnderVcs;
    private final String myDisplayName;
    private final String myAdministrativePattern;
    private boolean myIsNone;

    public VcsDescriptor(String administrativePattern, String displayName, String name, boolean crawlUpToCheckUnderVcs) {
        this.myAdministrativePattern = administrativePattern;
        this.myDisplayName = displayName;
        this.myName = name;
        this.myCrawlUpToCheckUnderVcs = crawlUpToCheckUnderVcs;
    }

    public boolean probablyUnderVcs(final VirtualFile file) {
        if (file == null || !file.isDirectory() || !file.isValid()) {
            return false;
        }
        if (this.myAdministrativePattern == null) {
            return false;
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            public Boolean compute() {
                if (VcsDescriptor.this.checkFileForBeingAdministrative(file)) {
                    return true;
                }
                if (VcsDescriptor.this.myCrawlUpToCheckUnderVcs) {
                    for (VirtualFile current = file.getParent(); current != null; current = current.getParent()) {
                        if (!VcsDescriptor.this.checkFileForBeingAdministrative(current)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private boolean checkFileForBeingAdministrative(final VirtualFile file) {
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            public Boolean compute() {
                String[] patterns;
                for (String pattern : patterns = VcsDescriptor.this.myAdministrativePattern.split(",")) {
                    VirtualFile child = file.findChild(pattern.trim());
                    if (child == null) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(VcsDescriptor.this.myName + " vcs detected: " + pattern + " folder found in " + file + ". Trace: " + ExceptionUtil.getThrowableText((Throwable)new Throwable()));
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public String getDisplayName() {
        return this.myDisplayName == null ? this.myName : this.myDisplayName;
    }

    public String getName() {
        return this.myName;
    }

    @Override
    public int compareTo(VcsDescriptor o) {
        return Comparing.compare((Comparable)((Object)this.myDisplayName), (Comparable)((Object)o.myDisplayName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsDescriptor that = (VcsDescriptor)o;
        return !(this.myName != null ? !this.myName.equals(that.myName) : that.myName != null);
    }

    public boolean isNone() {
        return this.myIsNone;
    }

    public static VcsDescriptor createFictive() {
        VcsDescriptor vcsDescriptor = new VcsDescriptor(null, VcsBundle.message("none.vcs.presentation", new Object[0]), null, false);
        vcsDescriptor.myIsNone = true;
        return vcsDescriptor;
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

