/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateInDirectoryActionBase;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class CreateElementActionBase
extends CreateInDirectoryActionBase {
    protected CreateElementActionBase() {
    }

    protected CreateElementActionBase(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    @NotNull
    protected abstract PsiElement[] invokeDialog(Project var1, PsiDirectory var2);

    @NotNull
    protected abstract PsiElement[] create(String var1, PsiDirectory var2) throws Exception;

    protected abstract String getErrorTitle();

    protected abstract String getCommandName();

    protected abstract String getActionName(PsiDirectory var1, String var2);

    @Override
    public final void actionPerformed(AnActionEvent e) {
        PsiElement[] createdElements;
        IdeView view = e.getData(LangDataKeys.IDE_VIEW);
        if (view == null) {
            return;
        }
        Project project = e.getProject();
        PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null) {
            return;
        }
        for (PsiElement createdElement : createdElements = this.invokeDialog(project, dir)) {
            view.selectElement(createdElement);
        }
    }

    public static String filterMessage(String message) {
        if (message == null) {
            return null;
        }
        String ioExceptionPrefix = "java.io.IOException:";
        message = StringUtil.trimStart((String)message, (String)"java.io.IOException:");
        return message;
    }

    protected class MyInputValidator
    extends ElementCreator
    implements InputValidator {
        private final PsiDirectory myDirectory;
        private PsiElement[] myCreatedElements;

        public MyInputValidator(Project project, PsiDirectory directory) {
            super(project, CreateElementActionBase.this.getErrorTitle());
            this.myCreatedElements = PsiElement.EMPTY_ARRAY;
            this.myDirectory = directory;
        }

        public PsiDirectory getDirectory() {
            return this.myDirectory;
        }

        @Override
        public boolean checkInput(String inputString) {
            return true;
        }

        @Override
        public PsiElement[] create(String newName) throws Exception {
            return CreateElementActionBase.this.create(newName, this.myDirectory);
        }

        @Override
        public String getActionName(String newName) {
            return CreateElementActionBase.this.getActionName(this.myDirectory, newName);
        }

        @Override
        public boolean canClose(String inputString) {
            this.myCreatedElements = this.tryCreate(inputString);
            return this.myCreatedElements.length > 0;
        }

        public final PsiElement[] getCreatedElements() {
            return this.myCreatedElements;
        }
    }
}

