/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.debugger.impl.OutputChecker;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.CompilerTester;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.IdeaTestCase;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ExecutionTestCase
extends IdeaTestCase {
    private OutputChecker myChecker;
    private int myTimeout;
    private static File ourOutputRoot;
    private File myModuleOutputDir;
    private CompilerTester myCompilerTester;

    public ExecutionTestCase() {
        this.setTimeout(300000);
    }

    public void setTimeout(int timeout) {
        this.myTimeout = timeout;
    }

    protected abstract OutputChecker initOutputChecker();

    protected abstract String getTestAppPath();

    @Override
    protected void setUp() throws Exception {
        if (ourOutputRoot == null) {
            ourOutputRoot = FileUtil.createTempDirectory((String)"ExecutionTestCase", null, (boolean)true);
        }
        this.myModuleOutputDir = new File(ourOutputRoot, PathUtil.getFileName(this.getTestAppPath()));
        this.myChecker = this.initOutputChecker();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable)new ThrowableRunnable<Throwable>(){

            public void run() throws Throwable {
                ExecutionTestCase.super.setUp();
            }
        });
        if (!this.myModuleOutputDir.exists()) {
            VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ourOutputRoot);
            ExecutionTestCase.assertNotNull((String)ourOutputRoot.getAbsolutePath(), (Object)vDir);
            vDir.getChildren();
            this.myCompilerTester = new CompilerTester(this.myProject, Arrays.asList(ModuleManager.getInstance(this.myProject).getModules()));
            List<CompilerMessage> messages = this.myCompilerTester.rebuild();
            for (CompilerMessage message : messages) {
                if (message.getCategory() != CompilerMessageCategory.ERROR) continue;
                FileUtil.delete((File)this.myModuleOutputDir);
                ExecutionTestCase.fail((String)("Compilation failed: " + message));
            }
        }
    }

    protected void setUpModule() {
        super.setUpModule();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                String modulePath = ExecutionTestCase.this.getTestAppPath();
                String srcPath = modulePath + File.separator + "src";
                VirtualFile moduleDir = LocalFileSystem.getInstance().findFileByPath(modulePath.replace(File.separatorChar, '/'));
                VirtualFile srcDir = LocalFileSystem.getInstance().findFileByPath(srcPath.replace(File.separatorChar, '/'));
                ModuleRootManager rootManager = ModuleRootManager.getInstance(ExecutionTestCase.this.myModule);
                PsiTestUtil.removeAllRoots((Module)ExecutionTestCase.this.myModule, (Sdk)rootManager.getSdk());
                PsiTestUtil.addContentRoot((Module)ExecutionTestCase.this.myModule, (VirtualFile)moduleDir);
                PsiTestUtil.addSourceRoot((Module)ExecutionTestCase.this.myModule, (VirtualFile)srcDir);
                IdeaTestUtil.setModuleLanguageLevel(ExecutionTestCase.this.myModule, LanguageLevel.JDK_1_8);
                PsiTestUtil.setCompilerOutputPath((Module)ExecutionTestCase.this.myModule, (String)VfsUtilCore.pathToUrl(FileUtil.toSystemIndependentName((String)ExecutionTestCase.this.myModuleOutputDir.getAbsolutePath())), (boolean)false);
            }
        });
    }

    @Override
    protected Sdk getTestProjectJdk() {
        return JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
    }

    public void println(@NonNls String s, Key outputType) {
        this.myChecker.println(s, outputType);
    }

    public void print(String s, Key outputType) {
        this.myChecker.print(s, outputType);
    }

    protected void runBareRunnable(ThrowableRunnable<Throwable> runnable) throws Throwable {
        runnable.run();
    }

    protected void runTest() throws Throwable {
        this.myChecker.init(this.getTestName(true));
        super.runTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        if (this.myCompilerTester != null) {
            this.myCompilerTester.tearDown();
        }
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable)new ThrowableRunnable<Throwable>(){

            public void run() throws Throwable {
                ExecutionTestCase.super.tearDown();
            }
        });
        ExecutionTestCase executionTestCase = this;
        synchronized (executionTestCase) {
            ((Object)((Object)this)).wait(300L);
        }
    }

    protected JavaParameters createJavaParameters(String mainClass) {
        JavaParameters parameters = new JavaParameters();
        parameters.getClassPath().add(this.getAppOutputPath());
        parameters.setMainClass(mainClass);
        parameters.setJdk(JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk());
        parameters.setWorkingDirectory(this.getTestAppPath());
        return parameters;
    }

    protected OutputChecker getChecker() {
        return this.myChecker;
    }

    protected String getAppDataPath() {
        return this.getTestAppPath() + File.separator + "data";
    }

    protected String getAppOptionsPath() {
        return this.getTestAppPath() + File.separator + "config" + File.separator + "options";
    }

    protected String getAppOutputPath() {
        return this.myModuleOutputDir.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitProcess(final @NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/ExecutionTestCase", "waitProcess"));
        }
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, this.getTestRootDisposable());
        final boolean[] isRunning = new boolean[]{true};
        alarm.addRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean[] blArray = isRunning;
                synchronized (isRunning) {
                    boolean b = isRunning[0];
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    if (b) {
                        processHandler.destroyProcess();
                        LOG.error("process was running over " + ExecutionTestCase.this.myTimeout / 1000 + " seconds. Interrupted. ");
                    }
                    return;
                }
            }
        }, this.myTimeout);
        processHandler.waitFor();
        boolean[] blArray = isRunning;
        synchronized (isRunning) {
            isRunning[0] = false;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            Disposer.dispose((Disposable)alarm);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(Runnable r) {
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, this.getTestRootDisposable());
        final Thread thread = Thread.currentThread();
        final boolean[] isRunning = new boolean[]{true};
        alarm.addRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean[] blArray = isRunning;
                synchronized (isRunning) {
                    boolean b = isRunning[0];
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    if (b) {
                        thread.interrupt();
                        LOG.error("test was running over " + ExecutionTestCase.this.myTimeout / 1000 + " seconds. Interrupted. ");
                    }
                    return;
                }
            }
        }, this.myTimeout);
        r.run();
        boolean[] blArray = isRunning;
        synchronized (isRunning) {
            isRunning[0] = false;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            Thread.interrupted();
            return;
        }
    }
}

