/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleProvider;
import javax.swing.Icon;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.xslt.psi.XsltParameter;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.intellij.lang.xpath.xslt.validation.inspections.TemplateInvocationInspection;
import org.intellij.lang.xpath.xslt.validation.inspections.UnusedElementInspection;
import org.intellij.lang.xpath.xslt.validation.inspections.VariableShadowingInspection;
import org.intellij.lang.xpath.xslt.validation.inspections.XsltDeclarationInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltStuffProvider
implements UsageGroupingRuleProvider {
    public static final Class<? extends LocalInspectionTool>[] INSPECTION_CLASSES = new Class[]{UnusedElementInspection.class, TemplateInvocationInspection.class, XsltDeclarationInspection.class, VariableShadowingInspection.class};
    private final UsageGroupingRule[] myUsageGroupingRules = new UsageGroupingRule[]{new TemplateUsageGroupingRule()};

    @NotNull
    public UsageGroupingRule[] getActiveRules(Project project) {
        if (this.myUsageGroupingRules == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltStuffProvider", "getActiveRules"));
        }
        return this.myUsageGroupingRules;
    }

    @NotNull
    public AnAction[] createGroupingActions(UsageView view) {
        if (AnAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltStuffProvider", "createGroupingActions"));
        }
        return AnAction.EMPTY_ARRAY;
    }

    private static class TemplateUsageGroupingRule
    implements UsageGroupingRule {
        private TemplateUsageGroupingRule() {
        }

        @Nullable
        public UsageGroup groupUsage(@NotNull Usage usage) {
            if (usage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "org/intellij/lang/xpath/xslt/impl/XsltStuffProvider$TemplateUsageGroupingRule", "groupUsage"));
            }
            if (usage instanceof UsageInfo2UsageAdapter) {
                PsiReference[] references;
                UsageInfo2UsageAdapter u = (UsageInfo2UsageAdapter)usage;
                UsageInfo usageInfo = u.getUsageInfo();
                if (usageInfo instanceof MoveRenameUsageInfo) {
                    MoveRenameUsageInfo info = (MoveRenameUsageInfo)usageInfo;
                    return TemplateUsageGroupingRule.buildGroup(info.getReferencedElement(), usageInfo, true);
                }
                for (PsiReference reference : references = u.getElement().getReferences()) {
                    if (!reference.getRangeInElement().equals((Object)usageInfo.getRangeInElement())) continue;
                    return TemplateUsageGroupingRule.buildGroup(reference.resolve(), usageInfo, false);
                }
            }
            return null;
        }

        @Nullable
        private static UsageGroup buildGroup(PsiElement referencedElement, UsageInfo u, boolean mustBeForeign) {
            if (referencedElement instanceof XsltParameter) {
                boolean isForeign;
                XsltParameter parameter = (XsltParameter)referencedElement;
                PsiElement element = u.getElement();
                if (element == null) {
                    return null;
                }
                XsltTemplate template = XsltCodeInsightUtil.getTemplate(element, false);
                if (template == null) {
                    return null;
                }
                boolean bl = isForeign = XsltCodeInsightUtil.getTemplate(parameter, false) != template;
                if (template.getMatchExpression() != null && (isForeign || !mustBeForeign)) {
                    return new TemplateUsageGroup(template);
                }
            }
            return null;
        }
    }

    private static class TemplateUsageGroup
    implements UsageGroup {
        private final XsltTemplate myTemplate;

        public TemplateUsageGroup(@NotNull XsltTemplate template) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/intellij/lang/xpath/xslt/impl/XsltStuffProvider$TemplateUsageGroup", "<init>"));
            }
            this.myTemplate = template;
        }

        public Icon getIcon(boolean isOpen) {
            return this.myTemplate.getIcon(0);
        }

        @NotNull
        public String getText(UsageView view) {
            QName mode;
            StringBuilder sb = new StringBuilder();
            XPathExpression expr = this.myTemplate.getMatchExpression();
            if (expr != null) {
                sb.append("match='").append(expr.getText()).append("'");
            }
            if ((mode = this.myTemplate.getMode()) != null) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("mode='").append(mode.toString()).append("'");
            }
            String string = "Template (" + sb.toString() + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltStuffProvider$TemplateUsageGroup", "getText"));
            }
            return string;
        }

        @Nullable
        public FileStatus getFileStatus() {
            return null;
        }

        public boolean isValid() {
            return this.myTemplate.isValid();
        }

        public void update() {
        }

        public int compareTo(UsageGroup usageGroup) {
            TemplateUsageGroup myUsageGroup = (TemplateUsageGroup)usageGroup;
            return this.myTemplate.getTextOffset() - myUsageGroup.myTemplate.getTextOffset();
        }

        public void navigate(boolean requestFocus) {
            ((Navigatable)this.myTemplate.getTag()).navigate(requestFocus);
        }

        public boolean canNavigate() {
            return ((Navigatable)this.myTemplate.getTag()).canNavigate();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateUsageGroup that = (TemplateUsageGroup)o;
            if (!this.myTemplate.equals(that.myTemplate)) {
                return false;
            }
            assert (this.compareTo(that) == 0);
            return true;
        }

        public int hashCode() {
            return this.myTemplate.hashCode();
        }
    }
}

