/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.xpath.XPath2ElementTypes;
import org.intellij.lang.xpath.XPathElementTypes;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathFilterExpression;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.XPathPredicate;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.impl.XPathElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathFilterExpressionImpl
extends XPathElementImpl
implements XPathFilterExpression {
    public XPathFilterExpressionImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public XPathType getType() {
        XPathExpression expression = this.getExpression();
        XPathType xPathType = expression != null ? expression.getType() : XPathType.UNKNOWN;
        if (xPathType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathFilterExpressionImpl", "getType"));
        }
        return xPathType;
    }

    @Override
    @Nullable
    public XPathExpression getExpression() {
        XPathExpression expression = (XPathExpression)this.findChildByClass(XPathExpression.class);
        if (expression != null) {
            return expression;
        }
        XPathNodeTest nt = (XPathNodeTest)this.findChildByClass(XPathNodeTest.class);
        if (nt == null) {
            return null;
        }
        ASTNode node = nt.getNode().findChildByType(XPath2ElementTypes.EXPRESSIONS);
        return node != null ? (XPathExpression)node.getPsi(XPathExpression.class) : null;
    }

    @Override
    @NotNull
    public XPathPredicate getPredicate() {
        ASTNode[] nodes = this.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{XPathElementTypes.PREDICATE}));
        assert (nodes.length == 1) : this.unexpectedPsiAssertion();
        XPathPredicate xPathPredicate = (XPathPredicate)nodes[0].getPsi();
        if (xPathPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/psi/impl/XPathFilterExpressionImpl", "getPredicate"));
        }
        return xPathPredicate;
    }

    @Override
    public void accept(XPathElementVisitor visitor) {
        visitor.visitXPathFilterExpression(this);
    }
}

