/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;

public class MavenRehighlighter {
    private final MergingUpdateQueue queue;

    public MavenRehighlighter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/MavenRehighlighter", "<init>"));
        }
        this.queue = new MergingUpdateQueue(this.getClass().getSimpleName(), 1000, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)project, null, true);
        this.queue.setPassThrough(false);
    }

    public static void rehighlight(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/MavenRehighlighter", "rehighlight"));
        }
        MavenRehighlighter.rehighlight(project, null);
    }

    public static void rehighlight(@NotNull Project project, @Nullable MavenProject mavenProject) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/MavenRehighlighter", "rehighlight"));
        }
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            if (!project.isDisposed()) {
                ((MavenRehighlighter)ServiceManager.getService((Project)project, MavenRehighlighter.class)).queue.queue((Update)new MyUpdate(project, mavenProject));
            }
        }
        finally {
            accessToken.finish();
        }
    }

    private static class MyUpdate
    extends Update {
        private final Project myProject;
        private final MavenProject myMavenProject;

        public MyUpdate(Project project, MavenProject mavenProject) {
            super((Object)project);
            this.myProject = project;
            this.myMavenProject = mavenProject;
        }

        public void run() {
            if (this.myMavenProject == null) {
                for (VirtualFile each : FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()) {
                    this.doRehighlightMavenFile(each);
                }
            } else {
                this.doRehighlightMavenFile(this.myMavenProject.getFile());
            }
        }

        private void doRehighlightMavenFile(VirtualFile file) {
            Document doc = FileDocumentManager.getInstance().getCachedDocument(file);
            if (doc == null) {
                return;
            }
            PsiFile psi = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile(doc);
            if (psi == null) {
                return;
            }
            if (!MavenDomUtil.isMavenFile(psi)) {
                return;
            }
            DaemonCodeAnalyzer daemon = DaemonCodeAnalyzer.getInstance((Project)this.myProject);
            daemon.restart(psi);
        }

        public boolean canEat(Update update) {
            return this.myMavenProject == null || this.myMavenProject == ((MyUpdate)update).myMavenProject;
        }
    }

    private static final class MavenRehighlighterPostStartupActivity
    implements StartupActivity,
    DumbAware {
        private MavenRehighlighterPostStartupActivity() {
        }

        public void runActivity(final @NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/MavenRehighlighter$MavenRehighlighterPostStartupActivity", "runActivity"));
            }
            MavenProjectsManager mavenProjectManager = MavenProjectsManager.getInstance(project);
            mavenProjectManager.addManagerListener(new MavenProjectsManager.Listener(){

                @Override
                public void activated() {
                    MavenRehighlighter.rehighlight(project, null);
                }

                @Override
                public void projectsScheduled() {
                }

                @Override
                public void importAndResolveScheduled() {
                }
            });
            mavenProjectManager.addProjectsTreeListener(new MavenProjectsTree.ListenerAdapter(){

                @Override
                public void projectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> updated, List<MavenProject> deleted) {
                    for (Pair<MavenProject, MavenProjectChanges> each : updated) {
                        MavenRehighlighter.rehighlight(project, (MavenProject)each.first);
                    }
                }

                @Override
                public void projectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, NativeMavenProjectHolder nativeMavenProject) {
                    MavenRehighlighter.rehighlight(project, (MavenProject)projectWithChanges.first);
                }

                @Override
                public void pluginsResolved(MavenProject mavenProject) {
                    MavenRehighlighter.rehighlight(project, mavenProject);
                }

                @Override
                public void foldersResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
                    MavenRehighlighter.rehighlight(project, (MavenProject)projectWithChanges.first);
                }

                @Override
                public void artifactsDownloaded(MavenProject mavenProject) {
                    MavenRehighlighter.rehighlight(project, mavenProject);
                }
            });
        }
    }
}

