/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;

public class MavenArtifactUtil {
    public static final String[] DEFAULT_GROUPS = new String[]{"org.apache.maven.plugins", "org.codehaus.mojo"};
    public static final String MAVEN_PLUGIN_DESCRIPTOR = "META-INF/maven/plugin.xml";
    private static final Map<File, MavenPluginInfo> ourPluginInfoCache = Collections.synchronizedMap(new THashMap());

    @Nullable
    public static MavenPluginInfo readPluginInfo(File localRepository, MavenId mavenId) {
        File file = MavenArtifactUtil.getArtifactFile(localRepository, mavenId.getGroupId(), mavenId.getArtifactId(), mavenId.getVersion(), "jar");
        MavenPluginInfo result = ourPluginInfoCache.get(file);
        if (result == null) {
            result = MavenArtifactUtil.createPluginDocument(file);
            ourPluginInfoCache.put(file, result);
        }
        return result;
    }

    public static boolean hasArtifactFile(File localRepository, MavenId id) {
        return MavenArtifactUtil.hasArtifactFile(localRepository, id, "jar");
    }

    public static boolean hasArtifactFile(File localRepository, MavenId id, String type) {
        return MavenArtifactUtil.getArtifactFile(localRepository, id, type).exists();
    }

    @NotNull
    public static File getArtifactFile(File localRepository, MavenId id, String type) {
        File file = MavenArtifactUtil.getArtifactFile(localRepository, id.getGroupId(), id.getArtifactId(), id.getVersion(), type);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/MavenArtifactUtil", "getArtifactFile"));
        }
        return file;
    }

    @NotNull
    public static File getArtifactFile(File localRepository, MavenId id) {
        File file = MavenArtifactUtil.getArtifactFile(localRepository, id.getGroupId(), id.getArtifactId(), id.getVersion(), "pom");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/MavenArtifactUtil", "getArtifactFile"));
        }
        return file;
    }

    public static boolean isPluginIdEquals(@Nullable String groupId1, @Nullable String artifactId1, @Nullable String groupId2, @Nullable String artifactId2) {
        if (artifactId1 == null) {
            return false;
        }
        if (!artifactId1.equals(artifactId2)) {
            return false;
        }
        if (groupId1 != null) {
            for (String group : DEFAULT_GROUPS) {
                if (!groupId1.equals(group)) continue;
                groupId1 = null;
                break;
            }
        }
        if (groupId2 != null) {
            for (String group : DEFAULT_GROUPS) {
                if (!groupId2.equals(group)) continue;
                groupId2 = null;
                break;
            }
        }
        return Comparing.equal((String)groupId1, (String)groupId2);
    }

    @NotNull
    public static File getArtifactFile(File localRepository, String groupId, String artifactId, String version, String type) {
        File dir = null;
        if (StringUtil.isEmpty((String)groupId)) {
            String each;
            String[] stringArray = DEFAULT_GROUPS;
            int n = stringArray.length;
            for (int i = 0; i < n && !(dir = MavenArtifactUtil.getArtifactDirectory(localRepository, each = stringArray[i], artifactId)).exists(); ++i) {
            }
        } else {
            dir = MavenArtifactUtil.getArtifactDirectory(localRepository, groupId, artifactId);
        }
        if (StringUtil.isEmpty((String)version)) {
            version = MavenArtifactUtil.resolveVersion(dir);
        }
        File file = new File(dir, version + File.separator + artifactId + "-" + version + "." + type);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/MavenArtifactUtil", "getArtifactFile"));
        }
        return file;
    }

    private static File getArtifactDirectory(File localRepository, String groupId, String artifactId) {
        String relativePath = StringUtil.replace((String)groupId, (String)".", (String)File.separator) + File.separator + artifactId;
        return new File(localRepository, relativePath);
    }

    private static String resolveVersion(File pluginDir) {
        File[] children;
        ArrayList<String> versions = new ArrayList<String>();
        try {
            children = pluginDir.listFiles();
            if (children == null) {
                return "";
            }
        }
        catch (Exception e) {
            MavenLog.LOG.warn((Throwable)e);
            return "";
        }
        for (File version : children) {
            if (!version.isDirectory()) continue;
            versions.add(version.getName());
        }
        if (versions.isEmpty()) {
            return "";
        }
        Collections.sort(versions);
        return (String)versions.get(versions.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static MavenPluginInfo createPluginDocument(File file) {
        try {
            if (!file.exists()) {
                return null;
            }
            try (ZipFile jar = new ZipFile(file);){
                MavenPluginInfo mavenPluginInfo;
                ZipEntry entry = jar.getEntry(MAVEN_PLUGIN_DESCRIPTOR);
                if (entry == null) {
                    MavenLog.LOG.info(IndicesBundle.message("repository.plugin.corrupt", file));
                    MavenPluginInfo mavenPluginInfo2 = null;
                    return mavenPluginInfo2;
                }
                InputStream is = jar.getInputStream(entry);
                try {
                    byte[] bytes = FileUtil.loadBytes((InputStream)is);
                    mavenPluginInfo = new MavenPluginInfo(bytes);
                }
                catch (Throwable throwable) {
                    is.close();
                    throw throwable;
                }
                is.close();
                return mavenPluginInfo;
            }
        }
        catch (IOException e) {
            MavenLog.LOG.info((Throwable)e);
            return null;
        }
    }
}

