/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.branch.HgBranchUtil;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgMultiRootBranchConfig
extends DvcsMultiRootBranchConfig<HgRepository> {
    public HgMultiRootBranchConfig(@NotNull Collection<HgRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/branch/HgMultiRootBranchConfig", "<init>"));
        }
        super(repositories);
    }

    @NotNull
    public Collection<String> getLocalBranchNames() {
        List<String> list = HgBranchUtil.getCommonBranches(this.myRepositories);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgMultiRootBranchConfig", "getLocalBranchNames"));
        }
        return list;
    }

    @NotNull
    Collection<String> getBookmarkNames() {
        List<String> list = HgBranchUtil.getCommonBookmarks(this.myRepositories);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/branch/HgMultiRootBranchConfig", "getBookmarkNames"));
        }
        return list;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (HgRepository repository : this.myRepositories) {
            sb.append(repository.getPresentableUrl()).append(":").append(repository.getCurrentBranchName()).append(":").append(repository.getState());
        }
        return sb.toString();
    }
}

