/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.execution.ExecutableValidator;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgProjectConfigurable;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.util.HgUtil;

public class HgExecutableValidator
extends ExecutableValidator {
    private final HgVcs myVcs;

    public HgExecutableValidator(@NotNull Project project, @NotNull HgVcs vcs) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/HgExecutableValidator", "<init>"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/zmlx/hg4idea/HgExecutableValidator", "<init>"));
        }
        super(project, HgVcsMessages.message("hg4idea.executable.notification.title", new Object[0]), HgVcsMessages.message("hg4idea.executable.notification.description", new Object[0]));
        this.myVcs = vcs;
    }

    protected String getCurrentExecutable() {
        return this.myVcs.getGlobalSettings().getHgExecutable();
    }

    @NotNull
    protected String getConfigurableDisplayName() {
        String string = HgProjectConfigurable.DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgExecutableValidator", "getConfigurableDisplayName"));
        }
        return string;
    }

    public boolean isExecutableValid(@NotNull String executable) {
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "org/zmlx/hg4idea/HgExecutableValidator", "isExecutableValid"));
        }
        return HgUtil.isExecutableValid(executable);
    }
}

