/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.treeConflict;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchSaveToFileExecutor
implements ApplyPatchExecutor<TextFilePatchInProgress> {
    private static final Logger LOG = Logger.getInstance(ApplyPatchSaveToFileExecutor.class);
    private final Project myProject;
    private final VirtualFile myBaseForPatch;

    public ApplyPatchSaveToFileExecutor(Project project, VirtualFile baseForPatch) {
        this.myProject = project;
        this.myBaseForPatch = baseForPatch;
    }

    public String getName() {
        return "Save Patch to File";
    }

    public void apply(@NotNull MultiMap<VirtualFile, TextFilePatchInProgress> patchGroups, @Nullable LocalChangeList localList, @Nullable String fileName, @Nullable TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
        VirtualFile baseDir;
        if (patchGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchGroups", "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor", "apply"));
        }
        FileSaverDialog dialog = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save Patch to", "", new String[0]), this.myProject);
        VirtualFileWrapper save = dialog.save(baseDir = this.myProject.getBaseDir(), "TheirsChanges.patch");
        if (save != null) {
            CommitContext commitContext = new CommitContext();
            VirtualFile baseForPatch = this.myBaseForPatch == null ? baseDir : this.myBaseForPatch;
            try {
                List<FilePatch> textPatches = ApplyPatchSaveToFileExecutor.patchGroupsToOneGroup(patchGroups, baseForPatch);
                commitContext.putUserData(BaseRevisionTextPatchEP.ourPutBaseRevisionTextKey, (Object)false);
                PatchWriter.writePatches((Project)this.myProject, (String)save.getFile().getPath(), textPatches, (CommitContext)commitContext, (Charset)CharsetToolkit.UTF8_CHARSET);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((Project)ApplyPatchSaveToFileExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{e.getMessage()}), (String)CommonBundle.getErrorTitle());
                    }
                }, null, (Project)this.myProject);
            }
        }
    }

    public static List<FilePatch> patchGroupsToOneGroup(MultiMap<VirtualFile, TextFilePatchInProgress> patchGroups, VirtualFile baseDir) throws IOException {
        ArrayList<FilePatch> textPatches = new ArrayList<FilePatch>();
        String baseDirPath = baseDir.getPath();
        for (Map.Entry entry : patchGroups.entrySet()) {
            VirtualFile vf = (VirtualFile)entry.getKey();
            String currBasePath = vf.getPath();
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)vf, (VirtualFile)baseDir, (char)'/');
            boolean toConvert = !StringUtil.isEmptyOrSpaces((String)relativePath) && !".".equals(relativePath);
            for (TextFilePatchInProgress patchInProgress : (Collection)entry.getValue()) {
                TextFilePatch patch = (TextFilePatch)patchInProgress.getPatch();
                if (toConvert) {
                    patch.setBeforeName(ApplyPatchSaveToFileExecutor.convertRelativePath(patch.getBeforeName(), currBasePath, baseDirPath));
                    patch.setAfterName(ApplyPatchSaveToFileExecutor.convertRelativePath(patch.getAfterName(), currBasePath, baseDirPath));
                }
                textPatches.add((FilePatch)patch);
            }
        }
        return textPatches;
    }

    private static String convertRelativePath(String pathInPatch, String currentBase, String baseDirPath) throws IOException {
        if (StringUtil.isEmptyOrSpaces((String)pathInPatch)) {
            return pathInPatch;
        }
        File currentPath = new File(currentBase, pathInPatch);
        return FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)baseDirPath), (String)FileUtil.toSystemIndependentName((String)currentPath.getCanonicalPath()), (char)'/');
    }
}

