/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsCheckOut;

import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsIgnore.IgnoreFileFilter;
import com.intellij.cvsSupport2.cvsoperations.common.CvsCommandOperation;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.cvsCheckOut.CheckoutAdminReader;
import com.intellij.cvsSupport2.cvsoperations.cvsCheckOut.CheckoutAdminWriter;
import com.intellij.cvsSupport2.javacvsImpl.io.SendTextFilePreprocessor;
import com.intellij.cvsSupport2.keywordSubstitution.KeywordSubstitutionWrapper;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.file.ILocalFileReader;
import org.netbeans.lib.cvsclient.file.ISendTextFilePreprocessor;
import org.netbeans.lib.cvsclient.file.LocalFileReader;
import org.netbeans.lib.cvsclient.util.IIgnoreFileFilter;

public class CheckoutProjectOperation
extends CvsCommandOperation {
    private final String[] myModuleNames;
    private final CvsEnvironment myEnvironment;
    private final boolean myMakeNewFilesReadOnly;
    private final File myRoot;
    private final String myAlternateCheckoutDirectory;
    private final boolean myPruneEmptyDirectories;
    private final KeywordSubstitution myKeywordSubstitution;

    public static CheckoutProjectOperation createTestInstance(CvsEnvironment env, String moduleName, File targetLocation) {
        return CheckoutProjectOperation.create(env, new String[]{moduleName}, targetLocation, false, false);
    }

    public CheckoutProjectOperation(String[] moduleNames, CvsEnvironment environment, boolean makeNewFilesReadOnly, File root, String alternateCheckoutDirectory, boolean pruneEmptyDirectories, KeywordSubstitution keywordSubstitution) {
        super(new CheckoutAdminReader(), new CheckoutAdminWriter(CodeStyleSettingsManager.getInstance().getCurrentSettings().getLineSeparator(), CvsApplicationLevelConfiguration.getCharset()));
        this.myModuleNames = moduleNames;
        this.myEnvironment = environment;
        this.myMakeNewFilesReadOnly = makeNewFilesReadOnly;
        this.myRoot = root;
        this.myAlternateCheckoutDirectory = alternateCheckoutDirectory;
        this.myPruneEmptyDirectories = pruneEmptyDirectories;
        this.myKeywordSubstitution = keywordSubstitution;
    }

    public static CheckoutProjectOperation create(CvsEnvironment env, String[] moduleName, File targetLocation, boolean useAlternativeCheckoutDir, boolean makeNewFilesReadOnly) {
        String directory;
        File root;
        CvsApplicationLevelConfiguration config = CvsApplicationLevelConfiguration.getInstance();
        KeywordSubstitutionWrapper substitution = KeywordSubstitutionWrapper.getValue(config.CHECKOUT_KEYWORD_SUBSTITUTION);
        if (useAlternativeCheckoutDir && targetLocation.getParentFile() == null) {
            root = targetLocation;
            directory = CheckoutProjectOperation.getModuleRootName(moduleName);
        } else if (useAlternativeCheckoutDir) {
            root = targetLocation.getParentFile();
            directory = targetLocation.getName();
        } else {
            root = targetLocation;
            directory = null;
        }
        return new CheckoutProjectOperation(moduleName, env, makeNewFilesReadOnly, root, directory, config.CHECKOUT_PRUNE_EMPTY_DIRECTORIES, substitution == null ? null : substitution.getSubstitution());
    }

    private static String getModuleRootName(String[] moduleNames) {
        File current = new File(moduleNames[0]);
        while (current.getParentFile() != null) {
            current = current.getParentFile();
        }
        return current.getName();
    }

    @Override
    protected ILocalFileReader createLocalFileReader() {
        return new LocalFileReader((ISendTextFilePreprocessor)new SendTextFilePreprocessor());
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        CheckoutCommand command = new CheckoutCommand((ThrowableRunnable)new ThrowableRunnable<IOCommandException>(){

            public void run() throws IOCommandException {
                ((CheckoutAdminWriter)CheckoutProjectOperation.this.myAdminWriter).finish();
            }
        });
        command.setRecursive(true);
        for (String myModuleName : this.myModuleNames) {
            command.addModule(myModuleName);
        }
        root.getRevisionOrDate().setForCommand((Command)command);
        command.setAlternativeCheckoutDirectory(this.myAlternateCheckoutDirectory);
        command.setPruneDirectories(this.myPruneEmptyDirectories);
        command.setKeywordSubstitution(this.myKeywordSubstitution);
        return command;
    }

    @Override
    protected Collection<CvsRootProvider> getAllCvsRoots() {
        return Collections.singleton(CvsRootProvider.createOn(this.getRoot(), this.myEnvironment));
    }

    private File getRoot() {
        return this.myRoot;
    }

    @Override
    protected IIgnoreFileFilter getIgnoreFileFilter() {
        return new IgnoreFileFilter();
    }

    @Override
    protected String getOperationName() {
        return "checkout";
    }

    @Override
    public void modifyOptions(GlobalOptions options) {
        super.modifyOptions(options);
        options.setCheckedOutFilesReadOnly(this.myMakeNewFilesReadOnly);
    }

    @Override
    public boolean runInReadThread() {
        return false;
    }
}

