/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.util.PropertyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;

public class JavaFxScopeEnlarger
extends UseScopeEnlarger {
    @Nullable
    public SearchScope getAdditionalUseScope(@NotNull PsiElement element) {
        PsiElement declarationScope;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxScopeEnlarger", "getAdditionalUseScope"));
        }
        PsiClass containingClass = null;
        if (element instanceof PsiField) {
            containingClass = ((PsiField)element).getContainingClass();
        } else if (element instanceof PsiParameter && (declarationScope = ((PsiParameter)element).getDeclarationScope()) instanceof PsiMethod && PropertyUtil.isSimplePropertySetter((PsiMethod)((PsiMethod)declarationScope))) {
            containingClass = ((PsiMethod)declarationScope).getContainingClass();
        }
        if (containingClass != null && (element instanceof PsiField && !((PsiField)element).hasModifierProperty("public") && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiField)element), (String)"javafx.fxml.FXML", (boolean)false) || element instanceof PsiParameter)) {
            Project project = element.getProject();
            String qualifiedName = containingClass.getQualifiedName();
            if (qualifiedName != null && !JavaFxControllerClassIndex.findFxmlWithController(project, qualifiedName).isEmpty()) {
                GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)project);
                return new DelegatingGlobalSearchScope(projectScope){

                    public boolean contains(@NotNull VirtualFile file) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxScopeEnlarger$1", "contains"));
                        }
                        return super.contains(file) && JavaFxFileTypeFactory.isFxml(file);
                    }
                };
            }
        }
        return null;
    }
}

