/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.descriptors;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.FxmlConstants;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassBackedElementDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxDefaultPropertyAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxStaticSetterAttributeDescriptor;

public class JavaFxDefaultPropertyElementDescriptor
implements XmlElementDescriptor,
Validator<XmlTag> {
    private final String myName;
    private final XmlTag myXmlTag;

    public JavaFxDefaultPropertyElementDescriptor(String name, XmlTag tag) {
        this.myName = name;
        this.myXmlTag = tag;
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public String getDefaultName() {
        return this.getName();
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        JavaFxClassBackedElementDescriptor tagDescriptor = this.getFxRootTagDescriptor(context);
        if (tagDescriptor != null) {
            return tagDescriptor.getElementsDescriptors(context);
        }
        return XmlElementDescriptor.EMPTY_ARRAY;
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        String name = childTag.getName();
        if ("fx:define".equals(this.myName)) {
            if (FxmlConstants.FX_DEFAULT_ELEMENTS.contains(name)) {
                return new JavaFxDefaultPropertyElementDescriptor(name, childTag);
            }
            return new JavaFxClassBackedElementDescriptor(name, childTag);
        }
        if ("fx:root".equals(this.myName)) {
            JavaFxClassBackedElementDescriptor tagDescriptor = this.getFxRootTagDescriptor(contextTag);
            if (tagDescriptor != null) {
                return tagDescriptor.getElementDescriptor(childTag, contextTag);
            }
            return new JavaFxClassBackedElementDescriptor(name, childTag);
        }
        return null;
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        List<String> defaultAttributeList = FxmlConstants.FX_ELEMENT_ATTRIBUTES.get(this.getName());
        if (defaultAttributeList != null) {
            XmlTag includedRoot;
            JavaFxClassBackedElementDescriptor rootTagDescriptor;
            XmlAttributeDescriptor[] attributesDescriptors;
            XmlElementDescriptor referencedDescriptor;
            ArrayList<XmlAttributeDescriptor> descriptors = new ArrayList<XmlAttributeDescriptor>();
            for (String defaultAttrName : defaultAttributeList) {
                descriptors.add((XmlAttributeDescriptor)new JavaFxDefaultPropertyAttributeDescriptor(defaultAttrName, this.getName()));
            }
            JavaFxClassBackedElementDescriptor.collectStaticAttributesDescriptors(context, descriptors);
            XmlTag referencedTag = JavaFxDefaultPropertyElementDescriptor.getReferencedTag(this.myXmlTag);
            if (referencedTag != null && (referencedDescriptor = referencedTag.getDescriptor()) != null && (attributesDescriptors = referencedDescriptor.getAttributesDescriptors(referencedTag)) != null) {
                Collections.addAll(descriptors, attributesDescriptors);
            }
            if ((rootTagDescriptor = this.getFxRootTagDescriptor(context)) != null) {
                Collections.addAll(descriptors, rootTagDescriptor.getAttributesDescriptors(context));
            }
            if ((includedRoot = JavaFxDefaultPropertyElementDescriptor.getIncludedRoot(context)) != null) {
                JavaFxClassBackedElementDescriptor includedRootTagDescriptor;
                XmlElementDescriptor includedRootDescriptor = includedRoot.getDescriptor();
                if (includedRootDescriptor instanceof JavaFxClassBackedElementDescriptor) {
                    ((JavaFxClassBackedElementDescriptor)includedRootDescriptor).collectInstanceProperties(descriptors);
                } else if (includedRootDescriptor instanceof JavaFxDefaultPropertyElementDescriptor && (includedRootTagDescriptor = ((JavaFxDefaultPropertyElementDescriptor)includedRootDescriptor).getFxRootTagDescriptor(includedRoot)) != null) {
                    includedRootTagDescriptor.collectInstanceProperties(descriptors);
                }
            }
            return descriptors.isEmpty() ? XmlAttributeDescriptor.EMPTY : descriptors.toArray(new XmlAttributeDescriptor[descriptors.size()]);
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        List<String> defaultAttributeList = FxmlConstants.FX_ELEMENT_ATTRIBUTES.get(this.getName());
        if (defaultAttributeList != null) {
            XmlElementDescriptor includedRootDescriptor;
            XmlTag includedRoot;
            XmlElementDescriptor referencedDescriptor;
            if (defaultAttributeList.contains(attributeName)) {
                return new JavaFxDefaultPropertyAttributeDescriptor(attributeName, this.getName());
            }
            PsiMethod propertySetter = JavaFxPsiUtil.findPropertySetter(attributeName, context);
            if (propertySetter != null) {
                return new JavaFxStaticSetterAttributeDescriptor(propertySetter, attributeName);
            }
            XmlTag referencedTag = JavaFxDefaultPropertyElementDescriptor.getReferencedTag(this.myXmlTag);
            if (referencedTag != null && (referencedDescriptor = referencedTag.getDescriptor()) != null) {
                return referencedDescriptor.getAttributeDescriptor(attributeName, referencedTag);
            }
            JavaFxClassBackedElementDescriptor rootTagDescriptor = this.getFxRootTagDescriptor(context);
            if (rootTagDescriptor != null) {
                return rootTagDescriptor.getAttributeDescriptor(attributeName, context);
            }
            if (context != null && "fx:include".equals(this.getName()) && (includedRoot = JavaFxDefaultPropertyElementDescriptor.getIncludedRoot(context)) != null && (includedRootDescriptor = includedRoot.getDescriptor()) != null) {
                return includedRootDescriptor.getAttributeDescriptor(attributeName, includedRoot);
            }
        }
        return null;
    }

    @Nullable
    public static XmlTag getReferencedTag(XmlTag tag) {
        PsiElement resolve;
        PsiReference reference;
        XmlAttributeValue valueElement;
        XmlAttribute attribute;
        String tagName = tag.getName();
        if (("fx:reference".equals(tagName) || "fx:copy".equals(tagName)) && (attribute = tag.getAttribute("source")) != null && (valueElement = attribute.getValueElement()) != null && (reference = valueElement.getReference()) != null && (resolve = reference.resolve()) instanceof XmlAttributeValue) {
            return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)resolve, XmlTag.class);
        }
        return null;
    }

    public static XmlTag getIncludedRoot(XmlTag context) {
        XmlTag rootTag;
        PsiElement resolve;
        PsiReference reference;
        XmlAttributeValue valueElement;
        if (context == null) {
            return null;
        }
        XmlAttribute xmlAttribute = context.getAttribute("source");
        if (xmlAttribute != null && (valueElement = xmlAttribute.getValueElement()) != null && (reference = valueElement.getReference()) != null && (resolve = reference.resolve()) instanceof XmlFile && (rootTag = ((XmlFile)resolve).getRootTag()) != null) {
            return rootTag;
        }
        return null;
    }

    public JavaFxClassBackedElementDescriptor getFxRootTagDescriptor(XmlTag context) {
        XmlAttribute typeAttr;
        if (context != null && "fx:root".equals(this.getName()) && (typeAttr = context.getAttribute("type")) != null) {
            PsiClass rootClass;
            String rootClassName = typeAttr.getValue();
            PsiClass psiClass = rootClass = rootClassName != null ? JavaFxPsiUtil.findPsiClass(rootClassName, (PsiElement)context) : null;
            if (rootClass != null) {
                return new JavaFxClassBackedElementDescriptor(this.getName(), rootClass);
            }
        }
        return null;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return null;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return -1;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    public PsiElement getDeclaration() {
        return this.myXmlTag;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getName() {
        return this.myName;
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void validate(@NotNull XmlTag context, @NotNull Validator.ValidationHost host) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxDefaultPropertyElementDescriptor", "validate"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxDefaultPropertyElementDescriptor", "validate"));
        }
        String contextName = context.getName();
        if ("fx:root".equals(contextName)) {
            if (context.getParentTag() != null) {
                host.addMessage(context.getNavigationElement(), "<fx:root> is valid only as the root node of an FXML document", Validator.ValidationHost.ErrorType.ERROR);
            }
        } else {
            PsiElement declaration;
            XmlElementDescriptor descriptor;
            XmlTag referencedTag = JavaFxDefaultPropertyElementDescriptor.getReferencedTag(context);
            if (referencedTag != null && (descriptor = referencedTag.getDescriptor()) != null && (declaration = descriptor.getDeclaration()) instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)declaration;
                String canCoerceError = JavaFxPsiUtil.isClassAcceptable(context.getParentTag(), psiClass);
                if (canCoerceError != null) {
                    host.addMessage(context.getNavigationElement(), canCoerceError, Validator.ValidationHost.ErrorType.ERROR);
                }
                if ("fx:copy".equals(contextName)) {
                    boolean copyConstructorFound = false;
                    for (PsiMethod constructor : psiClass.getConstructors()) {
                        PsiParameter[] parameters = constructor.getParameterList().getParameters();
                        if (parameters.length != 1 || psiClass != PsiUtil.resolveClassInType((PsiType)parameters[0].getType())) continue;
                        copyConstructorFound = true;
                        break;
                    }
                    if (!copyConstructorFound) {
                        host.addMessage(context.getNavigationElement(), "Copy constructor not found for '" + psiClass.getName() + "'", Validator.ValidationHost.ErrorType.ERROR);
                    }
                }
            }
        }
    }
}

