/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages;

import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.impl.MessageBusImpl;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageBusFactory {
    private static final AtomicReference<Impl> ourImpl = new AtomicReference<Impl>(Impl.DEFAULT);

    private MessageBusFactory() {
    }

    @NotNull
    public static MessageBus newMessageBus(@NotNull Object owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/messages/MessageBusFactory", "newMessageBus"));
        }
        MessageBus messageBus = ourImpl.get().newMessageBus(owner);
        if (messageBus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/MessageBusFactory", "newMessageBus"));
        }
        return messageBus;
    }

    @NotNull
    public static MessageBus newMessageBus(@NotNull Object owner, @Nullable MessageBus parentBus) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/messages/MessageBusFactory", "newMessageBus"));
        }
        MessageBus messageBus = ourImpl.get().newMessageBus(owner, parentBus);
        if (messageBus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/MessageBusFactory", "newMessageBus"));
        }
        return messageBus;
    }

    public static void setImpl(@NotNull Impl impl) {
        if (impl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "impl", "com/intellij/util/messages/MessageBusFactory", "setImpl"));
        }
        ourImpl.set(impl);
    }

    public static interface Impl {
        public static final Impl DEFAULT = new Impl(){

            @Override
            @NotNull
            public MessageBus newMessageBus(@NotNull Object owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/messages/MessageBusFactory$Impl$1", "newMessageBus"));
                }
                MessageBusImpl.RootBus rootBus = new MessageBusImpl.RootBus(owner);
                if (rootBus == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/MessageBusFactory$Impl$1", "newMessageBus"));
                }
                return rootBus;
            }

            @Override
            @NotNull
            public MessageBus newMessageBus(@NotNull Object owner, @Nullable MessageBus parentBus) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/messages/MessageBusFactory$Impl$1", "newMessageBus"));
                }
                MessageBus messageBus = parentBus == null ? this.newMessageBus(owner) : new MessageBusImpl(owner, parentBus);
                if (messageBus == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/messages/MessageBusFactory$Impl$1", "newMessageBus"));
                }
                return messageBus;
            }
        };

        @NotNull
        public MessageBus newMessageBus(@NotNull Object var1);

        @NotNull
        public MessageBus newMessageBus(@NotNull Object var1, @Nullable MessageBus var2);
    }
}

