/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.TaskExecutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class ProcessWaitFor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.execution.process.ProcessWaitFor");
    private final Future<?> myWaitForThreadFuture;
    private final BlockingQueue<Consumer<Integer>> myTerminationCallback;

    @Deprecated
    public ProcessWaitFor(@NotNull Process process, @NotNull TaskExecutor executor) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/ProcessWaitFor", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/process/ProcessWaitFor", "<init>"));
        }
        this(process, executor, "");
    }

    public ProcessWaitFor(final @NotNull Process process, @NotNull TaskExecutor executor, final @NotNull String presentableName) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/ProcessWaitFor", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/process/ProcessWaitFor", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/execution/process/ProcessWaitFor", "<init>"));
        }
        this.myTerminationCallback = new ArrayBlockingQueue<Consumer<Integer>>(1);
        this.myWaitForThreadFuture = executor.executeTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String oldThreadName = Thread.currentThread().getName();
                if (!StringUtil.isEmptyOrSpaces(presentableName)) {
                    Thread.currentThread().setName(StringUtil.first("ProcessWaitFor: " + presentableName, 120, true));
                }
                int exitCode = 0;
                try {
                    while (true) {
                        try {
                            exitCode = process.waitFor();
                        }
                        catch (InterruptedException e) {
                            LOG.debug(e);
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    try {
                        ((Consumer)ProcessWaitFor.this.myTerminationCallback.take()).consume(exitCode);
                    }
                    catch (InterruptedException e) {
                        LOG.info(e);
                    }
                    finally {
                        Thread.currentThread().setName(oldThreadName);
                    }
                }
            }
        });
    }

    public void detach() {
        this.myWaitForThreadFuture.cancel(true);
    }

    public void setTerminationCallback(@NotNull Consumer<Integer> r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/execution/process/ProcessWaitFor", "setTerminationCallback"));
        }
        this.myTerminationCallback.offer(r);
    }

    public void waitFor() throws InterruptedException {
        try {
            this.myWaitForThreadFuture.get();
        }
        catch (ExecutionException e) {
            LOG.error(e);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }
}

