/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.GrMethodComparator;

public class GrDefaultMethodComparator
extends GrMethodComparator {
    @Override
    public Boolean dominated(@NotNull GroovyMethodResult result1, @NotNull GroovyMethodResult result2, @NotNull GrMethodComparator.Context context) {
        PsiType returnType2;
        PsiType returnType1;
        PsiType[] argTypes;
        if (result1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result1", "org/jetbrains/plugins/groovy/lang/resolve/GrDefaultMethodComparator", "dominated"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result2", "org/jetbrains/plugins/groovy/lang/resolve/GrDefaultMethodComparator", "dominated"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/resolve/GrDefaultMethodComparator", "dominated"));
        }
        PsiMethod method1 = result1.getElement();
        PsiSubstitutor substitutor1 = result1.getSubstitutor(false);
        PsiElement resolveContext1 = result1.getCurrentFileResolveContext();
        PsiMethod method2 = result2.getElement();
        PsiSubstitutor substitutor2 = result2.getSubstitutor(false);
        PsiElement resolveContext2 = result2.getCurrentFileResolveContext();
        if (method1 instanceof GrGdkMethod && method2 instanceof GrGdkMethod) {
            method1 = ((GrGdkMethod)method1).getStaticMethod();
            method2 = ((GrGdkMethod)method2).getStaticMethod();
            PsiType[] contextArgumentTypes = context.getArgumentTypes();
            if (contextArgumentTypes == null) {
                argTypes = null;
            } else {
                argTypes = PsiType.createArray((int)(contextArgumentTypes.length + 1));
                System.arraycopy(contextArgumentTypes, 0, argTypes, 1, contextArgumentTypes.length);
                argTypes[0] = context.getThisType();
            }
        } else {
            if (method1 instanceof GrGdkMethod) {
                return true;
            }
            if (method2 instanceof GrGdkMethod) {
                return false;
            }
            argTypes = context.getArgumentTypes();
        }
        if (context.isConstructor() && argTypes != null && argTypes.length == 1) {
            if (method1.getParameterList().getParametersCount() == 0) {
                return true;
            }
            if (method2.getParameterList().getParametersCount() == 0) {
                return false;
            }
        }
        PsiParameter[] params1 = method1.getParameterList().getParameters();
        PsiParameter[] params2 = method2.getParameterList().getParameters();
        if (argTypes == null && params1.length != params2.length) {
            return false;
        }
        if (params1.length < params2.length) {
            if (params1.length == 0) {
                return false;
            }
            PsiType lastType = params1[params1.length - 1].getType();
            return lastType instanceof PsiArrayType;
        }
        PsiElement myPlace = context.getPlace();
        for (int i = 0; i < params2.length; ++i) {
            PsiType argType;
            PsiType pType1 = params1[i].getType();
            PsiType pType2 = params2[i].getType();
            PsiType type1 = substitutor1.substitute(pType1);
            PsiType type2 = substitutor2.substitute(pType2);
            if (argTypes != null && argTypes.length > i && (argType = argTypes[i]) != null) {
                boolean converts2;
                boolean converts1 = TypesUtil.isAssignableWithoutConversions(TypeConversionUtil.erasure((PsiType)type1), argType, myPlace);
                if (converts1 != (converts2 = TypesUtil.isAssignableWithoutConversions(TypeConversionUtil.erasure((PsiType)type2), argType, myPlace))) {
                    return converts2;
                }
                if (TypesUtil.resolvesTo(type1, "java.util.concurrent.Callable") && TypesUtil.resolvesTo(type2, "java.lang.Runnable") && InheritanceUtil.isInheritor((PsiType)argType, (String)"groovy.lang.GroovyCallable")) {
                    return true;
                }
            }
            if (!GrDefaultMethodComparator.typesAgree(TypeConversionUtil.erasure((PsiType)pType1), TypeConversionUtil.erasure((PsiType)pType2), context)) {
                return false;
            }
            if (resolveContext1 != null && resolveContext2 == null) {
                return !TypesUtil.resolvesTo(type1, "java.lang.Object") || !TypesUtil.resolvesTo(type2, "java.lang.Object");
            }
            if (resolveContext1 != null || resolveContext2 == null) continue;
            return true;
        }
        if (!(method1 instanceof SyntheticElement) && !(method2 instanceof SyntheticElement) && !TypesUtil.isAssignableWithoutConversions(returnType1 = substitutor1.substitute(method1.getReturnType()), returnType2 = substitutor2.substitute(method2.getReturnType()), myPlace) && TypesUtil.isAssignableWithoutConversions(returnType2, returnType1, myPlace)) {
            return false;
        }
        return true;
    }

    private static boolean typesAgree(@NotNull PsiType type1, @NotNull PsiType type2, @NotNull GrMethodComparator.Context context) {
        boolean hasArguments;
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "org/jetbrains/plugins/groovy/lang/resolve/GrDefaultMethodComparator", "typesAgree"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "org/jetbrains/plugins/groovy/lang/resolve/GrDefaultMethodComparator", "typesAgree"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/resolve/GrDefaultMethodComparator", "typesAgree"));
        }
        boolean bl = hasArguments = context.getArgumentTypes() != null;
        if (hasArguments && type1 instanceof PsiArrayType && !(type2 instanceof PsiArrayType)) {
            type1 = ((PsiArrayType)type1).getComponentType();
        }
        return hasArguments ? TypesUtil.isAssignableWithoutConversions(type1, type2, context.getPlace()) : type1.equals(type2);
    }
}

