/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.FromStringLightElement;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.SignatureHintProcessor;

public class FromStringHintProcessor
extends SignatureHintProcessor {
    @Override
    public String getHintName() {
        return "groovy.transform.stc.FromString";
    }

    @Override
    @NotNull
    public List<PsiType[]> inferExpectedSignatures(final @NotNull PsiMethod method, final @NotNull PsiSubstitutor substitutor, @NotNull String[] options) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/FromStringHintProcessor", "inferExpectedSignatures"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/FromStringHintProcessor", "inferExpectedSignatures"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/FromStringHintProcessor", "inferExpectedSignatures"));
        }
        final FromStringLightElement context = new FromStringLightElement(method);
        List list = ContainerUtil.map((Object[])options, (Function)new Function<String, PsiType[]>(){

            public PsiType[] fun(String value) {
                Object[] params = value.split(",");
                return (PsiType[])ContainerUtil.map((Object[])params, (Function)new Function<String, PsiType>(){

                    public PsiType fun(String param) {
                        try {
                            PsiType original = JavaPsiFacade.getElementFactory((Project)method.getProject()).createTypeFromText(param, (PsiElement)context);
                            return substitutor.substitute(original);
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            return PsiType.NULL;
                        }
                    }
                }, (Object[])new PsiType[params.length]);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/FromStringHintProcessor", "inferExpectedSignatures"));
        }
        return list;
    }
}

