/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import icons.JetgroovyIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;

public class GrGdkMethodImpl
extends LightMethodBuilder
implements GrGdkMethod {
    private static final Key<CachedValue<GrGdkMethodImpl>> CACHED_STATIC = Key.create((String)"Cached static gdk method");
    private static final Key<CachedValue<GrGdkMethodImpl>> CACHED_NON_STATIC = Key.create((String)"Cached instance gdk method");
    private final PsiMethod myMethod;

    private GrGdkMethodImpl(PsiMethod method, boolean isStatic, @Nullable String originInfo) {
        super(method.getManager(), (Language)GroovyLanguage.INSTANCE, method.getName());
        this.myMethod = method;
        this.addModifier("public");
        if (isStatic) {
            this.addModifier("static");
        }
        PsiParameter[] originalParameters = method.getParameterList().getParameters();
        for (int i = 1; i < originalParameters.length; ++i) {
            this.addParameter(originalParameters[i]);
        }
        this.setMethodReturnType(method.getReturnType());
        this.setBaseIcon(JetgroovyIcons.Groovy.Method);
        this.setMethodKind("GrGdkMethod");
        if (originInfo != null) {
            this.setOriginInfo(originInfo);
        }
    }

    @Override
    @NotNull
    public PsiMethod getStaticMethod() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrGdkMethodImpl", "getStaticMethod"));
        }
        return psiMethod;
    }

    public boolean hasTypeParameters() {
        return this.myMethod.hasTypeParameters();
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = this.myMethod.getTypeParameters();
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrGdkMethodImpl", "getTypeParameters"));
        }
        return psiTypeParameterArray;
    }

    public PsiTypeParameterList getTypeParameterList() {
        return this.myMethod.getTypeParameterList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GrGdkMethodImpl)) {
            return false;
        }
        GrGdkMethodImpl that = (GrGdkMethodImpl)o;
        if (this.myMethod != null ? !this.myMethod.equals(that.myMethod) : that.myMethod != null) {
            return false;
        }
        return this.hasModifierProperty("static") == that.hasModifierProperty("static");
    }

    public int hashCode() {
        return this.myMethod.hashCode();
    }

    @NotNull
    public static GrGdkMethod createGdkMethod(final @NotNull PsiMethod original, final boolean isStatic, final @Nullable String originInfo) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrGdkMethodImpl", "createGdkMethod"));
        }
        Key<CachedValue<GrGdkMethodImpl>> cachedValueKey = isStatic ? CACHED_STATIC : CACHED_NON_STATIC;
        CachedValue cachedValue = (CachedValue)original.getUserData(cachedValueKey);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)original.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<GrGdkMethodImpl>(){

                public CachedValueProvider.Result<GrGdkMethodImpl> compute() {
                    return CachedValueProvider.Result.create((Object)new GrGdkMethodImpl(original, isStatic, originInfo), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                }
            }, false);
            original.putUserData(cachedValueKey, (Object)cachedValue);
        }
        GrGdkMethod grGdkMethod = (GrGdkMethod)cachedValue.getValue();
        if (grGdkMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrGdkMethodImpl", "createGdkMethod"));
        }
        return grGdkMethod;
    }

    public boolean isValid() {
        return this.myMethod.isValid();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement navigationElement = this.myMethod.getNavigationElement();
        Object object = navigationElement == null ? this.myMethod : navigationElement;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrGdkMethodImpl", "getNavigationElement"));
        }
        return object;
    }

    public void setNavigationElement(@NotNull PsiElement navigationElement) {
        if (navigationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationElement", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrGdkMethodImpl", "setNavigationElement"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiElement getPrototype() {
        PsiMethod psiMethod = this.getStaticMethod();
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrGdkMethodImpl", "getPrototype"));
        }
        return psiMethod;
    }
}

