/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.DelegatingFlexibleType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypeCapabilities;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeImpl;
import org.jetbrains.kotlin.types.StarProjectionImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

public class CommonSupertypes {
    @Nullable
    public static KotlinType commonSupertypeForNonDenotableTypes(@NotNull Collection<KotlinType> types2) {
        KotlinType type2;
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSupertypeForNonDenotableTypes"));
        }
        if (types2.isEmpty()) {
            return null;
        }
        if (types2.size() == 1 && (type2 = types2.iterator().next()).getConstructor() instanceof IntersectionTypeConstructor) {
            return CommonSupertypes.commonSupertypeForNonDenotableTypes(type2.getConstructor().getSupertypes());
        }
        return CommonSupertypes.commonSupertype(types2);
    }

    @NotNull
    public static KotlinType commonSupertype(@NotNull Collection<KotlinType> types2) {
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSupertype"));
        }
        KotlinType kotlinType = CommonSupertypes.findCommonSupertype(types2, 0, CommonSupertypes.maxDepth(types2) + 3);
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSupertype"));
        }
        return kotlinType;
    }

    private static int maxDepth(@NotNull Collection<KotlinType> types2) {
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "maxDepth"));
        }
        int max = 0;
        for (KotlinType type2 : types2) {
            int depth2 = CommonSupertypes.depth(type2);
            if (max >= depth2) continue;
            max = depth2;
        }
        return max;
    }

    private static int depth(final @NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/CommonSupertypes", "depth"));
        }
        return 1 + CommonSupertypes.maxDepth(CollectionsKt.map(type2.getArguments(), (Function1)new Function1<TypeProjection, KotlinType>(){

            public KotlinType invoke(TypeProjection projection) {
                if (projection.isStarProjection()) {
                    return type2.getConstructor().getBuiltIns().getAnyType();
                }
                return projection.getType();
            }
        }));
    }

    @NotNull
    private static KotlinType findCommonSupertype(@NotNull Collection<KotlinType> types2, int recursionDepth, int maxDepth) {
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "findCommonSupertype"));
        }
        assert (recursionDepth <= maxDepth) : "Recursion depth exceeded: " + recursionDepth + " > " + maxDepth + " for types " + types2;
        boolean hasFlexible = false;
        ArrayList<KotlinType> upper = new ArrayList<KotlinType>(types2.size());
        ArrayList<KotlinType> lower = new ArrayList<KotlinType>(types2.size());
        LinkedHashSet<FlexibleTypeCapabilities> capabilities = new LinkedHashSet<FlexibleTypeCapabilities>();
        for (KotlinType type2 : types2) {
            if (FlexibleTypesKt.isFlexible(type2)) {
                hasFlexible = true;
                Flexibility flexibility = FlexibleTypesKt.flexibility(type2);
                upper.add(flexibility.getUpperBound());
                lower.add(flexibility.getLowerBound());
                capabilities.add(flexibility.getExtraCapabilities());
                continue;
            }
            upper.add(type2);
            lower.add(type2);
        }
        if (!hasFlexible) {
            KotlinType kotlinType = CommonSupertypes.commonSuperTypeForInflexible(types2, recursionDepth, maxDepth);
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "findCommonSupertype"));
            }
            return kotlinType;
        }
        KotlinType kotlinType = DelegatingFlexibleType.create(CommonSupertypes.commonSuperTypeForInflexible(lower, recursionDepth, maxDepth), CommonSupertypes.commonSuperTypeForInflexible(upper, recursionDepth, maxDepth), (FlexibleTypeCapabilities)CollectionsKt.single(capabilities));
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "findCommonSupertype"));
        }
        return kotlinType;
    }

    @NotNull
    private static KotlinType commonSuperTypeForInflexible(@NotNull Collection<KotlinType> types2, int recursionDepth, int maxDepth) {
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
        }
        assert (!types2.isEmpty());
        HashSet<KotlinType> typeSet = new HashSet<KotlinType>(types2);
        KotlinType bestFit = FlexibleTypesKt.singleBestRepresentative(typeSet);
        if (bestFit != null) {
            KotlinType kotlinType = bestFit;
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
            }
            return kotlinType;
        }
        boolean nullable2 = false;
        Iterator iterator2 = typeSet.iterator();
        while (iterator2.hasNext()) {
            KotlinType type2 = (KotlinType)iterator2.next();
            assert (type2 != null);
            assert (!FlexibleTypesKt.isFlexible(type2)) : "Flexible type " + type2 + " passed to commonSuperTypeForInflexible";
            if (KotlinBuiltIns.isNothingOrNullableNothing(type2)) {
                iterator2.remove();
            }
            if (type2.isError()) {
                KotlinType kotlinType = ErrorUtils.createErrorType("Supertype of error type " + type2);
                if (kotlinType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
                }
                return kotlinType;
            }
            nullable2 |= type2.isMarkedNullable();
        }
        if (typeSet.isEmpty()) {
            KotlinBuiltIns builtIns = types2.iterator().next().getConstructor().getBuiltIns();
            KotlinType kotlinType = nullable2 ? builtIns.getNullableNothingType() : builtIns.getNothingType();
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
            }
            return kotlinType;
        }
        if (typeSet.size() == 1) {
            KotlinType kotlinType = TypeUtils.makeNullableIfNeeded((KotlinType)typeSet.iterator().next(), nullable2);
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
            }
            return kotlinType;
        }
        Map<TypeConstructor, Set<KotlinType>> commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(typeSet);
        while (commonSupertypes.size() > 1) {
            HashSet<KotlinType> merge = new HashSet<KotlinType>();
            for (Set<KotlinType> supertypes2 : commonSupertypes.values()) {
                merge.addAll(supertypes2);
            }
            commonSupertypes = CommonSupertypes.computeCommonRawSupertypes(merge);
        }
        assert (!commonSupertypes.isEmpty()) : commonSupertypes + " <- " + types2;
        Map.Entry<TypeConstructor, Set<KotlinType>> entry = commonSupertypes.entrySet().iterator().next();
        KotlinType result2 = CommonSupertypes.computeSupertypeProjections(entry.getKey(), entry.getValue(), recursionDepth, maxDepth);
        KotlinType kotlinType = TypeUtils.makeNullableIfNeeded(result2, nullable2);
        if (kotlinType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "commonSuperTypeForInflexible"));
        }
        return kotlinType;
    }

    @NotNull
    private static Map<TypeConstructor, Set<KotlinType>> computeCommonRawSupertypes(@NotNull Collection<KotlinType> types2) {
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "computeCommonRawSupertypes"));
        }
        assert (!types2.isEmpty());
        HashMap<TypeConstructor, Set<KotlinType>> constructorToAllInstances = new HashMap<TypeConstructor, Set<KotlinType>>();
        HashSet<TypeConstructor> commonSuperclasses = null;
        List<TypeConstructor> order = null;
        for (KotlinType type2 : types2) {
            HashSet<TypeConstructor> visited2 = new HashSet<TypeConstructor>();
            order = CommonSupertypes.topologicallySortSuperclassesAndRecordAllInstances(type2, constructorToAllInstances, visited2);
            if (commonSuperclasses == null) {
                commonSuperclasses = visited2;
                continue;
            }
            commonSuperclasses.retainAll(visited2);
        }
        assert (order != null);
        HashSet<TypeConstructor> notSource = new HashSet<TypeConstructor>();
        HashMap<TypeConstructor, Set<KotlinType>> result2 = new HashMap<TypeConstructor, Set<KotlinType>>();
        for (TypeConstructor superConstructor : order) {
            if (!commonSuperclasses.contains(superConstructor) || notSource.contains(superConstructor)) continue;
            result2.put(superConstructor, (Set<KotlinType>)constructorToAllInstances.get(superConstructor));
            CommonSupertypes.markAll(superConstructor, notSource);
        }
        HashMap<TypeConstructor, Set<KotlinType>> hashMap = result2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeCommonRawSupertypes"));
        }
        return hashMap;
    }

    @NotNull
    private static KotlinType computeSupertypeProjections(@NotNull TypeConstructor constructor, @NotNull Set<KotlinType> types2, int recursionDepth, int maxDepth) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        assert (!types2.isEmpty());
        if (types2.size() == 1) {
            KotlinType kotlinType = types2.iterator().next();
            if (kotlinType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjections"));
            }
            return kotlinType;
        }
        List<TypeParameterDescriptor> parameters2 = constructor.getParameters();
        ArrayList<TypeProjection> newProjections = new ArrayList<TypeProjection>(parameters2.size());
        for (TypeParameterDescriptor parameterDescriptor : parameters2) {
            HashSet<TypeProjection> typeProjections = new HashSet<TypeProjection>();
            for (KotlinType type2 : types2) {
                typeProjections.add(type2.getArguments().get(parameterDescriptor.getIndex()));
            }
            newProjections.add(CommonSupertypes.computeSupertypeProjection(parameterDescriptor, typeProjections, recursionDepth, maxDepth));
        }
        boolean nullable2 = false;
        for (KotlinType type3 : types2) {
            nullable2 |= type3.isMarkedNullable();
        }
        ClassifierDescriptor classifier2 = constructor.getDeclarationDescriptor();
        MemberScope newScope = classifier2 instanceof ClassDescriptor ? ((ClassDescriptor)classifier2).getMemberScope(newProjections) : (classifier2 instanceof TypeParameterDescriptor ? classifier2.getDefaultType().getMemberScope() : ErrorUtils.createErrorScope("A scope for common supertype which is not a normal classifier", true));
        KotlinTypeImpl kotlinTypeImpl = KotlinTypeImpl.create(Annotations.Companion.getEMPTY(), constructor, nullable2, newProjections, newScope);
        if (kotlinTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjections"));
        }
        return kotlinTypeImpl;
    }

    @NotNull
    private static TypeProjection computeSupertypeProjection(@NotNull TypeParameterDescriptor parameterDescriptor, @NotNull Set<TypeProjection> typeProjections, int recursionDepth, int maxDepth) {
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterDescriptor", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        if (typeProjections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjections", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        TypeProjection singleBestProjection = FlexibleTypesKt.singleBestRepresentative(typeProjections);
        if (singleBestProjection != null) {
            TypeProjection typeProjection = singleBestProjection;
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjection;
        }
        if (recursionDepth >= maxDepth) {
            TypeProjection typeProjection = TypeUtils.makeStarProjection(parameterDescriptor);
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjection;
        }
        HashSet<KotlinType> ins = new HashSet<KotlinType>();
        HashSet<KotlinType> outs = new HashSet<KotlinType>();
        Variance variance = parameterDescriptor.getVariance();
        switch (variance) {
            case INVARIANT: {
                break;
            }
            case IN_VARIANCE: {
                outs = null;
                break;
            }
            case OUT_VARIANCE: {
                ins = null;
            }
        }
        for (TypeProjection projection : typeProjections) {
            Variance projectionKind = projection.getProjectionKind();
            if (projectionKind.getAllowsInPosition()) {
                if (ins != null) {
                    ins.add(projection.getType());
                }
            } else {
                ins = null;
            }
            if (projectionKind.getAllowsOutPosition()) {
                if (outs == null) continue;
                outs.add(projection.getType());
                continue;
            }
            outs = null;
        }
        if (outs != null) {
            assert (!outs.isEmpty()) : "Out projections is empty for parameter " + parameterDescriptor + ", type projections " + typeProjections;
            Variance projectionKind = variance == Variance.OUT_VARIANCE ? Variance.INVARIANT : Variance.OUT_VARIANCE;
            KotlinType superType = CommonSupertypes.findCommonSupertype(outs, recursionDepth + 1, maxDepth);
            for (KotlinType upperBound : parameterDescriptor.getUpperBounds()) {
                if (TypeUtilsKt.isSubtypeOf(superType, upperBound)) continue;
                StarProjectionImpl starProjectionImpl = new StarProjectionImpl(parameterDescriptor);
                if (starProjectionImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
                }
                return starProjectionImpl;
            }
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(projectionKind, superType);
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjectionImpl;
        }
        if (ins != null) {
            assert (!ins.isEmpty()) : "In projections is empty for parameter " + parameterDescriptor + ", type projections " + typeProjections;
            KotlinType intersection = TypeIntersector.intersectTypes(KotlinTypeChecker.DEFAULT, ins);
            if (intersection == null) {
                TypeProjection typeProjection = TypeUtils.makeStarProjection(parameterDescriptor);
                if (typeProjection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
                }
                return typeProjection;
            }
            Variance projectionKind = variance == Variance.IN_VARIANCE ? Variance.INVARIANT : Variance.IN_VARIANCE;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(projectionKind, intersection);
            if (typeProjectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
            }
            return typeProjectionImpl;
        }
        TypeProjection typeProjection = TypeUtils.makeStarProjection(parameterDescriptor);
        if (typeProjection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "computeSupertypeProjection"));
        }
        return typeProjection;
    }

    private static void markAll(@NotNull TypeConstructor typeConstructor2, @NotNull Set<TypeConstructor> markerSet) {
        if (typeConstructor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/kotlin/types/CommonSupertypes", "markAll"));
        }
        if (markerSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markerSet", "org/jetbrains/kotlin/types/CommonSupertypes", "markAll"));
        }
        markerSet.add(typeConstructor2);
        for (KotlinType type2 : typeConstructor2.getSupertypes()) {
            CommonSupertypes.markAll(type2.getConstructor(), markerSet);
        }
    }

    @NotNull
    public static List<TypeConstructor> topologicallySortSuperclassesAndRecordAllInstances(@NotNull KotlinType type2, final @NotNull Map<TypeConstructor, Set<KotlinType>> constructorToAllInstances, final @NotNull Set<TypeConstructor> visited2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/types/CommonSupertypes", "topologicallySortSuperclassesAndRecordAllInstances"));
        }
        if (constructorToAllInstances == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorToAllInstances", "org/jetbrains/kotlin/types/CommonSupertypes", "topologicallySortSuperclassesAndRecordAllInstances"));
        }
        if (visited2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "org/jetbrains/kotlin/types/CommonSupertypes", "topologicallySortSuperclassesAndRecordAllInstances"));
        }
        List list2 = DFS.dfs(Collections.singletonList(type2), new DFS.Neighbors<KotlinType>(){

            @Override
            @NotNull
            public Iterable<KotlinType> getNeighbors(KotlinType current) {
                TypeSubstitutor substitutor3 = TypeSubstitutor.create(current);
                Collection<KotlinType> supertypes2 = current.getConstructor().getSupertypes();
                ArrayList<KotlinType> result2 = new ArrayList<KotlinType>(supertypes2.size());
                for (KotlinType supertype : supertypes2) {
                    if (visited2.contains(supertype.getConstructor())) continue;
                    result2.add(substitutor3.safeSubstitute(supertype, Variance.INVARIANT));
                }
                ArrayList<KotlinType> arrayList = result2;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes$2", "getNeighbors"));
                }
                return arrayList;
            }
        }, new DFS.Visited<KotlinType>(){

            @Override
            public boolean checkAndMarkVisited(KotlinType current) {
                return visited2.add(current.getConstructor());
            }
        }, new DFS.NodeHandlerWithListResult<KotlinType, TypeConstructor>(){

            @Override
            public boolean beforeChildren(KotlinType current) {
                TypeConstructor constructor = current.getConstructor();
                HashSet<KotlinType> instances = (HashSet<KotlinType>)constructorToAllInstances.get(constructor);
                if (instances == null) {
                    instances = new HashSet<KotlinType>();
                    constructorToAllInstances.put(constructor, instances);
                }
                instances.add(current);
                return true;
            }

            @Override
            public void afterChildren(KotlinType current) {
                ((LinkedList)this.result).addFirst(current.getConstructor());
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/CommonSupertypes", "topologicallySortSuperclassesAndRecordAllInstances"));
        }
        return list2;
    }
}

