/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.lazy.types.LazyJavaTypeResolverKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityWarningsChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J,\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016JB\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00040\u001bH\u0002J;\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\b\b\u0000\u0010\u001e*\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!H\u0002\u00a2\u0006\u0002\u0010\"J\u000e\u0010#\u001a\u0004\u0018\u00010\u001c*\u00020\u0011H\u0002J\u000e\u0010$\u001a\u0004\u0018\u00010\u001c*\u00020\u0011H\u0002\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaNullabilityWarningsChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkReceiver", "", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "safeAccess", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "checkType", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "doCheckType", "expectedType", "dataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "reportWarning", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/resolve/jvm/diagnostics/ErrorsJvm$NullabilityInformationSource;", "doIfNotNull", "T", "", "body", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "mayBeNull", "mustNotBeNull", "frontend.java"})
public final class JavaNullabilityWarningsChecker
implements AdditionalTypeChecker {
    private final ErrorsJvm.NullabilityInformationSource mayBeNull(KotlinType $receiver) {
        if (!$receiver.isError() && !FlexibleTypesKt.isFlexible($receiver) && TypeUtils.isNullableType($receiver)) {
            return ErrorsJvm.NullabilityInformationSource.KOTLIN;
        }
        if (FlexibleTypesKt.isFlexible($receiver) && TypeUtils.isNullableType(FlexibleTypesKt.flexibility($receiver).getLowerBound())) {
            return ErrorsJvm.NullabilityInformationSource.KOTLIN;
        }
        if (LazyJavaTypeResolverKt.isMarkedNullable($receiver.getAnnotations())) {
            return ErrorsJvm.NullabilityInformationSource.JAVA;
        }
        return null;
    }

    private final ErrorsJvm.NullabilityInformationSource mustNotBeNull(KotlinType $receiver) {
        if (!($receiver.isError() || FlexibleTypesKt.isFlexible($receiver) || TypeUtils.isNullableType($receiver))) {
            return ErrorsJvm.NullabilityInformationSource.KOTLIN;
        }
        if (FlexibleTypesKt.isFlexible($receiver) && !TypeUtils.isNullableType(FlexibleTypesKt.flexibility($receiver).getUpperBound())) {
            return ErrorsJvm.NullabilityInformationSource.KOTLIN;
        }
        if (!$receiver.isMarkedNullable() && LazyJavaTypeResolverKt.isMarkedNotNull($receiver.getAnnotations())) {
            return ErrorsJvm.NullabilityInformationSource.JAVA;
        }
        return null;
    }

    private final void doCheckType(KotlinType expressionType, KotlinType expectedType, DataFlowValue dataFlowValue, DataFlowInfo dataFlowInfo, Function2<? super ErrorsJvm.NullabilityInformationSource, ? super ErrorsJvm.NullabilityInformationSource, Unit> reportWarning) {
        if (TypeUtils.noExpectedType(expectedType)) {
            return;
        }
        ErrorsJvm.NullabilityInformationSource expectedMustNotBeNull = this.mustNotBeNull(expectedType);
        if (Intrinsics.areEqual((Object)((Object)dataFlowInfo.getPredictableNullability(dataFlowValue)), (Object)((Object)Nullability.NOT_NULL))) {
            return;
        }
        ErrorsJvm.NullabilityInformationSource actualMayBeNull = this.mayBeNull(expressionType);
        if (Intrinsics.areEqual((Object)((Object)expectedMustNotBeNull), (Object)((Object)ErrorsJvm.NullabilityInformationSource.KOTLIN)) && Intrinsics.areEqual((Object)((Object)actualMayBeNull), (Object)((Object)ErrorsJvm.NullabilityInformationSource.KOTLIN))) {
            return;
        }
        if (expectedMustNotBeNull != null && actualMayBeNull != null) {
            reportWarning.invoke((Object)expectedMustNotBeNull, (Object)actualMayBeNull);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)expressionType, (String)"expressionType");
        Intrinsics.checkParameterIsNotNull((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"c.expectedType");
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression2, expressionType, c);
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowValue, (String)"DataFlowValueFactory.cre\u2026ssion, expressionType, c)");
        DataFlowInfo dataFlowInfo = c.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"c.dataFlowInfo");
        this.doCheckType(expressionType, kotlinType, dataFlowValue, dataFlowInfo, (Function2<? super ErrorsJvm.NullabilityInformationSource, ? super ErrorsJvm.NullabilityInformationSource, Unit>)((Function2)new Function2<ErrorsJvm.NullabilityInformationSource, ErrorsJvm.NullabilityInformationSource, Unit>(c, expression2){
            final /* synthetic */ ResolutionContext $c;
            final /* synthetic */ KtExpression $expression;

            public final void invoke(@NotNull ErrorsJvm.NullabilityInformationSource expectedMustNotBeNull, @NotNull ErrorsJvm.NullabilityInformationSource actualMayBeNull) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)expectedMustNotBeNull), (String)"expectedMustNotBeNull");
                Intrinsics.checkParameterIsNotNull((Object)((Object)actualMayBeNull), (String)"actualMayBeNull");
                this.$c.trace.report(ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((KtElement)((PsiElement)this.$expression), expectedMustNotBeNull, actualMayBeNull));
            }
            {
                this.$c = resolutionContext;
                this.$expression = ktExpression;
                super(2);
            }
        }));
        KtExpression ktExpression = expression2;
        if (ktExpression instanceof KtWhenExpression) {
            void $receiver$iv;
            if (((KtWhenExpression)expression2).getElseExpression() != null) return;
            Object object = ((KtWhenExpression)expression2).getSubjectExpression();
            if (object == null) return;
            KtExpression ktExpression2 = object;
            KtExpression it = (KtExpression)$receiver$iv;
            object = c.trace.getType(it);
            if (object == null) {
                return;
            }
            Object type2 = object;
            if (!FlexibleTypesKt.isFlexible((KotlinType)type2) || !TypeUtils.isNullableType(FlexibleTypesKt.flexibility((KotlinType)type2).getUpperBound()) || LazyJavaTypeResolverKt.isMarkedNotNull(type2.getAnnotations())) return;
            ClassDescriptor classDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum((KotlinType)type2);
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor enumClassDescriptor = classDescriptor;
            BindingContext context = c.trace.getBindingContext();
            KtWhenExpression ktWhenExpression = (KtWhenExpression)expression2;
            BindingContext bindingContext2 = context;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"context");
            if (!WhenChecker.getEnumMissingCases(ktWhenExpression, bindingContext2, enumClassDescriptor).isEmpty()) return;
            KtWhenExpression ktWhenExpression2 = (KtWhenExpression)expression2;
            BindingContext bindingContext3 = context;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext3, (String)"context");
            if (WhenChecker.INSTANCE.containsNullCase(ktWhenExpression2, bindingContext3)) return;
            BindingTrace bindingTrace = c.trace;
            KtExpression ktExpression3 = ((KtWhenExpression)expression2).getSubjectExpression();
            if (ktExpression3 == null) {
                Intrinsics.throwNpe();
            }
            bindingTrace.report(ErrorsJvm.WHEN_ENUM_CAN_BE_NULL_IN_JAVA.on((KtExpression)((PsiElement)ktExpression3)));
            return;
        } else if (ktExpression instanceof KtPostfixExpression) {
            if (!Intrinsics.areEqual((Object)((KtPostfixExpression)expression2).getOperationToken(), (Object)((Object)KtTokens.EXCLEXCL))) return;
            KtExpression ktExpression4 = ((KtPostfixExpression)expression2).getBaseExpression();
            if (ktExpression4 == null) {
                return;
            }
            KtExpression baseExpression = ktExpression4;
            KotlinType kotlinType2 = c.trace.getType(baseExpression);
            if (kotlinType2 == null) {
                return;
            }
            KotlinType baseExpressionType = kotlinType2;
            DataFlowValue dataFlowValue2 = DataFlowValueFactory.createDataFlowValue(baseExpression, baseExpressionType, c);
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowValue2, (String)"DataFlowValueFactory.cre\u2026n, baseExpressionType, c)");
            this.doIfNotNull(dataFlowValue2, c, (Function0)new Function0<Unit>(c, expression2, baseExpressionType){
                final /* synthetic */ ResolutionContext $c;
                final /* synthetic */ KtExpression $expression;
                final /* synthetic */ KotlinType $baseExpressionType;

                public final void invoke() {
                    this.$c.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on((PsiElement)((KtPostfixExpression)this.$expression).getOperationReference(), this.$baseExpressionType));
                }
                {
                    this.$c = resolutionContext;
                    this.$expression = ktExpression;
                    this.$baseExpressionType = kotlinType;
                    super(0);
                }
            });
            return;
        } else {
            if (!(ktExpression instanceof KtBinaryExpression)) return;
            IElementType iElementType = ((KtBinaryExpression)expression2).getOperationToken();
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.ELVIS))) {
                void $receiver$iv;
                KtExpression baseExpression = ((KtBinaryExpression)expression2).getLeft();
                Object object = baseExpression;
                if (object == null) return;
                KtExpression $i$a$1 = object;
                KtExpression it = (KtExpression)$receiver$iv;
                object = c.trace.getType(it);
                if (object == null) {
                    return;
                }
                Object baseExpressionType = object;
                KtExpression ktExpression5 = baseExpression;
                if (ktExpression5 == null) {
                    Intrinsics.throwNpe();
                }
                DataFlowValue dataFlowValue3 = DataFlowValueFactory.createDataFlowValue(ktExpression5, (KotlinType)baseExpressionType, c);
                Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowValue3, (String)"DataFlowValueFactory.cre\u2026!, baseExpressionType, c)");
                this.doIfNotNull(dataFlowValue3, c, (Function0)new Function0<Unit>(c, expression2, (KotlinType)baseExpressionType){
                    final /* synthetic */ ResolutionContext $c;
                    final /* synthetic */ KtExpression $expression;
                    final /* synthetic */ KotlinType $baseExpressionType;

                    public final void invoke() {
                        this.$c.trace.report(Errors.USELESS_ELVIS.on((KtBinaryExpression)((PsiElement)this.$expression), this.$baseExpressionType));
                    }
                    {
                        this.$c = resolutionContext;
                        this.$expression = ktExpression;
                        this.$baseExpressionType = kotlinType;
                        super(0);
                    }
                });
                return;
            } else {
                if (!Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ)) && !Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ)) && !Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQEQ)) && !Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQEQEQ)) || ((KtBinaryExpression)expression2).getLeft() == null || ((KtBinaryExpression)expression2).getRight() == null) return;
                KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)expression2;
                KtExpression ktExpression6 = ((KtBinaryExpression)expression2).getLeft();
                if (ktExpression6 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression6, (String)"expression.left!!");
                KtExpression ktExpression7 = ((KtBinaryExpression)expression2).getRight();
                if (ktExpression7 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression7, (String)"expression.right!!");
                SenselessComparisonChecker.checkSenselessComparisonWithNull(ktBinaryExpression, ktExpression6, ktExpression7, c, (Function1<? super KtExpression, ? extends KotlinType>)((Function1)new Function1<KtExpression, KotlinType>(c){
                    final /* synthetic */ ResolutionContext $c;

                    @Nullable
                    public final KotlinType invoke(@NotNull KtExpression it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return this.$c.trace.getType(it);
                    }
                    {
                        this.$c = resolutionContext;
                        super(1);
                    }
                }), (Function1<? super DataFlowValue, ? extends Nullability>)((Function1)new Function1<DataFlowValue, Nullability>(this, c){
                    final /* synthetic */ JavaNullabilityWarningsChecker this$0;
                    final /* synthetic */ ResolutionContext $c;

                    @NotNull
                    public final Nullability invoke(@NotNull DataFlowValue value2) {
                        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
                        Nullability nullability = (Nullability)((Object)JavaNullabilityWarningsChecker.access$doIfNotNull(this.this$0, value2, this.$c, checkType.1.INSTANCE));
                        if (nullability == null) {
                            nullability = Nullability.UNKNOWN;
                        }
                        return nullability;
                    }
                    {
                        this.this$0 = javaNullabilityWarningsChecker;
                        this.$c = resolutionContext;
                        super(1);
                    }
                }));
            }
        }
    }

    private final <T> T doIfNotNull(DataFlowValue dataFlowValue, ResolutionContext<?> c, Function0<? extends T> body2) {
        if (c.dataFlowInfo.getPredictableNullability(dataFlowValue).canBeNull() && Intrinsics.areEqual((Object)((Object)this.mustNotBeNull(dataFlowValue.getType())), (Object)((Object)ErrorsJvm.NullabilityInformationSource.JAVA))) {
            return (T)body2.invoke();
        }
        return null;
    }

    @Override
    public void checkReceiver(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean safeAccess, @NotNull CallResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull((Object)receiverParameter, (String)"receiverParameter");
        Intrinsics.checkParameterIsNotNull((Object)receiverArgument, (String)"receiverArgument");
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverArgument, c);
        if (!safeAccess) {
            KotlinType kotlinType = receiverArgument.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiverArgument.type");
            KotlinType kotlinType2 = receiverParameter.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"receiverParameter.type");
            DataFlowValue dataFlowValue2 = dataFlowValue;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowValue2, (String)"dataFlowValue");
            DataFlowInfo dataFlowInfo = c.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowInfo, (String)"c.dataFlowInfo");
            this.doCheckType(kotlinType, kotlinType2, dataFlowValue2, dataFlowInfo, (Function2<? super ErrorsJvm.NullabilityInformationSource, ? super ErrorsJvm.NullabilityInformationSource, Unit>)((Function2)new Function2<ErrorsJvm.NullabilityInformationSource, ErrorsJvm.NullabilityInformationSource, Unit>(receiverArgument, c){
                final /* synthetic */ ReceiverValue $receiverArgument;
                final /* synthetic */ CallResolutionContext $c;

                public final void invoke(@NotNull ErrorsJvm.NullabilityInformationSource expectedMustNotBeNull, @NotNull ErrorsJvm.NullabilityInformationSource actualMayBeNull) {
                    KtElement ktElement;
                    Intrinsics.checkParameterIsNotNull((Object)((Object)expectedMustNotBeNull), (String)"expectedMustNotBeNull");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)actualMayBeNull), (String)"actualMayBeNull");
                    if (this.$receiverArgument instanceof ExpressionReceiver) {
                        ktElement = ((ExpressionReceiver)this.$receiverArgument).getExpression();
                    } else {
                        KtExpression ktExpression = this.$c.call.getCalleeExpression();
                        ktElement = ktExpression != null ? (KtElement)ktExpression : this.$c.call.getCallElement();
                    }
                    KtElement reportOn = ktElement;
                    this.$c.trace.report(ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((KtElement)((PsiElement)reportOn), expectedMustNotBeNull, actualMayBeNull));
                }
                {
                    this.$receiverArgument = receiverValue;
                    this.$c = callResolutionContext;
                    super(2);
                }
            }));
        } else {
            DataFlowValue dataFlowValue3 = dataFlowValue;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataFlowValue3, (String)"dataFlowValue");
            this.doIfNotNull(dataFlowValue3, (ResolutionContext)c, (Function0)new Function0<Unit>(c, receiverArgument){
                final /* synthetic */ CallResolutionContext $c;
                final /* synthetic */ ReceiverValue $receiverArgument;

                public final void invoke() {
                    BindingTrace bindingTrace = this.$c.trace;
                    ASTNode aSTNode = this.$c.call.getCallOperationNode();
                    if (aSTNode == null) {
                        Intrinsics.throwNpe();
                    }
                    bindingTrace.report(Errors.UNNECESSARY_SAFE_CALL.on(aSTNode.getPsi(), this.$receiverArgument.getType()));
                }
                {
                    this.$c = callResolutionContext;
                    this.$receiverArgument = receiverValue;
                    super(0);
                }
            });
        }
    }

    @Nullable
    public static final /* synthetic */ Object access$doIfNotNull(JavaNullabilityWarningsChecker $this, @NotNull DataFlowValue dataFlowValue, @NotNull ResolutionContext c, @NotNull Function0 body2) {
        return $this.doIfNotNull(dataFlowValue, c, body2);
    }
}

