/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaResolverCache;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaElement;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaFieldImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaMethodImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageDescriptor;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/load/java/components/LazyResolveBasedCache;", "Lorg/jetbrains/kotlin/load/java/components/JavaResolverCache;", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "(Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;)V", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "findInPackageFragments", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "fullFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getClassResolvedFromSource", "fqName", "recordClass", "", "javaClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "descriptor", "recordConstructor", "element", "Lorg/jetbrains/kotlin/load/java/structure/JavaElement;", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "recordField", "field", "Lorg/jetbrains/kotlin/load/java/structure/JavaField;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "recordMethod", "method", "Lorg/jetbrains/kotlin/load/java/structure/JavaMethod;", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "frontend.java"})
public final class LazyResolveBasedCache
implements JavaResolverCache {
    private final ResolveSession resolveSession;

    private final BindingTrace getTrace() {
        BindingTrace bindingTrace = this.resolveSession.getTrace();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"resolveSession.trace");
        return bindingTrace;
    }

    @Override
    @Nullable
    public ClassDescriptor getClassResolvedFromSource(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        ClassDescriptor classDescriptor = (ClassDescriptor)this.getTrace().get(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, fqName2.toUnsafe());
        if (classDescriptor == null) {
            classDescriptor = this.findInPackageFragments(fqName2);
        }
        return classDescriptor;
    }

    @Override
    public void recordMethod(@NotNull JavaMethod method, @NotNull SimpleFunctionDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        JavaMethod javaMethod = method;
        if (javaMethod == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.impl.JavaMethodImpl");
        }
        BindingContextUtils.recordFunctionDeclarationToDescriptor(this.getTrace(), ((JavaMethodImpl)javaMethod).getPsi(), descriptor2);
    }

    @Override
    public void recordConstructor(@NotNull JavaElement element2, @NotNull ConstructorDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        JavaElement javaElement = element2;
        if (javaElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.impl.JavaElementImpl<*>");
        }
        this.getTrace().record(BindingContext.CONSTRUCTOR, ((JavaElementImpl)javaElement).getPsi(), descriptor2);
    }

    @Override
    public void recordField(@NotNull JavaField field2, @NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)field2, (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        JavaField javaField = field2;
        if (javaField == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.impl.JavaFieldImpl");
        }
        this.getTrace().record(BindingContext.VARIABLE, ((JavaFieldImpl)javaField).getPsi(), descriptor2);
    }

    @Override
    public void recordClass(@NotNull JavaClass javaClass, @NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)javaClass, (String)"javaClass");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        JavaClass javaClass2 = javaClass;
        if (javaClass2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl");
        }
        this.getTrace().record(BindingContext.CLASS, ((JavaClassImpl)javaClass2).getPsi(), descriptor2);
    }

    private final ClassDescriptor findInPackageFragments(FqName fullFqName) {
        LazyPackageDescriptor packageDescriptor;
        FqName fqName2;
        if (fullFqName.isRoot()) {
            fqName2 = fullFqName;
        } else {
            FqName fqName3 = fullFqName.parent();
            fqName2 = fqName3;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"fullFqName.parent()");
        }
        FqName fqName4 = fqName2;
        while ((packageDescriptor = this.resolveSession.getPackageFragment(fqName4)) != null) {
            ClassDescriptor result2 = ResolveSessionUtils.findClassByRelativePath(packageDescriptor.getMemberScope(), FqNamesUtilKt.tail(fullFqName, fqName4));
            if (result2 != null) {
                return result2;
            }
            if (fqName4.isRoot()) break;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName4.parent(), (String)"fqName.parent()");
        }
        return null;
    }

    public LazyResolveBasedCache(@NotNull ResolveSession resolveSession) {
        Intrinsics.checkParameterIsNotNull((Object)resolveSession, (String)"resolveSession");
        this.resolveSession = resolveSession;
    }
}

