/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.stubindex.KotlinIndexUtil;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.psi.KtClassOrObject;

public class KotlinFullClassNameIndex
extends StringStubIndexExtension<KtClassOrObject> {
    private static final StubIndexKey<String, KtClassOrObject> KEY = KotlinIndexUtil.createIndexKey(KotlinFullClassNameIndex.class);
    private static final KotlinFullClassNameIndex ourInstance = new KotlinFullClassNameIndex();

    @NotNull
    public static KotlinFullClassNameIndex getInstance() {
        KotlinFullClassNameIndex kotlinFullClassNameIndex = ourInstance;
        if (kotlinFullClassNameIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/KotlinFullClassNameIndex", "getInstance"));
        }
        return kotlinFullClassNameIndex;
    }

    private KotlinFullClassNameIndex() {
    }

    @NotNull
    public StubIndexKey<String, KtClassOrObject> getKey() {
        StubIndexKey<String, KtClassOrObject> stubIndexKey = KEY;
        if (stubIndexKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/KotlinFullClassNameIndex", "getKey"));
        }
        return stubIndexKey;
    }

    @NotNull
    public Collection<KtClassOrObject> get(@NotNull String fqName2, @NotNull Project project, @NotNull GlobalSearchScope scope2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/idea/stubindex/KotlinFullClassNameIndex", "get"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/KotlinFullClassNameIndex", "get"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/idea/stubindex/KotlinFullClassNameIndex", "get"));
        }
        Collection collection = StubIndex.getElements(KEY, (Object)fqName2, (Project)project, (GlobalSearchScope)KotlinSourceFilterScope.sourcesAndLibraries(scope2, project), KtClassOrObject.class);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/KotlinFullClassNameIndex", "get"));
        }
        return collection;
    }
}

