/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.quickfix.AutoImportFixBase;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.MissingArrayAccessorAutoImportFix;
import org.jetbrains.kotlin.idea.util.CallTypeAndReceiver;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u0005H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MissingArrayAccessorAutoImportFix;", "Lorg/jetbrains/kotlin/idea/quickfix/AutoImportFixBase;", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "element", "importNames", "", "Lorg/jetbrains/kotlin/name/Name;", "showHint", "", "(Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;Ljava/util/Collection;Z)V", "getImportNames", "()Ljava/util/Collection;", "getCallTypeAndReceiver", "Lorg/jetbrains/kotlin/idea/util/CallTypeAndReceiver$OPERATOR;", "getSupportedErrors", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "idea"})
public class MissingArrayAccessorAutoImportFix
extends AutoImportFixBase<KtArrayAccessExpression> {
    @NotNull
    private final Collection<Name> importNames;
    private final boolean showHint;
    private static final Lazy<Collection<DiagnosticFactory<?>>> ERRORS$delegate;
    public static final Companion Companion;

    @NotNull
    protected CallTypeAndReceiver.OPERATOR getCallTypeAndReceiver() {
        KtExpression ktExpression = ((KtArrayAccessExpression)this.getElement()).getArrayExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.arrayExpression!!");
        return new CallTypeAndReceiver.OPERATOR(ktExpression);
    }

    @Override
    @NotNull
    protected Collection<DiagnosticFactory<?>> getSupportedErrors() {
        return MissingArrayAccessorAutoImportFix.Companion.getERRORS();
    }

    @Override
    public boolean showHint(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        return this.showHint && super.showHint(editor);
    }

    @Override
    @NotNull
    protected Collection<Name> getImportNames() {
        return this.importNames;
    }

    public MissingArrayAccessorAutoImportFix(@NotNull KtArrayAccessExpression element2, @NotNull Collection<Name> importNames, boolean showHint) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull(importNames, (String)"importNames");
        super((KtExpression)element2);
        this.importNames = importNames;
        this.showHint = showHint;
    }

    static {
        Companion = new Companion(null);
        ERRORS$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)Companion.ERRORS.2.INSTANCE);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002R$\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00048BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MissingArrayAccessorAutoImportFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "ERRORS", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "getERRORS", "()Ljava/util/Collection;", "ERRORS$delegate", "Lkotlin/Lazy;", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "importName", "Lorg/jetbrains/kotlin/name/Name;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private static final /* synthetic */ KProperty[] $$delegatedProperties;

        private final Name importName(Diagnostic diagnostic) {
            Name name2;
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual(diagnosticFactory, Errors.NO_GET_METHOD)) {
                name2 = OperatorNameConventions.GET;
            } else if (Intrinsics.areEqual(diagnosticFactory, Errors.NO_SET_METHOD)) {
                name2 = OperatorNameConventions.SET;
            } else {
                throw (Throwable)new IllegalStateException("Shouldn't be called for other diagnostics");
            }
            return name2;
        }

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtArrayAccessExpression> createAction(@NotNull Diagnostic diagnostic) {
            Unit unit;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DiagnosticFactory<?> factory2 = diagnostic.getFactory();
            boolean value$iv = Intrinsics.areEqual(factory2, Errors.NO_GET_METHOD) || Intrinsics.areEqual(factory2, Errors.NO_SET_METHOD);
            if (_Assertions.ENABLED) {
                if (!value$iv) {
                    String message$iv$iv = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            PsiElement element2 = diagnostic.getPsiElement();
            if (element2 instanceof KtArrayAccessExpression && ((KtArrayAccessExpression)element2).getArrayExpression() != null) {
                KtArrayAccessExpression ktArrayAccessExpression = (KtArrayAccessExpression)element2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktArrayAccessExpression, (String)"element");
                return new MissingArrayAccessorAutoImportFix(ktArrayAccessExpression, (Collection<Name>)AddToStdlibKt.singletonList(this.importName(diagnostic)), true);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<DiagnosticFactory<?>> getERRORS() {
            void $receiver$iv;
            Lazy lazy = ERRORS$delegate;
            Companion companion = this;
            KProperty property$iv = $$delegatedProperties[0];
            return (Collection)$receiver$iv.getValue();
        }

        private Companion() {
        }

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "ERRORS", "getERRORS()Ljava/util/Collection;"))};
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

