/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import java.util.List;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;
import org.jetbrains.kotlin.idea.versions.VersionedLibrary;

public class KotlinConfigurationCheckerComponent
extends AbstractProjectComponent {
    public static final String CONFIGURE_NOTIFICATION_GROUP_ID = "Configure Kotlin in Project";

    protected KotlinConfigurationCheckerComponent(Project project) {
        super(project);
        NotificationsConfiguration.getNotificationsConfiguration().register(CONFIGURE_NOTIFICATION_GROUP_ID, NotificationDisplayType.STICKY_BALLOON, true);
    }

    public void projectOpened() {
        super.projectOpened();
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(){

            @Override
            public void run() {
                DumbService.getInstance((Project)KotlinConfigurationCheckerComponent.this.myProject).smartInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        List<VersionedLibrary> libraries = OutdatedKotlinRuntimeCheckerKt.findOutdatedKotlinLibraries(KotlinConfigurationCheckerComponent.this.myProject);
                        if (!libraries.isEmpty()) {
                            OutdatedKotlinRuntimeCheckerKt.notifyOutdatedKotlinRuntime(KotlinConfigurationCheckerComponent.this.myProject, libraries);
                        }
                        ConfigureKotlinInProjectUtilsKt.showConfigureKotlinNotificationIfNeeded(KotlinConfigurationCheckerComponent.this.myProject, OutdatedKotlinRuntimeCheckerKt.collectModulesWithOutdatedRuntime(libraries));
                    }
                });
            }
        });
    }
}

