/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.kotlin.idea.configuration.KotlinMavenConfigurator;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

public class KotlinJavaMavenConfigurator
extends KotlinMavenConfigurator {
    private static final String NAME = "maven";
    private static final String STD_LIB_ID = "kotlin-stdlib";
    private static final String PRESENTABLE_TEXT = "Maven";

    public KotlinJavaMavenConfigurator() {
        super(STD_LIB_ID, NAME, PRESENTABLE_TEXT);
    }

    @Override
    protected boolean isKotlinModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinJavaMavenConfigurator", "isKotlinModule"));
        }
        return ProjectStructureUtil.hasKotlinRuntimeInScope(module);
    }

    @Override
    protected void createExecutions(VirtualFile virtualFile, MavenDomPlugin kotlinPlugin, Module module) {
        this.createExecution(virtualFile, kotlinPlugin, module, false);
        this.createExecution(virtualFile, kotlinPlugin, module, true);
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        JvmPlatform jvmPlatform = JvmPlatform.INSTANCE;
        if (jvmPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJavaMavenConfigurator", "getTargetPlatform"));
        }
        return jvmPlatform;
    }
}

