/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.unwrap;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinComponentUnwrapper;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinRemover;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinUnwrapRemoveBase;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTryExpression;

public class KotlinUnwrappers {
    private KotlinUnwrappers() {
    }

    public static class KotlinFinallyRemover
    extends KotlinRemover {
        public KotlinFinallyRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof KtFinallySection;
        }
    }

    public static class KotlinFinallyUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinFinallyUnwrapper(String key) {
            super(key);
        }

        @Override
        public boolean isApplicableTo(PsiElement e) {
            return super.isApplicableTo(e) && this.getEnclosingElement((KtElement)e).getParent() instanceof KtBlockExpression;
        }

        @Override
        @NotNull
        protected KtElement getEnclosingElement(@NotNull KtElement element2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinFinallyUnwrapper", "getEnclosingElement"));
            }
            KtElement ktElement = (KtElement)element2.getParent();
            if (ktElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinFinallyUnwrapper", "getEnclosingElement"));
            }
            return ktElement;
        }

        @Override
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinFinallyUnwrapper", "getExpressionToUnwrap"));
            }
            return target instanceof KtFinallySection ? ((KtFinallySection)target).getFinalExpression() : null;
        }
    }

    public static class KotlinCatchRemover
    extends KotlinRemover {
        public KotlinCatchRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof KtCatchClause;
        }
    }

    public static class KotlinCatchUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinCatchUnwrapper(String key) {
            super(key);
        }

        @Override
        @NotNull
        protected KtElement getEnclosingElement(@NotNull KtElement element2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinCatchUnwrapper", "getEnclosingElement"));
            }
            KtElement ktElement = (KtElement)element2.getParent();
            if (ktElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinCatchUnwrapper", "getEnclosingElement"));
            }
            return ktElement;
        }

        @Override
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinCatchUnwrapper", "getExpressionToUnwrap"));
            }
            return target instanceof KtCatchClause ? ((KtCatchClause)target).getCatchBody() : null;
        }
    }

    public static class KotlinTryUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinTryUnwrapper(String key) {
            super(key);
        }

        @Override
        @Nullable
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinTryUnwrapper", "getExpressionToUnwrap"));
            }
            return target instanceof KtTryExpression ? ((KtTryExpression)target).getTryBlock() : null;
        }
    }

    public static class KotlinLoopUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinLoopUnwrapper(String key) {
            super(key);
        }

        @Override
        @Nullable
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinLoopUnwrapper", "getExpressionToUnwrap"));
            }
            return target instanceof KtLoopExpression ? ((KtLoopExpression)target).getBody() : null;
        }
    }

    public static class KotlinElseRemover
    extends KotlinUnwrapRemoveBase {
        public KotlinElseRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof KtIfExpression && ((KtIfExpression)e).getCondition() != null && ((KtIfExpression)e).getThen() != null && ((KtIfExpression)e).getElse() != null;
        }

        protected void doUnwrap(PsiElement element2, KotlinUnwrapRemoveBase.Context context) throws IncorrectOperationException {
            KtIfExpression ifExpr = (KtIfExpression)element2;
            context.replace(ifExpr, KtPsiFactoryKt.KtPsiFactory((PsiElement)ifExpr).createIf(ifExpr.getCondition(), ifExpr.getThen(), null));
        }
    }

    public static class KotlinThenUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinThenUnwrapper(String key) {
            super(key);
        }

        @Override
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinThenUnwrapper", "getExpressionToUnwrap"));
            }
            return target instanceof KtIfExpression ? ((KtIfExpression)target).getThen() : null;
        }
    }

    public static class KotlinElseUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinElseUnwrapper(String key) {
            super(key);
        }

        @Override
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinElseUnwrapper", "getExpressionToUnwrap"));
            }
            return target instanceof KtIfExpression ? ((KtIfExpression)target).getElse() : null;
        }
    }

    public static class KotlinExpressionRemover
    extends KotlinRemover {
        public KotlinExpressionRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof KtExpression && e.getParent() instanceof KtBlockExpression;
        }
    }
}

