/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.KotlinSurrounderUtils;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.MoveDeclarationsOutHelper;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinStatementsSurrounder;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

public abstract class KotlinIfSurrounderBase
extends KotlinStatementsSurrounder {
    @Override
    @Nullable
    protected TextRange surroundStatements(Project project, Editor editor, PsiElement container2, PsiElement[] statements) {
        if ((statements = MoveDeclarationsOutHelper.move(container2, statements, this.isGenerateDefaultInitializers())).length == 0) {
            KotlinSurrounderUtils.showErrorHint(project, editor, KotlinSurrounderUtils.SURROUND_WITH_ERROR);
            return null;
        }
        KtIfExpression ifExpression2 = (KtIfExpression)KtPsiFactoryKt.KtPsiFactory(project).createExpression(this.getCodeTemplate());
        ifExpression2 = (KtIfExpression)container2.addAfter((PsiElement)ifExpression2, statements[statements.length - 1]);
        KtBlockExpression thenBranch = (KtBlockExpression)ifExpression2.getThen();
        assert (thenBranch != null) : "Then branch should exist for created if expression: " + ifExpression2.getText();
        KotlinSurrounderUtils.addStatementsInBlock(thenBranch, statements);
        container2.deleteChildRange(statements[0], statements[statements.length - 1]);
        ifExpression2 = (KtIfExpression)CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)ifExpression2);
        KtExpression condition2 = ifExpression2.getCondition();
        assert (condition2 != null) : "Condition should exists for created if expression: " + ifExpression2.getText();
        TextRange range = condition2.getTextRange();
        TextRange textRange = new TextRange(range.getStartOffset(), range.getStartOffset());
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        return textRange;
    }

    @NotNull
    protected abstract String getCodeTemplate();

    protected abstract boolean isGenerateDefaultInitializers();
}

