/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheServiceImplKt;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinResolveDataProvider;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0011J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/PerFileAnalysisCache;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "componentProvider", "Lorg/jetbrains/kotlin/container/ComponentProvider;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/container/ComponentProvider;)V", "cache", "Ljava/util/HashMap;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "getComponentProvider", "()Lorg/jetbrains/kotlin/container/ComponentProvider;", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "analyze", "analyzableElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "getAnalysisResults", "element", "lookUp", "idea-analysis"})
public final class PerFileAnalysisCache {
    private final HashMap<PsiElement, AnalysisResult> cache;
    @NotNull
    private final KtFile file;
    @NotNull
    private final ComponentProvider componentProvider;

    private final AnalysisResult lookUp(KtElement analyzableElement) {
        ArrayList descendantsOfCurrent = CollectionsKt.arrayListOf((Object[])new PsiElement[0]);
        HashSet toRemove = SetsKt.hashSetOf((Object[])new PsiElement[0]);
        AnalysisResult result2 = null;
        for (PsiElement current : PsiUtilsKt.getParentsWithSelf((PsiElement)analyzableElement)) {
            AnalysisResult cached = this.cache.get(current);
            if (cached != null) {
                result2 = cached;
                toRemove.addAll(descendantsOfCurrent);
                descendantsOfCurrent.clear();
            }
            descendantsOfCurrent.add(current);
        }
        this.cache.keySet().removeAll(toRemove);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final AnalysisResult getAnalysisResults(@NotNull KtElement element2) {
        AnalysisResult analysisResult;
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        boolean value$iv = Intrinsics.areEqual((Object)element2.getContainingKtFile(), (Object)this.file);
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv = "Wrong file. Expected " + this.file + ", but was " + element2.getContainingKtFile();
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        KtElement analyzableParent = KotlinResolveDataProvider.INSTANCE.findAnalyzableParent(element2);
        PerFileAnalysisCache lock$iv = this;
        synchronized (lock$iv) {
            AnalysisResult analysisResult2;
            AnalysisResult cached = this.lookUp(analyzableParent);
            if (cached != null) {
                analysisResult2 = cached;
            } else {
                void value$iv2;
                void key$iv;
                void $receiver$iv;
                AnalysisResult result2 = this.analyze(analyzableParent);
                Map map2 = this.cache;
                KtElement ktElement = analyzableParent;
                AnalysisResult analysisResult3 = result2;
                $receiver$iv.put(key$iv, value$iv2);
                analysisResult2 = result2;
            }
            analysisResult = analysisResult2;
        }
        return analysisResult;
    }

    private final AnalysisResult analyze(KtElement analyzableElement) {
        Project project = analyzableElement.getProject();
        if (DumbService.isDumb((Project)project)) {
            return AnalysisResult.Companion.getEMPTY();
        }
        try {
            Project project2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            return KotlinResolveDataProvider.INSTANCE.analyze(project2, this.componentProvider, analyzableElement);
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (IndexNotReadyException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            DiagnosticUtils.throwIfRunningOnServer(e);
            KotlinCacheServiceImplKt.getLOG().error(e);
            BindingContext bindingContext2 = BindingContext.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"BindingContext.EMPTY");
            return AnalysisResult.Companion.error(bindingContext2, e);
        }
    }

    @NotNull
    public final KtFile getFile() {
        return this.file;
    }

    @NotNull
    public final ComponentProvider getComponentProvider() {
        return this.componentProvider;
    }

    public PerFileAnalysisCache(@NotNull KtFile file, @NotNull ComponentProvider componentProvider) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)componentProvider, (String)"componentProvider");
        this.file = file;
        this.componentProvider = componentProvider;
        this.cache = new HashMap();
    }
}

