/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinPluginUpdater;
import org.jetbrains.kotlin.idea.PluginUpdateStatus;
import org.jetbrains.kotlin.idea.actions.ConfigurePluginUpdatesForm;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\b\u0010\u0015\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/actions/ConfigurePluginUpdatesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "form", "Lorg/jetbrains/kotlin/idea/actions/ConfigurePluginUpdatesForm;", "initialSelectedChannel", "", "update", "Lorg/jetbrains/kotlin/idea/PluginUpdateStatus$Update;", "createCenterPanel", "Ljavax/swing/JComponent;", "doCancelAction", "", "doOKAction", "hasEAPChannel", "", "resetUpdateStatus", "saveSelectedChannel", "channel", "saveSettings", "Companion", "idea"})
public final class ConfigurePluginUpdatesDialog
extends DialogWrapper {
    private final ConfigurePluginUpdatesForm form;
    private final int initialSelectedChannel;
    private PluginUpdateStatus.Update update;
    @NotNull
    private static final String EAP_UPDATE_HOST = "https://plugins.jetbrains.com/plugins/eap/6954";
    public static final Companion Companion = new Companion(null);

    private final void resetUpdateStatus() {
        this.form.updateStatusLabel.setText(" ");
        this.form.installButton.setVisible(false);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JComponent jComponent = this.form.mainPanel;
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"form.mainPanel");
        return jComponent;
    }

    private final void saveSettings() {
        this.saveSelectedChannel(this.form.channelCombo.getSelectedIndex());
    }

    private final void saveSelectedChannel(int channel) {
        List hosts = UpdateSettings.getInstance().getStoredPluginHosts();
        switch (channel) {
            case 0: {
                hosts.remove(Companion.getEAP_UPDATE_HOST());
                break;
            }
            case 1: {
                if (!(hosts.contains(Companion.getEAP_UPDATE_HOST()) ^ true)) break;
                hosts.add(Companion.getEAP_UPDATE_HOST());
            }
        }
    }

    protected void doOKAction() {
        this.saveSettings();
        super.doOKAction();
    }

    public void doCancelAction() {
        this.saveSelectedChannel(this.initialSelectedChannel);
        super.doCancelAction();
    }

    private final boolean hasEAPChannel() {
        return UpdateSettings.getInstance().getPluginHosts().contains(Companion.getEAP_UPDATE_HOST());
    }

    public ConfigurePluginUpdatesDialog(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project, false);
        this.form = new ConfigurePluginUpdatesForm();
        this.setTitle("Configure Kotlin Plugin Updates");
        this.form.updateCheckProgressIcon.suspend();
        this.form.updateCheckProgressIcon.setPaintPassiveIcon(false);
        this.form.checkForUpdatesNowButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.saveSettings();
                ((ConfigurePluginUpdatesDialog)this).form.updateCheckProgressIcon.resume();
                this.resetUpdateStatus();
                KotlinPluginUpdater.Companion.getInstance().runUpdateCheck((Function1<? super PluginUpdateStatus, Boolean>)((Function1)new Function1<PluginUpdateStatus, Boolean>(){

                    public final boolean invoke(@NotNull PluginUpdateStatus pluginUpdateStatus) {
                        Intrinsics.checkParameterIsNotNull((Object)pluginUpdateStatus, (String)"pluginUpdateStatus");
                        ((ConfigurePluginUpdatesDialog)this).form.updateCheckProgressIcon.suspend();
                        PluginUpdateStatus pluginUpdateStatus2 = pluginUpdateStatus;
                        if (Intrinsics.areEqual((Object)pluginUpdateStatus2, (Object)PluginUpdateStatus.LatestVersionInstalled.INSTANCE)) {
                            ((ConfigurePluginUpdatesDialog)this).form.updateStatusLabel.setText("You have the latest version of the plugin installed.");
                        } else if (pluginUpdateStatus2 instanceof PluginUpdateStatus.Update) {
                            update = (PluginUpdateStatus.Update)pluginUpdateStatus;
                            ((ConfigurePluginUpdatesDialog)this).form.installButton.setVisible(true);
                            ((ConfigurePluginUpdatesDialog)this).form.updateStatusLabel.setText("A new version " + ((PluginUpdateStatus.Update)pluginUpdateStatus).getPluginDescriptor().getVersion() + " is available");
                        } else if (pluginUpdateStatus2 instanceof PluginUpdateStatus.CheckFailed) {
                            ((ConfigurePluginUpdatesDialog)this).form.updateStatusLabel.setText("Update check failed: " + ((PluginUpdateStatus.CheckFailed)pluginUpdateStatus).getMessage());
                        }
                        return false;
                    }
                }));
            }
        });
        this.form.installButton.setVisible(false);
        this.form.installButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                Unit unit;
                PluginUpdateStatus.Update update = update;
                if (update != null) {
                    PluginUpdateStatus.Update $receiver$iv = update;
                    PluginUpdateStatus.Update it2 = $receiver$iv;
                    this.close(0);
                    KotlinPluginUpdater.installPluginUpdate$default(KotlinPluginUpdater.Companion.getInstance(), it2, null, 2, null);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
        });
        this.form.channelCombo.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.resetUpdateStatus();
            }
        });
        this.initialSelectedChannel = this.hasEAPChannel() ? 1 : 0;
        this.form.channelCombo.setSelectedIndex(this.initialSelectedChannel);
        this.init();
    }

    static {
        EAP_UPDATE_HOST = EAP_UPDATE_HOST;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/actions/ConfigurePluginUpdatesDialog$Companion;", "", "()V", "EAP_UPDATE_HOST", "", "getEAP_UPDATE_HOST", "()Ljava/lang/String;", "idea"})
    public static final class Companion {
        @NotNull
        public final String getEAP_UPDATE_HOST() {
            return EAP_UPDATE_HOST;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

