/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.openapi.util.Condition;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.ComponentEditor;
import com.intellij.uiDesigner.propertyInspector.properties.BindingProperty;
import com.intellij.uiDesigner.propertyInspector.renderers.ComponentRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.uiDesigner.radComponents.RadScrollPane;
import com.intellij.uiDesigner.snapShooter.SnapshotContext;
import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IntroComponentProperty
extends IntrospectedProperty<String> {
    private final ComponentRenderer myRenderer = new ComponentRenderer();
    private ComponentEditor myEditor;
    @NonNls
    private static final String CLIENT_PROPERTY_KEY_PREFIX = "IntroComponentProperty_";
    private final Class myPropertyType;
    private final Condition<RadComponent> myFilter;

    public IntroComponentProperty(String name, Method readMethod, Method writeMethod, Class propertyType, Condition<RadComponent> filter, boolean storeAsClient) {
        super(name, readMethod, writeMethod, storeAsClient);
        this.myPropertyType = propertyType;
        this.myFilter = filter;
    }

    @Override
    @NotNull
    public PropertyRenderer<String> getRenderer() {
        ComponentRenderer componentRenderer = this.myRenderer;
        if (componentRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/IntroComponentProperty", "getRenderer"));
        }
        return componentRenderer;
    }

    @Override
    public PropertyEditor<String> getEditor() {
        if (this.myEditor == null) {
            this.myEditor = new ComponentEditor(this.myPropertyType, this.myFilter);
        }
        return this.myEditor;
    }

    @Override
    public String getValue(RadComponent component) {
        return (String)component.getDelegee().getClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName());
    }

    @Override
    protected void setValueImpl(RadComponent component, String value) throws Exception {
        component.getDelegee().putClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName(), value);
        if (this.getName().equals("labelFor") && !component.isLoadingProperties() && component.getModule() != null) {
            this.updateLabelForBinding(component);
        }
    }

    void updateLabelForBinding(RadComponent component) {
        RadComponent valueComponent;
        RadRootContainer root;
        String value = this.getValue(component);
        String text = FormInspectionUtil.getText(component.getModule(), component);
        if (text != null && value != null && (root = (RadRootContainer)FormEditingUtil.getRoot(component)) != null && (valueComponent = (RadComponent)FormEditingUtil.findComponent(root, value)) != null) {
            if (valueComponent instanceof RadScrollPane && ((RadScrollPane)valueComponent).getComponentCount() == 1) {
                valueComponent = ((RadScrollPane)valueComponent).getComponent(0);
            }
            BindingProperty.checkCreateBindingFromText(valueComponent, text);
        }
    }

    @Override
    public void resetValue(RadComponent component) throws Exception {
        this.setValue(component, null);
        this.markTopmostModified(component, false);
    }

    @Override
    public void importSnapshotValue(SnapshotContext context, JComponent component, RadComponent radComponent) {
        Component value;
        try {
            value = (Component)this.myReadMethod.invoke((Object)component, EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            return;
        }
        if (value != null && value instanceof JComponent) {
            context.registerComponentProperty(component, this.getName(), (JComponent)value);
        }
    }
}

