/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.FileCheckingInspection;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.uiDesigner.ErrorInfo;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.PsiPropertiesProvider;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.FormEditorErrorCollector;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.inspections.FormFileErrorCollector;
import com.intellij.uiDesigner.inspections.FormInspectionTool;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IRootContainer;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import com.intellij.uiDesigner.radComponents.RadComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFormInspection
extends BaseJavaLocalInspectionTool
implements FileCheckingInspection,
FormInspectionTool {
    private final String myInspectionKey;

    public BaseFormInspection(@NonNls @NotNull String inspectionKey) {
        if (inspectionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionKey", "com/intellij/uiDesigner/inspections/BaseFormInspection", "<init>"));
        }
        this.myInspectionKey = inspectionKey;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/inspections/BaseFormInspection", "getDisplayName"));
        }
        return "";
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = UIDesignerBundle.message("form.inspections.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/inspections/BaseFormInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    @NonNls
    public String getShortName() {
        String string = this.myInspectionKey;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/inspections/BaseFormInspection", "getShortName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean isActive(PsiElement psiRoot) {
        InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)psiRoot.getProject()).getInspectionProfile();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)this.myInspectionKey);
        return key != null && profile.isToolEnabled(key, psiRoot);
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/uiDesigner/inspections/BaseFormInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/uiDesigner/inspections/BaseFormInspection", "checkFile"));
        }
        if (file.getFileType().equals(StdFileTypes.GUI_DESIGNER_FORM)) {
            LwRootContainer rootContainer;
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            final Module module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)file.getProject());
            if (module == null) {
                return null;
            }
            try {
                rootContainer = Utils.getRootContainer((String)file.getText(), (PropertiesProvider)new PsiPropertiesProvider(module));
            }
            catch (Exception e) {
                return null;
            }
            if (rootContainer.isInspectionSuppressed(this.getShortName(), null)) {
                return null;
            }
            final FormFileErrorCollector collector = new FormFileErrorCollector(file, manager, isOnTheFly);
            this.startCheckForm((IRootContainer)rootContainer);
            FormEditingUtil.iterate((IComponent)rootContainer, new FormEditingUtil.ComponentVisitor(){

                public boolean visit(IComponent component) {
                    if (!rootContainer.isInspectionSuppressed(BaseFormInspection.this.getShortName(), component.getId())) {
                        BaseFormInspection.this.checkComponentProperties(module, component, collector);
                    }
                    return true;
                }
            });
            this.doneCheckForm((IRootContainer)rootContainer);
            return collector.result();
        }
        return null;
    }

    @Override
    public void startCheckForm(IRootContainer rootContainer) {
    }

    @Override
    public void doneCheckForm(IRootContainer rootContainer) {
    }

    @Override
    @Nullable
    public ErrorInfo[] checkComponent(@NotNull GuiEditor editor, @NotNull RadComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uiDesigner/inspections/BaseFormInspection", "checkComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/inspections/BaseFormInspection", "checkComponent"));
        }
        FormEditorErrorCollector collector = new FormEditorErrorCollector(editor, component);
        this.checkComponentProperties(component.getModule(), component, collector);
        return collector.result();
    }

    protected abstract void checkComponentProperties(Module var1, IComponent var2, FormErrorCollector var3);
}

