/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsEmpty;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.operation.InOperationTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public final class WhenTranslator
extends AbstractTranslator {
    @NotNull
    private final KtWhenExpression whenExpression;
    @Nullable
    private final JsExpression expressionToMatch;

    @Nullable
    public static JsNode translate(@NotNull KtWhenExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translate"));
        }
        return new WhenTranslator(expression, context).translate();
    }

    private WhenTranslator(@NotNull KtWhenExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "<init>"));
        }
        super(context);
        this.whenExpression = expression;
        KtExpression subject = expression.getSubjectExpression();
        if (subject != null) {
            JsExpression subjectExpression = Translation.translateAsExpression(subject, context);
            if (TranslationUtils.isCacheNeeded(subjectExpression)) {
                TemporaryVariable subjectVar = context.declareTemporary(null);
                context.addStatementToCurrentBlock(JsAstUtils.assignment(subjectVar.reference(), subjectExpression).makeStmt());
                subjectExpression = subjectVar.reference();
            }
            this.expressionToMatch = subjectExpression;
        } else {
            this.expressionToMatch = null;
        }
    }

    private JsStatement translate() {
        if (this.expressionToMatch != null && JsAstUtils.isEmptyExpression(this.expressionToMatch)) {
            return JsEmpty.INSTANCE;
        }
        JsIf currentIf = null;
        JsIf resultIf = null;
        for (KtWhenEntry entry : this.whenExpression.getEntries()) {
            JsBlock statementBlock = new JsBlock();
            JsStatement statement = WhenTranslator.translateEntryExpression(entry, this.context(), statementBlock);
            if (resultIf == null && entry.isElse()) {
                this.context().addStatementsToCurrentBlockFrom(statementBlock);
                return statement;
            }
            statement = JsAstUtils.mergeStatementInBlockIfNeeded(statement, statementBlock);
            if (resultIf == null) {
                resultIf = currentIf = JsAstUtils.newJsIf(this.translateConditions(entry, this.context()), statement);
                continue;
            }
            if (entry.isElse()) {
                currentIf.setElseStatement(statement);
                return resultIf;
            }
            JsBlock conditionsBlock = new JsBlock();
            JsIf nextIf = JsAstUtils.newJsIf(this.translateConditions(entry, this.context().innerBlock(conditionsBlock)), statement);
            JsStatement statementToAdd = JsAstUtils.mergeStatementInBlockIfNeeded(nextIf, conditionsBlock);
            currentIf.setElseStatement(statementToAdd);
            currentIf = nextIf;
        }
        return resultIf;
    }

    @NotNull
    private static JsStatement translateEntryExpression(@NotNull KtWhenEntry entry, @NotNull TranslationContext context, @NotNull JsBlock block) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateEntryExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateEntryExpression"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateEntryExpression"));
        }
        KtExpression expressionToExecute = entry.getExpression();
        assert (expressionToExecute != null) : "WhenEntry should have whenExpression to execute.";
        JsStatement jsStatement = Translation.translateAsStatement(expressionToExecute, context, block);
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateEntryExpression"));
        }
        return jsStatement;
    }

    @NotNull
    private JsExpression translateConditions(@NotNull KtWhenEntry entry, @NotNull TranslationContext context) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateConditions"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateConditions"));
        }
        KtWhenCondition[] conditions = entry.getConditions();
        assert (conditions.length > 0) : "When entry (not else) should have at least one condition";
        if (conditions.length == 1) {
            JsExpression jsExpression = this.translateCondition(conditions[0], context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateConditions"));
            }
            return jsExpression;
        }
        JsExpression result2 = this.translateCondition(conditions[0], context);
        for (int i = 1; i < conditions.length; ++i) {
            result2 = this.translateOrCondition(result2, conditions[i], context);
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateConditions"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateOrCondition(@NotNull JsExpression leftExpression, @NotNull KtWhenCondition condition, @NotNull TranslationContext context) {
        if (leftExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftExpression", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateOrCondition"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateOrCondition"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateOrCondition"));
        }
        TranslationContext rightContext = context.innerBlock();
        JsExpression rightExpression = this.translateCondition(condition, rightContext);
        context.moveVarsFrom(rightContext);
        if (rightContext.currentBlockIsEmpty()) {
            JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.OR, leftExpression, rightExpression);
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateOrCondition"));
            }
            return jsBinaryOperation;
        }
        assert (rightExpression instanceof JsNameRef) : "expected JsNameRef, but: " + rightExpression;
        JsNameRef result2 = (JsNameRef)rightExpression;
        JsIf ifStatement = JsAstUtils.newJsIf(leftExpression, JsAstUtils.assignment(result2, JsLiteral.TRUE).makeStmt(), rightContext.getCurrentBlock());
        context.addStatementToCurrentBlock(ifStatement);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateOrCondition"));
        }
        return jsNameRef;
    }

    @NotNull
    private JsExpression translateCondition(@NotNull KtWhenCondition condition, @NotNull TranslationContext context) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateCondition"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateCondition"));
        }
        JsExpression patternMatchExpression = this.translateWhenConditionToBooleanExpression(condition, context);
        if (WhenTranslator.isNegated(condition)) {
            JsPrefixOperation jsPrefixOperation = JsAstUtils.negated(patternMatchExpression);
            if (jsPrefixOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateCondition"));
            }
            return jsPrefixOperation;
        }
        JsExpression jsExpression = patternMatchExpression;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateCondition"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateWhenConditionToBooleanExpression(@NotNull KtWhenCondition condition, @NotNull TranslationContext context) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateWhenConditionToBooleanExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateWhenConditionToBooleanExpression"));
        }
        if (condition instanceof KtWhenConditionIsPattern) {
            JsExpression jsExpression = this.translateIsCondition((KtWhenConditionIsPattern)condition, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateWhenConditionToBooleanExpression"));
            }
            return jsExpression;
        }
        if (condition instanceof KtWhenConditionWithExpression) {
            JsExpression jsExpression = this.translateExpressionCondition((KtWhenConditionWithExpression)condition, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateWhenConditionToBooleanExpression"));
            }
            return jsExpression;
        }
        if (condition instanceof KtWhenConditionInRange) {
            JsExpression jsExpression = this.translateRangeCondition((KtWhenConditionInRange)condition, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateWhenConditionToBooleanExpression"));
            }
            return jsExpression;
        }
        throw new AssertionError((Object)("Unsupported when condition " + condition.getClass()));
    }

    @NotNull
    private JsExpression translateIsCondition(@NotNull KtWhenConditionIsPattern conditionIsPattern, @NotNull TranslationContext context) {
        if (conditionIsPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conditionIsPattern", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateIsCondition"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateIsCondition"));
        }
        JsExpression expressionToMatch = this.getExpressionToMatch();
        assert (expressionToMatch != null) : "An is-check is not allowed in when() without subject.";
        KtTypeReference typeReference = conditionIsPattern.getTypeReference();
        assert (typeReference != null) : "An is-check must have a type reference.";
        JsExpression jsExpression = Translation.patternTranslator(context).translateIsCheck(expressionToMatch, typeReference);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateIsCondition"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateExpressionCondition(@NotNull KtWhenConditionWithExpression condition, @NotNull TranslationContext context) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateExpressionCondition"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateExpressionCondition"));
        }
        KtExpression patternExpression = condition.getExpression();
        assert (patternExpression != null) : "Expression pattern should have an expression.";
        JsExpression expressionToMatch = this.getExpressionToMatch();
        if (expressionToMatch == null) {
            JsExpression jsExpression = Translation.patternTranslator(context).translateExpressionForExpressionPattern(patternExpression);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateExpressionCondition"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = Translation.patternTranslator(context).translateExpressionPattern(expressionToMatch, patternExpression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateExpressionCondition"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateRangeCondition(@NotNull KtWhenConditionInRange condition, @NotNull TranslationContext context) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateRangeCondition"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateRangeCondition"));
        }
        KtExpression patternExpression = condition.getRangeExpression();
        assert (patternExpression != null) : "Expression pattern should have an expression: " + PsiUtilsKt.getTextWithLocation(condition);
        JsExpression expressionToMatch = this.getExpressionToMatch();
        assert (expressionToMatch != null) : "Range pattern is only available for 'when (C) { in ... }'  expressions: " + PsiUtilsKt.getTextWithLocation(condition);
        HashMap<KtExpression, JsExpression> subjectAliases = new HashMap<KtExpression, JsExpression>();
        subjectAliases.put(this.whenExpression.getSubjectExpression(), expressionToMatch);
        TranslationContext callContext = context.innerContextWithAliasesForExpressions(subjectAliases);
        JsExpression jsExpression = new InOperationTranslator(callContext, expressionToMatch, condition.getRangeExpression(), condition.getOperationReference()).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "translateRangeCondition"));
        }
        return jsExpression;
    }

    @Nullable
    private JsExpression getExpressionToMatch() {
        return this.expressionToMatch;
    }

    private static boolean isNegated(@NotNull KtWhenCondition condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/js/translate/expression/WhenTranslator", "isNegated"));
        }
        if (condition instanceof KtWhenConditionIsPattern) {
            return ((KtWhenConditionIsPattern)condition).isNegated();
        }
        return false;
    }
}

