/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;

public final class DynamicContext {
    @NotNull
    private final JsScope currentScope;
    @NotNull
    private final JsBlock currentBlock;
    @Nullable
    private JsVars vars;

    @NotNull
    public static DynamicContext rootContext(@NotNull JsScope rootScope2, @NotNull JsBlock globalBlock) {
        if (rootScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/kotlin/js/translate/context/DynamicContext", "rootContext"));
        }
        if (globalBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalBlock", "org/jetbrains/kotlin/js/translate/context/DynamicContext", "rootContext"));
        }
        DynamicContext dynamicContext = new DynamicContext(rootScope2, globalBlock);
        if (dynamicContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/DynamicContext", "rootContext"));
        }
        return dynamicContext;
    }

    @NotNull
    public static DynamicContext newContext(@NotNull JsScope scope2, @NotNull JsBlock block) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/js/translate/context/DynamicContext", "newContext"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/context/DynamicContext", "newContext"));
        }
        DynamicContext dynamicContext = new DynamicContext(scope2, block);
        if (dynamicContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/DynamicContext", "newContext"));
        }
        return dynamicContext;
    }

    private DynamicContext(@NotNull JsScope scope2, @NotNull JsBlock block) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/js/translate/context/DynamicContext", "<init>"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/context/DynamicContext", "<init>"));
        }
        this.currentScope = scope2;
        this.currentBlock = block;
    }

    @NotNull
    public DynamicContext innerBlock(@NotNull JsBlock block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/js/translate/context/DynamicContext", "innerBlock"));
        }
        DynamicContext dynamicContext = new DynamicContext(this.currentScope, block);
        if (dynamicContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/DynamicContext", "innerBlock"));
        }
        return dynamicContext;
    }

    @NotNull
    public TemporaryVariable declareTemporary(@Nullable JsExpression initExpression) {
        if (this.vars == null) {
            this.vars = new JsVars();
            this.currentBlock.getStatements().add(this.vars);
        }
        JsName temporaryName = this.currentScope.declareTemporary();
        this.vars.add(new JsVars.JsVar(temporaryName, null));
        TemporaryVariable temporaryVariable = TemporaryVariable.create(temporaryName, initExpression);
        if (temporaryVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/DynamicContext", "declareTemporary"));
        }
        return temporaryVariable;
    }

    void moveVarsFrom(@NotNull DynamicContext dynamicContext) {
        if (dynamicContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dynamicContext", "org/jetbrains/kotlin/js/translate/context/DynamicContext", "moveVarsFrom"));
        }
        if (dynamicContext.vars != null) {
            if (this.vars == null) {
                this.vars = dynamicContext.vars;
                this.currentBlock.getStatements().add(this.vars);
            } else {
                this.vars.addAll(dynamicContext.vars);
            }
            dynamicContext.currentBlock.getStatements().remove(dynamicContext.vars);
            dynamicContext.vars = null;
        }
    }

    @NotNull
    public JsScope getScope() {
        JsScope jsScope = this.currentScope;
        if (jsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/DynamicContext", "getScope"));
        }
        return jsScope;
    }

    @NotNull
    public JsBlock jsBlock() {
        JsBlock jsBlock = this.currentBlock;
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/DynamicContext", "jsBlock"));
        }
        return jsBlock;
    }
}

