/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.ClassMissingCase;
import org.jetbrains.kotlin.cfg.UnknownMissingCase;
import org.jetbrains.kotlin.cfg.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenMissingCase;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cfg/WhenOnClassExhaustivenessChecker;", "Lorg/jetbrains/kotlin/cfg/WhenExhaustivenessChecker;", "()V", "getMissingClassCases", "", "Lorg/jetbrains/kotlin/cfg/WhenMissingCase;", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "memberDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getReference", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin-compiler"})
abstract class WhenOnClassExhaustivenessChecker
implements WhenExhaustivenessChecker {
    private final KtSimpleNameExpression getReference(KtExpression expression) {
        KtExpression ktExpression = expression;
        return ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)expression : (ktExpression instanceof KtQualifiedExpression ? this.getReference(((KtQualifiedExpression)expression).getSelectorExpression()) : (KtSimpleNameExpression)null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<WhenMissingCase> getMissingClassCases(@NotNull KtWhenExpression whenExpression, @NotNull Set<? extends ClassDescriptor> memberDescriptors, @NotNull BindingContext context) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Object condition;
        Intrinsics.checkParameterIsNotNull(whenExpression, "whenExpression");
        Intrinsics.checkParameterIsNotNull(memberDescriptors, "memberDescriptors");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (memberDescriptors.isEmpty()) {
            return CollectionsKt.listOf(UnknownMissingCase.INSTANCE);
        }
        LinkedHashSet<ClassDescriptor> checkedDescriptors = new LinkedHashSet<ClassDescriptor>();
        for (KtWhenEntry ktWhenEntry : whenExpression.getEntries()) {
            KtWhenCondition[] ktWhenConditionArray = ktWhenEntry.getConditions();
            for (int i = 0; i < ktWhenConditionArray.length; ++i) {
                DeclarationDescriptor target;
                KtSimpleNameExpression reference;
                condition = ktWhenConditionArray[i];
                boolean negated = false;
                ClassDescriptor checkedDescriptor = null;
                if (condition instanceof KtWhenConditionIsPattern) {
                    KotlinType checkedType = (KotlinType)context.get(BindingContext.TYPE, ((KtWhenConditionIsPattern)condition).getTypeReference());
                    if (checkedType != null) {
                        checkedDescriptor = TypeUtils.getClassDescriptor(checkedType);
                    }
                    negated = ((KtWhenConditionIsPattern)condition).isNegated();
                } else if (condition instanceof KtWhenConditionWithExpression && ((KtWhenConditionWithExpression)condition).getExpression() != null && (reference = this.getReference(((KtWhenConditionWithExpression)condition).getExpression())) != null && (target = (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, reference)) instanceof ClassDescriptor) {
                    checkedDescriptor = (ClassDescriptor)target;
                }
                if (checkedDescriptor == null || !memberDescriptors.contains(checkedDescriptor) || condition instanceof KtWhenConditionWithExpression && !DescriptorUtils.isObject(checkedDescriptor) && !DescriptorUtils.isEnumEntry(checkedDescriptor)) continue;
                if (negated) {
                    if (checkedDescriptors.contains(checkedDescriptor)) {
                        return CollectionsKt.emptyList();
                    }
                    checkedDescriptors.addAll((Collection)memberDescriptors);
                    checkedDescriptors.remove(checkedDescriptor);
                    continue;
                }
                checkedDescriptors.add(checkedDescriptor);
            }
        }
        Iterable iterable = CollectionsKt.toList((Iterable)SetsKt.minus(memberDescriptors, (Iterable)checkedDescriptors));
        Iterable iterator2 = iterable;
        condition = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ClassDescriptor negated = (ClassDescriptor)item$iv$iv;
            void var14_18 = destination$iv$iv;
            ClassMissingCase classMissingCase = new ClassMissingCase((ClassDescriptor)it);
            var14_18.add(classMissingCase);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean isApplicable(@NotNull KotlinType subjectType) {
        Intrinsics.checkParameterIsNotNull(subjectType, "subjectType");
        return WhenExhaustivenessChecker.DefaultImpls.isApplicable(this, subjectType);
    }
}

