/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentRefValueIntObjectHashMap<V>
implements ConcurrentIntObjectMap<V> {
    private final ConcurrentIntObjectMap<IntReference<V>> myMap = ContainerUtil.createConcurrentIntObjectMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    ConcurrentRefValueIntObjectHashMap() {
    }

    protected abstract IntReference<V> createReference(int var1, @NotNull V var2, ReferenceQueue<V> var3);

    private void processQueue() {
        IntReference ref;
        while ((ref = (IntReference)((Object)this.myQueue.poll())) != null) {
            int key = ref.getKey();
            this.myMap.remove(key, ref);
        }
        return;
    }

    @Override
    @NotNull
    public V cacheOrGet(int key, @NotNull V value) {
        IntReference<V> ref;
        boolean replaced;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "cacheOrGet"));
        }
        this.processQueue();
        IntReference<V> newRef = this.createReference(key, value, this.myQueue);
        do {
            if ((ref = this.myMap.putIfAbsent(key, newRef)) == null) {
                V v = value;
                if (v == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "cacheOrGet"));
                }
                return v;
            }
            V old = ref.get();
            if (old == null) continue;
            V v = old;
            if (v == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "cacheOrGet"));
            }
            return v;
        } while (!(replaced = this.myMap.replace(key, ref, newRef)));
        V v = value;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "cacheOrGet"));
        }
        return v;
    }

    @Override
    public boolean remove(int key, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "remove"));
        }
        this.processQueue();
        return this.myMap.remove(key, this.createReference(key, value, this.myQueue));
    }

    @Override
    public boolean replace(int key, @NotNull V oldValue, @NotNull V newValue) {
        if (oldValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldValue", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "replace"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "replace"));
        }
        this.processQueue();
        return this.myMap.replace(key, this.createReference(key, oldValue, this.myQueue), this.createReference(key, newValue, this.myQueue));
    }

    @Override
    public V put(int key, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "put"));
        }
        this.processQueue();
        IntReference<V> ref = this.myMap.put(key, this.createReference(key, value, this.myQueue));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V get(int key) {
        IntReference<V> ref = this.myMap.get(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V remove(int key) {
        this.processQueue();
        IntReference<V> ref = this.myMap.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public boolean containsKey(int key) {
        return this.myMap.containsKey(key);
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    @NotNull
    public int[] keys() {
        int[] nArray = this.myMap.keys();
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "keys"));
        }
        return nArray;
    }

    @Override
    @NotNull
    public Iterable<ConcurrentIntObjectMap.IntEntry<V>> entries() {
        final Iterator<ConcurrentIntObjectMap.IntEntry<IntReference<V>>> entryIterator = this.myMap.entries().iterator();
        Iterable iterable = new Iterable<ConcurrentIntObjectMap.IntEntry<V>>(){

            @Override
            public Iterator<ConcurrentIntObjectMap.IntEntry<V>> iterator() {
                return new Iterator<ConcurrentIntObjectMap.IntEntry<V>>(){
                    ConcurrentIntObjectMap.IntEntry<V> next = this.nextAliveEntry();

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public ConcurrentIntObjectMap.IntEntry<V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ConcurrentIntObjectMap.IntEntry result2 = this.next;
                        this.next = this.nextAliveEntry();
                        return result2;
                    }

                    private ConcurrentIntObjectMap.IntEntry<V> nextAliveEntry() {
                        while (entryIterator.hasNext()) {
                            ConcurrentIntObjectMap.IntEntry entry = (ConcurrentIntObjectMap.IntEntry)entryIterator.next();
                            final Object v = ((IntReference)entry.getValue()).get();
                            if (v == null) continue;
                            final int key = entry.getKey();
                            return new ConcurrentIntObjectMap.IntEntry<V>(){

                                @Override
                                public int getKey() {
                                    return key;
                                }

                                @Override
                                @NotNull
                                public V getValue() {
                                    Object object = v;
                                    if (object == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap$1$1$1", "getValue"));
                                    }
                                    return object;
                                }
                            };
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "entries"));
        }
        return iterable;
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    @NotNull
    public Enumeration<V> elements() {
        final Enumeration<IntReference<V>> elementRefs = this.myMap.elements();
        Enumeration enumeration = new Enumeration<V>(){
            V next = this.findNextRef();

            private V findNextRef() {
                while (elementRefs.hasMoreElements()) {
                    IntReference result2 = (IntReference)elementRefs.nextElement();
                    Object v = result2.get();
                    if (v == null) continue;
                    return v;
                }
                return null;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next != null;
            }

            @Override
            public V nextElement() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object v = this.next;
                this.next = this.findNextRef();
                return v;
            }
        };
        if (enumeration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "elements"));
        }
        return enumeration;
    }

    @Override
    public V putIfAbsent(int key, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "putIfAbsent"));
        }
        IntReference<V> prev = this.myMap.putIfAbsent(key, this.createReference(key, value, this.myQueue));
        return prev == null ? null : (V)prev.get();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        THashSet result2 = new THashSet();
        ContainerUtil.addAll(result2, this.elements());
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "values"));
        }
        return tHashSet;
    }

    @Override
    public boolean containsValue(@NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "containsValue"));
        }
        for (ConcurrentIntObjectMap.IntEntry<IntReference<V>> entry : this.myMap.entries()) {
            if (!value.equals(entry.getValue().get())) continue;
            return true;
        }
        return false;
    }

    protected static interface IntReference<V> {
        public int getKey();

        public V get();
    }
}

