/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsIdentifierImpl;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsNameValuePairImpl
extends ClsElementImpl
implements PsiNameValuePair {
    private final ClsElementImpl myParent;
    private final ClsIdentifierImpl myNameIdentifier;
    private final PsiAnnotationMemberValue myMemberValue;

    public ClsNameValuePairImpl(@NotNull ClsElementImpl parent2, @Nullable String name, @NotNull PsiAnnotationMemberValue value) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/compiled/ClsNameValuePairImpl", "<init>"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/impl/compiled/ClsNameValuePairImpl", "<init>"));
        }
        this.myParent = parent2;
        this.myNameIdentifier = name != null ? new ClsIdentifierImpl(this, name) : null;
        this.myMemberValue = ClsParsingUtil.getMemberValue(value, this);
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsNameValuePairImpl", "appendMirrorText"));
        }
        ClsNameValuePairImpl.appendText(this.myNameIdentifier, 0, buffer, " = ");
        ClsNameValuePairImpl.appendText(this.myMemberValue, 0, buffer);
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsNameValuePairImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, null);
        PsiNameValuePair mirror = (PsiNameValuePair)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsNameValuePairImpl.setMirrorIfPresent(this.getNameIdentifier(), mirror.getNameIdentifier());
        ClsNameValuePairImpl.setMirrorIfPresent(this.getValue(), mirror.getValue());
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (this.myNameIdentifier != null) {
            PsiElement[] psiElementArray = new PsiElement[]{this.myNameIdentifier, this.myMemberValue};
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsNameValuePairImpl", "getChildren"));
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = new PsiElement[]{this.myMemberValue};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsNameValuePairImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/compiled/ClsNameValuePairImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitNameValuePair(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return this.myNameIdentifier;
    }

    @Override
    public String getName() {
        return this.myNameIdentifier != null ? this.myNameIdentifier.getText() : null;
    }

    @Override
    public String getLiteralValue() {
        return null;
    }

    @Override
    public PsiAnnotationMemberValue getValue() {
        return this.myMemberValue;
    }

    @Override
    @NotNull
    public PsiAnnotationMemberValue setValue(@NotNull PsiAnnotationMemberValue newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/psi/impl/compiled/ClsNameValuePairImpl", "setValue"));
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }
}

