/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamUtil {
    private static final Logger LOG = Logger.getInstance(StreamUtil.class);

    private StreamUtil() {
    }

    public static int copyStreamContent(InputStream inputStream, OutputStream outputStream) throws IOException {
        int count;
        byte[] buffer = new byte[10240];
        int total = 0;
        while ((count = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, count);
            total += count;
        }
        return total;
    }

    public static byte[] loadFromStream(InputStream inputStream) throws IOException {
        UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
        try {
            StreamUtil.copyStreamContent(inputStream, outputStream);
        }
        finally {
            inputStream.close();
        }
        return outputStream.toByteArray();
    }

    public static String readText(InputStream inputStream, @NotNull String encoding) throws IOException {
        if (encoding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "com/intellij/openapi/util/io/StreamUtil", "readText"));
        }
        byte[] data = StreamUtil.loadFromStream(inputStream);
        return new String(data, encoding);
    }

    public static void closeStream(@Nullable Closeable stream2) {
        if (stream2 != null) {
            try {
                stream2.close();
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }
}

