/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.file.CachingFileVisitDetails;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryWalker;
import org.gradle.api.specs.Spec;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.Stat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDirectoryWalker
implements DirectoryWalker {
    private final StringInterner relativePathStringInterner = new StringInterner();

    @Override
    public void walkDir(File file, RelativePath path, FileVisitor visitor, Spec<FileTreeElement> spec, AtomicBoolean stopFlag, FileSystem fileSystem, boolean postfix) {
        int i;
        File[] children = file.listFiles();
        if (children == null) {
            if (file.isDirectory() && !file.canRead()) {
                throw new GradleException(String.format("Could not list contents of directory '%s' as it is not readable.", file));
            }
            throw new GradleException(String.format("Could not list contents of '%s'.", file));
        }
        ArrayList<CachingFileVisitDetails> dirs = new ArrayList<CachingFileVisitDetails>();
        for (i = 0; !stopFlag.get() && i < children.length; ++i) {
            File child = children[i];
            boolean isFile = child.isFile();
            RelativePath childPath = path.append(isFile, this.relativePathStringInterner.intern(child.getName()));
            CachingFileVisitDetails details = new CachingFileVisitDetails(child, childPath, stopFlag, (Chmod)fileSystem, (Stat)fileSystem, !isFile);
            if (!DirectoryFileTree.isAllowed(details, spec)) continue;
            if (isFile) {
                visitor.visitFile(details);
                continue;
            }
            dirs.add(details);
        }
        for (i = 0; !stopFlag.get() && i < dirs.size(); ++i) {
            FileVisitDetails dir = (FileVisitDetails)dirs.get(i);
            if (postfix) {
                this.walkDir(dir.getFile(), dir.getRelativePath(), visitor, spec, stopFlag, fileSystem, postfix);
                visitor.visitDir(dir);
                continue;
            }
            visitor.visitDir(dir);
            this.walkDir(dir.getFile(), dir.getRelativePath(), visitor, spec, stopFlag, fileSystem, postfix);
        }
    }
}

