/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitSvnRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepositoryFiles;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitRepositoryReader {
    private static final Logger LOG = Logger.getInstance(GitRepositoryReader.class);
    private static final Processor<File> NOT_HIDDEN_DIRECTORIES = new Processor<File>(){

        public boolean process(File dir) {
            return !GitRepositoryReader.isHidden(dir);
        }
    };
    private static Pattern BRANCH_PATTERN = Pattern.compile(" *(?:ref:)? */?((?:refs/heads/|refs/remotes/)?\\S+)");
    @NonNls
    private static final String REFS_HEADS_PREFIX = "refs/heads/";
    @NonNls
    private static final String REFS_REMOTES_PREFIX = "refs/remotes/";
    @NotNull
    private final File myHeadFile;
    @NotNull
    private final File myRefsHeadsDir;
    @NotNull
    private final File myRefsRemotesDir;
    @NotNull
    private final File myPackedRefsFile;
    @NotNull
    private final GitRepositoryFiles myGitFiles;

    GitRepositoryReader(@NotNull GitRepositoryFiles gitFiles) {
        if (gitFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitFiles", "git4idea/repo/GitRepositoryReader", "<init>"));
        }
        this.myGitFiles = gitFiles;
        this.myHeadFile = gitFiles.getHeadFile();
        DvcsUtil.assertFileExists((File)this.myHeadFile, (String)(".git/HEAD file not found at " + this.myHeadFile));
        this.myRefsHeadsDir = gitFiles.getRefsHeadsFile();
        this.myRefsRemotesDir = gitFiles.getRefsRemotesFile();
        this.myPackedRefsFile = gitFiles.getPackedRefsPath();
    }

    @NotNull
    GitBranchState readState(@NotNull Collection<GitRemote> remotes) {
        String currentRevision;
        GitLocalBranch currentBranch;
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotes", "git4idea/repo/GitRepositoryReader", "readState"));
        }
        Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> branches = this.readBranches(remotes);
        Map localBranches = (Map)branches.first;
        HeadInfo headInfo = this.readHead();
        Repository.State state = this.readRepositoryState(headInfo);
        if (!headInfo.isBranch || !localBranches.isEmpty()) {
            currentBranch = this.findCurrentBranch(headInfo, state, localBranches.keySet());
            currentRevision = GitRepositoryReader.getCurrentRevision(headInfo, currentBranch == null ? null : (Hash)localBranches.get(currentBranch));
        } else if (headInfo.content != null) {
            currentBranch = new GitLocalBranch(headInfo.content);
            currentRevision = null;
        } else {
            currentBranch = null;
            currentRevision = null;
        }
        if (currentBranch == null && currentRevision == null) {
            LOG.error("Couldn't identify neither current branch nor current revision. .git/HEAD content: [" + headInfo.content + "]");
        }
        GitBranchState gitBranchState = new GitBranchState(currentRevision, currentBranch, state, localBranches, (Map)branches.second);
        if (gitBranchState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readState"));
        }
        return gitBranchState;
    }

    @Nullable
    private static String getCurrentRevision(@NotNull HeadInfo headInfo, @Nullable Hash currentBranchHash) {
        if (headInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headInfo", "git4idea/repo/GitRepositoryReader", "getCurrentRevision"));
        }
        Object currentRevision = !headInfo.isBranch ? headInfo.content : (currentBranchHash == null ? null : currentBranchHash.asString());
        return currentRevision;
    }

    @Nullable
    private GitLocalBranch findCurrentBranch(@NotNull HeadInfo headInfo, @NotNull Repository.State state, @NotNull Set<GitLocalBranch> localBranches) {
        if (headInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headInfo", "git4idea/repo/GitRepositoryReader", "findCurrentBranch"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "git4idea/repo/GitRepositoryReader", "findCurrentBranch"));
        }
        if (localBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localBranches", "git4idea/repo/GitRepositoryReader", "findCurrentBranch"));
        }
        final String currentBranchName = this.findCurrentBranchName(state, headInfo);
        if (currentBranchName == null) {
            return null;
        }
        return (GitLocalBranch)ContainerUtil.find(localBranches, (Condition)new Condition<GitLocalBranch>(){

            public boolean value(GitLocalBranch branch) {
                return branch.getFullName().equals(currentBranchName);
            }
        });
    }

    @NotNull
    private Repository.State readRepositoryState(@NotNull HeadInfo headInfo) {
        if (headInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headInfo", "git4idea/repo/GitRepositoryReader", "readRepositoryState"));
        }
        if (this.isMergeInProgress()) {
            Repository.State state = Repository.State.MERGING;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readRepositoryState"));
            }
            return state;
        }
        if (this.isRebaseInProgress()) {
            Repository.State state = Repository.State.REBASING;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readRepositoryState"));
            }
            return state;
        }
        if (!headInfo.isBranch) {
            Repository.State state = Repository.State.DETACHED;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readRepositoryState"));
            }
            return state;
        }
        Repository.State state = Repository.State.NORMAL;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readRepositoryState"));
        }
        return state;
    }

    @Nullable
    private String findCurrentBranchName(@NotNull Repository.State state, @NotNull HeadInfo headInfo) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "git4idea/repo/GitRepositoryReader", "findCurrentBranchName"));
        }
        if (headInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headInfo", "git4idea/repo/GitRepositoryReader", "findCurrentBranchName"));
        }
        String currentBranch = null;
        if (headInfo.isBranch) {
            currentBranch = headInfo.content;
        } else if (state == Repository.State.REBASING && (currentBranch = GitRepositoryReader.readRebaseDirBranchFile(this.myGitFiles.getRebaseApplyDir())) == null) {
            currentBranch = GitRepositoryReader.readRebaseDirBranchFile(this.myGitFiles.getRebaseMergeDir());
        }
        return GitRepositoryReader.addRefsHeadsPrefixIfNeeded(currentBranch);
    }

    @Nullable
    private static String readRebaseDirBranchFile(@NonNls File rebaseDir) {
        File headName;
        if (rebaseDir.exists() && (headName = new File(rebaseDir, "head-name")).exists()) {
            return DvcsUtil.tryLoadFileOrReturn((File)headName, null, (String)"UTF-8");
        }
        return null;
    }

    @Nullable
    private static String addRefsHeadsPrefixIfNeeded(@Nullable String branchName) {
        if (branchName != null && !branchName.startsWith(REFS_HEADS_PREFIX)) {
            return REFS_HEADS_PREFIX + branchName;
        }
        return branchName;
    }

    private boolean isMergeInProgress() {
        return this.myGitFiles.getMergeHeadFile().exists();
    }

    private boolean isRebaseInProgress() {
        return this.myGitFiles.getRebaseApplyDir().exists() || this.myGitFiles.getRebaseMergeDir().exists();
    }

    @NotNull
    private Map<String, String> readPackedBranches() {
        Map map;
        if (!this.myPackedRefsFile.exists()) {
            Map<String, String> map2 = Collections.emptyMap();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readPackedBranches"));
            }
            return map2;
        }
        try {
            String content = DvcsUtil.tryLoadFile((File)this.myPackedRefsFile, (String)"UTF-8");
            map = ContainerUtil.map2MapNotNull((Object[])LineTokenizer.tokenize((CharSequence)content, (boolean)false), (Function)new Function<String, Pair<String, String>>(){

                public Pair<String, String> fun(String line) {
                    return GitRepositoryReader.parsePackedRefsLine(line);
                }
            });
        }
        catch (RepoStateException e) {
            Map<String, String> map3 = Collections.emptyMap();
            if (map3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readPackedBranches"));
            }
            return map3;
        }
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readPackedBranches"));
        }
        return map;
    }

    @NotNull
    private Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> readBranches(@NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotes", "git4idea/repo/GitRepositoryReader", "readBranches"));
        }
        Map<String, String> data = this.readBranchRefsFromFiles();
        Map<String, Hash> resolvedRefs = GitRepositoryReader.resolveRefs(data);
        Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> pair = GitRepositoryReader.createBranchesFromData(remotes, resolvedRefs);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readBranches"));
        }
        return pair;
    }

    @NotNull
    private Map<String, String> readBranchRefsFromFiles() {
        HashMap result = ContainerUtil.newHashMap(this.readPackedBranches());
        result.putAll(GitRepositoryReader.readFromBranchFiles(this.myRefsHeadsDir, REFS_HEADS_PREFIX));
        result.putAll(GitRepositoryReader.readFromBranchFiles(this.myRefsRemotesDir, REFS_REMOTES_PREFIX));
        result.remove("refs/remotes/origin/HEAD");
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readBranchRefsFromFiles"));
        }
        return hashMap;
    }

    @NotNull
    private static Pair<Map<GitLocalBranch, Hash>, Map<GitRemoteBranch, Hash>> createBranchesFromData(@NotNull Collection<GitRemote> remotes, @NotNull Map<String, Hash> data) {
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotes", "git4idea/repo/GitRepositoryReader", "createBranchesFromData"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "git4idea/repo/GitRepositoryReader", "createBranchesFromData"));
        }
        HashMap localBranches = ContainerUtil.newHashMap();
        HashMap remoteBranches = ContainerUtil.newHashMap();
        for (Map.Entry<String, Hash> entry : data.entrySet()) {
            String refName = entry.getKey();
            Hash hash = entry.getValue();
            if (refName.startsWith(REFS_HEADS_PREFIX)) {
                localBranches.put(new GitLocalBranch(refName), hash);
                continue;
            }
            if (refName.startsWith(REFS_REMOTES_PREFIX)) {
                GitRemoteBranch remoteBranch = GitRepositoryReader.parseRemoteBranch(refName, remotes);
                if (remoteBranch == null) continue;
                remoteBranches.put(remoteBranch, hash);
                continue;
            }
            LOG.warn("Unexpected ref format: " + refName);
        }
        Pair pair = Pair.create((Object)localBranches, (Object)remoteBranches);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "createBranchesFromData"));
        }
        return pair;
    }

    @Nullable
    private static String loadHashFromBranchFile(@NotNull File branchFile) {
        if (branchFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchFile", "git4idea/repo/GitRepositoryReader", "loadHashFromBranchFile"));
        }
        return DvcsUtil.tryLoadFileOrReturn((File)branchFile, null);
    }

    @NotNull
    private static Map<String, String> readFromBranchFiles(final @NotNull File refsRootDir, final @NotNull String prefix) {
        if (refsRootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsRootDir", "git4idea/repo/GitRepositoryReader", "readFromBranchFiles"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "git4idea/repo/GitRepositoryReader", "readFromBranchFiles"));
        }
        if (!refsRootDir.exists()) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readFromBranchFiles"));
            }
            return map;
        }
        final HashMap<String, String> result = new HashMap<String, String>();
        FileUtil.processFilesRecursively((File)refsRootDir, (Processor)new Processor<File>(){

            public boolean process(File file) {
                String relativePath;
                if (!file.isDirectory() && !GitRepositoryReader.isHidden(file) && (relativePath = FileUtil.getRelativePath((File)refsRootDir, (File)file)) != null) {
                    String branchName = prefix + FileUtil.toSystemIndependentName((String)relativePath);
                    String hash = GitRepositoryReader.loadHashFromBranchFile(file);
                    if (hash != null) {
                        result.put(branchName, hash);
                    }
                }
                return true;
            }
        }, NOT_HIDDEN_DIRECTORIES);
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readFromBranchFiles"));
        }
        return hashMap;
    }

    private static boolean isHidden(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/repo/GitRepositoryReader", "isHidden"));
        }
        return file.getName().startsWith(".");
    }

    @Nullable
    private static GitRemoteBranch parseRemoteBranch(@NotNull String fullBranchName, @NotNull Collection<GitRemote> remotes) {
        String branchName;
        String remoteName;
        GitRemote remote;
        if (fullBranchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullBranchName", "git4idea/repo/GitRepositoryReader", "parseRemoteBranch"));
        }
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotes", "git4idea/repo/GitRepositoryReader", "parseRemoteBranch"));
        }
        String stdName = GitBranchUtil.stripRefsPrefix(fullBranchName);
        int slash = stdName.indexOf(47);
        if (slash == -1) {
            return new GitSvnRemoteBranch(fullBranchName);
        }
        do {
            remoteName = stdName.substring(0, slash);
            branchName = stdName.substring(slash + 1);
            remote = GitUtil.findRemoteByName(remotes, remoteName);
            slash = stdName.indexOf(47, slash + 1);
        } while (remote == null && slash >= 0);
        if (remote == null) {
            LOG.debug(String.format("No remote found with the name [%s]. All remotes: %s", remoteName, remotes));
            GitRemote fakeRemote = new GitRemote(remoteName, ContainerUtil.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            return new GitStandardRemoteBranch(fakeRemote, branchName);
        }
        return new GitStandardRemoteBranch(remote, branchName);
    }

    @NotNull
    private HeadInfo readHead() {
        String headContent;
        try {
            headContent = DvcsUtil.tryLoadFile((File)this.myHeadFile, (String)"UTF-8");
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            HeadInfo headInfo = new HeadInfo(false, null);
            if (headInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readHead"));
            }
            return headInfo;
        }
        Hash hash = GitRepositoryReader.parseHash(headContent);
        if (hash != null) {
            HeadInfo headInfo = new HeadInfo(false, headContent);
            if (headInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readHead"));
            }
            return headInfo;
        }
        String target = GitRepositoryReader.getTarget(headContent);
        if (target != null) {
            HeadInfo headInfo = new HeadInfo(true, target);
            if (headInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readHead"));
            }
            return headInfo;
        }
        LOG.error((Throwable)new RepoStateException("Invalid format of the .git/HEAD file: [" + headContent + "]"));
        HeadInfo headInfo = new HeadInfo(false, null);
        if (headInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "readHead"));
        }
        return headInfo;
    }

    @Nullable
    private static Pair<String, String> parsePackedRefsLine(@NotNull String line) {
        int i;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "git4idea/repo/GitRepositoryReader", "parsePackedRefsLine"));
        }
        if ((line = line.trim()).isEmpty()) {
            return null;
        }
        char firstChar = line.charAt(0);
        if (firstChar == '#') {
            return null;
        }
        if (firstChar == '^') {
            return null;
        }
        String hash = null;
        for (i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            hash = line.substring(0, i);
            break;
        }
        if (hash == null) {
            LOG.warn("Ignoring invalid packed-refs line: [" + line + "]");
            return null;
        }
        String branch = null;
        int start = i;
        if (start < line.length() && line.charAt(start++) == ' ') {
            char c;
            for (i = start; i < line.length() && !Character.isWhitespace(c = line.charAt(i)); ++i) {
            }
            branch = line.substring(start, i);
        }
        if (branch == null || !branch.startsWith(REFS_HEADS_PREFIX) && !branch.startsWith(REFS_REMOTES_PREFIX)) {
            return null;
        }
        return Pair.create((Object)GitRepositoryReader.shortBuffer(branch), (Object)GitRepositoryReader.shortBuffer(hash.trim()));
    }

    @NotNull
    private static String shortBuffer(String raw) {
        String string = new String(raw);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "shortBuffer"));
        }
        return string;
    }

    @NotNull
    private static Map<String, Hash> resolveRefs(@NotNull Map<String, String> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "git4idea/repo/GitRepositoryReader", "resolveRefs"));
        }
        final Map<String, Hash> resolved = GitRepositoryReader.getResolvedHashes(data);
        Map unresolved = ContainerUtil.filter(data, (Condition)new Condition<String>(){

            public boolean value(String refName) {
                return !resolved.containsKey(refName);
            }
        });
        boolean progressed = true;
        while (progressed && !unresolved.isEmpty()) {
            progressed = false;
            Iterator iterator = unresolved.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String refName = (String)entry.getKey();
                String refValue = (String)entry.getValue();
                String link = GitRepositoryReader.getTarget(refValue);
                if (link != null) {
                    if (GitRepositoryReader.duplicateEntry(resolved, refName, refValue)) {
                        iterator.remove();
                        continue;
                    }
                    if (!resolved.containsKey(link)) {
                        LOG.debug("Unresolved symbolic link [" + refName + "] pointing to [" + refValue + "]");
                        continue;
                    }
                    Hash targetValue = resolved.get(link);
                    resolved.put(refName, targetValue);
                    iterator.remove();
                    progressed = true;
                    continue;
                }
                LOG.warn("Unexpected record [" + refName + "] -> [" + refValue + "]");
                iterator.remove();
            }
        }
        if (!unresolved.isEmpty()) {
            LOG.warn("Cyclic symbolic links among .git/refs: " + unresolved);
        }
        Map<String, Hash> map = resolved;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "resolveRefs"));
        }
        return map;
    }

    @NotNull
    private static Map<String, Hash> getResolvedHashes(@NotNull Map<String, String> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "git4idea/repo/GitRepositoryReader", "getResolvedHashes"));
        }
        HashMap resolved = ContainerUtil.newHashMap();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String refName = entry.getKey();
            Hash hash = GitRepositoryReader.parseHash(entry.getValue());
            if (hash == null || GitRepositoryReader.duplicateEntry(resolved, refName, hash)) continue;
            resolved.put(refName, hash);
        }
        HashMap hashMap = resolved;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitRepositoryReader", "getResolvedHashes"));
        }
        return hashMap;
    }

    @Nullable
    private static String getTarget(@NotNull String refName) {
        if (refName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refName", "git4idea/repo/GitRepositoryReader", "getTarget"));
        }
        Matcher matcher = BRANCH_PATTERN.matcher(refName);
        if (!matcher.matches()) {
            return null;
        }
        String target = matcher.group(1);
        if (!target.startsWith(REFS_HEADS_PREFIX) && !target.startsWith(REFS_REMOTES_PREFIX)) {
            target = REFS_HEADS_PREFIX + target;
        }
        return target;
    }

    @Nullable
    private static Hash parseHash(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "git4idea/repo/GitRepositoryReader", "parseHash"));
        }
        try {
            return HashImpl.build((String)value);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean duplicateEntry(@NotNull Map<String, Hash> resolved, @NotNull String refName, @NotNull Object newValue) {
        if (resolved == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolved", "git4idea/repo/GitRepositoryReader", "duplicateEntry"));
        }
        if (refName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refName", "git4idea/repo/GitRepositoryReader", "duplicateEntry"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "git4idea/repo/GitRepositoryReader", "duplicateEntry"));
        }
        if (resolved.containsKey(refName)) {
            LOG.error("Duplicate entry for [" + refName + "]. resolved: [" + resolved.get(refName).asString() + "], current: " + newValue + "]");
            return true;
        }
        return false;
    }

    private static class HeadInfo {
        @Nullable
        private final String content;
        private final boolean isBranch;

        HeadInfo(boolean branch, @Nullable String content) {
            this.isBranch = branch;
            this.content = content;
        }
    }
}

