/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.decoder;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BinaryFileParser;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.jpeg.Block;
import org.apache.sanselan.formats.jpeg.JpegConstants;
import org.apache.sanselan.formats.jpeg.JpegUtils;
import org.apache.sanselan.formats.jpeg.ZigZag;
import org.apache.sanselan.formats.jpeg.decoder.DCT;
import org.apache.sanselan.formats.jpeg.decoder.JpegInputStream;
import org.apache.sanselan.formats.jpeg.decoder.YCbCrConverter;
import org.apache.sanselan.formats.jpeg.segments.DHTSegment;
import org.apache.sanselan.formats.jpeg.segments.DQTSegment;
import org.apache.sanselan.formats.jpeg.segments.SOFNSegment;
import org.apache.sanselan.formats.jpeg.segments.SOSSegment;

public class JpegDecoder
extends BinaryFileParser
implements JpegUtils.Visitor,
JpegConstants {
    private DQTSegment.QuantizationTable[] quantizationTables = new DQTSegment.QuantizationTable[4];
    private DHTSegment.HuffmanTable[] huffmanDCTables = new DHTSegment.HuffmanTable[4];
    private DHTSegment.HuffmanTable[] huffmanACTables = new DHTSegment.HuffmanTable[4];
    private SOFNSegment sofnSegment;
    private SOSSegment sosSegment;
    private float[][] scaledQuantizationTables = new float[4][];
    private BufferedImage image = null;
    private ImageReadException imageReadException = null;
    private IOException ioException = null;
    private int[] zz = new int[64];
    private int[] blockInt = new int[64];
    private float[] block = new float[64];

    @Override
    public boolean beginSOS() {
        return true;
    }

    @Override
    public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
        ByteArrayInputStream is = new ByteArrayInputStream(imageData);
        try {
            WritableRaster raster;
            DirectColorModel colorModel;
            int segmentLength = this.read2Bytes("segmentLength", is, "Not a Valid JPEG File");
            byte[] sosSegmentBytes = this.readByteArray("SOSSegment", segmentLength - 2, is, "Not a Valid JPEG File");
            this.sosSegment = new SOSSegment(marker, sosSegmentBytes);
            int hMax = 0;
            int vMax = 0;
            for (int i = 0; i < this.sofnSegment.numberOfComponents; ++i) {
                hMax = Math.max(hMax, this.sofnSegment.components[i].horizontalSamplingFactor);
                vMax = Math.max(vMax, this.sofnSegment.components[i].verticalSamplingFactor);
            }
            int hSize = 8 * hMax;
            int vSize = 8 * vMax;
            JpegInputStream bitInputStream = new JpegInputStream(is);
            int xMCUs = (this.sofnSegment.width + hSize - 1) / hSize;
            int yMCUs = (this.sofnSegment.height + vSize - 1) / vSize;
            Block[] mcu = this.allocateMCUMemory();
            Block[] scaledMCU = new Block[mcu.length];
            for (int i = 0; i < scaledMCU.length; ++i) {
                scaledMCU[i] = new Block(hSize, vSize);
            }
            int[] preds = new int[this.sofnSegment.numberOfComponents];
            if (this.sofnSegment.numberOfComponents == 3) {
                colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
                raster = WritableRaster.createPackedRaster(3, this.sofnSegment.width, this.sofnSegment.height, new int[]{0xFF0000, 65280, 255}, null);
            } else if (this.sofnSegment.numberOfComponents == 1) {
                colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
                raster = WritableRaster.createPackedRaster(3, this.sofnSegment.width, this.sofnSegment.height, new int[]{0xFF0000, 65280, 255}, null);
            } else {
                throw new ImageReadException(this.sofnSegment.numberOfComponents + " components are invalid or unsupported");
            }
            DataBuffer dataBuffer = raster.getDataBuffer();
            for (int y1 = 0; y1 < vSize * yMCUs; y1 += vSize) {
                for (int x1 = 0; x1 < hSize * xMCUs; x1 += hSize) {
                    this.readMCU(bitInputStream, preds, mcu);
                    this.rescaleMCU(mcu, hSize, vSize, scaledMCU);
                    int srcRowOffset = 0;
                    int dstRowOffset = y1 * this.sofnSegment.width + x1;
                    for (int y2 = 0; y2 < vSize && y1 + y2 < this.sofnSegment.height; ++y2) {
                        for (int x2 = 0; x2 < hSize && x1 + x2 < this.sofnSegment.width; ++x2) {
                            int Y;
                            if (scaledMCU.length == 3) {
                                Y = scaledMCU[0].samples[srcRowOffset + x2];
                                int Cb = scaledMCU[1].samples[srcRowOffset + x2];
                                int Cr = scaledMCU[2].samples[srcRowOffset + x2];
                                int rgb = YCbCrConverter.convertYCbCrToRGB(Y, Cb, Cr);
                                dataBuffer.setElem(dstRowOffset + x2, rgb);
                                continue;
                            }
                            if (mcu.length == 1) {
                                Y = scaledMCU[0].samples[srcRowOffset + x2];
                                dataBuffer.setElem(dstRowOffset + x2, Y << 16 | Y << 8 | Y);
                                continue;
                            }
                            throw new ImageReadException("Unsupported JPEG with " + mcu.length + " components");
                        }
                        srcRowOffset += hSize;
                        dstRowOffset += this.sofnSegment.width;
                    }
                }
            }
            this.image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), new Properties());
        }
        catch (ImageReadException imageReadEx) {
            this.imageReadException = imageReadEx;
        }
        catch (IOException ioEx) {
            this.ioException = ioEx;
        }
        catch (RuntimeException ex) {
            this.imageReadException = new ImageReadException("Error parsing JPEG", ex);
        }
    }

    @Override
    public boolean visitSegment(int marker, byte[] markerBytes, int segmentLength, byte[] segmentLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
        block11: {
            block12: {
                block10: {
                    int[] sofnSegments = new int[]{65472, 65473, 65474, 65475, 65477, 65478, 65479, 65481, 65482, 65483, 65485, 65486, 65487};
                    if (Arrays.binarySearch(sofnSegments, marker) < 0) break block10;
                    if (marker != 65472) {
                        throw new ImageReadException("Only sequential, baseline JPEGs are supported at the moment");
                    }
                    this.sofnSegment = new SOFNSegment(marker, segmentData);
                    break block11;
                }
                if (marker != 65499) break block12;
                DQTSegment dqtSegment = new DQTSegment(marker, segmentData);
                for (int i = 0; i < dqtSegment.quantizationTables.size(); ++i) {
                    DQTSegment.QuantizationTable table = (DQTSegment.QuantizationTable)dqtSegment.quantizationTables.get(i);
                    if (0 > table.destinationIdentifier || table.destinationIdentifier >= this.quantizationTables.length) {
                        throw new ImageReadException("Invalid quantization table identifier " + table.destinationIdentifier);
                    }
                    this.quantizationTables[table.destinationIdentifier] = table;
                    int[] quantizationMatrixInt = new int[64];
                    ZigZag.zigZagToBlock(table.elements, quantizationMatrixInt);
                    float[] quantizationMatrixFloat = new float[64];
                    for (int j = 0; j < 64; ++j) {
                        quantizationMatrixFloat[j] = quantizationMatrixInt[j];
                    }
                    DCT.scaleDequantizationMatrix(quantizationMatrixFloat);
                    this.scaledQuantizationTables[table.destinationIdentifier] = quantizationMatrixFloat;
                }
                break block11;
            }
            if (marker != 65476) break block11;
            DHTSegment dhtSegment = new DHTSegment(marker, segmentData);
            for (int i = 0; i < dhtSegment.huffmanTables.size(); ++i) {
                DHTSegment.HuffmanTable[] tables;
                DHTSegment.HuffmanTable table = (DHTSegment.HuffmanTable)dhtSegment.huffmanTables.get(i);
                if (table.tableClass == 0) {
                    tables = this.huffmanDCTables;
                } else if (table.tableClass == 1) {
                    tables = this.huffmanACTables;
                } else {
                    throw new ImageReadException("Invalid huffman table class " + table.tableClass);
                }
                if (0 > table.destinationIdentifier || table.destinationIdentifier >= tables.length) {
                    throw new ImageReadException("Invalid huffman table identifier " + table.destinationIdentifier);
                }
                tables[table.destinationIdentifier] = table;
            }
        }
        return true;
    }

    private void rescaleMCU(Block[] dataUnits, int hSize, int vSize, Block[] ret) {
        for (int i = 0; i < dataUnits.length; ++i) {
            Block block = dataUnits[i];
            if (block.width == hSize && block.height == vSize) {
                System.arraycopy(block.samples, 0, ret[i].samples, 0, hSize * vSize);
                continue;
            }
            int hScale = hSize / block.width;
            int vScale = vSize / block.height;
            if (hScale == 2 && vScale == 2) {
                int srcRowOffset = 0;
                int dstRowOffset = 0;
                for (int y = 0; y < block.height; ++y) {
                    for (int x = 0; x < hSize; ++x) {
                        int sample;
                        ret[i].samples[dstRowOffset + x] = sample = block.samples[srcRowOffset + (x >> 1)];
                        ret[i].samples[dstRowOffset + hSize + x] = sample;
                    }
                    srcRowOffset += block.width;
                    dstRowOffset += 2 * hSize;
                }
                continue;
            }
            int dstRowOffset = 0;
            for (int y = 0; y < vSize; ++y) {
                for (int x = 0; x < hSize; ++x) {
                    ret[i].samples[dstRowOffset + x] = block.samples[y / vScale * block.width + x / hScale];
                }
                dstRowOffset += hSize;
            }
        }
    }

    private Block[] allocateMCUMemory() throws ImageReadException {
        Block[] mcu = new Block[this.sosSegment.numberOfComponents];
        for (int i = 0; i < this.sosSegment.numberOfComponents; ++i) {
            Block fullBlock;
            SOSSegment.Component scanComponent = this.sosSegment.components[i];
            SOFNSegment.Component frameComponent = null;
            for (int j = 0; j < this.sofnSegment.numberOfComponents; ++j) {
                if (this.sofnSegment.components[j].componentIdentifier != scanComponent.scanComponentSelector) continue;
                frameComponent = this.sofnSegment.components[j];
                break;
            }
            if (frameComponent == null) {
                throw new ImageReadException("Invalid component");
            }
            mcu[i] = fullBlock = new Block(8 * frameComponent.horizontalSamplingFactor, 8 * frameComponent.verticalSamplingFactor);
        }
        return mcu;
    }

    private void readMCU(JpegInputStream is, int[] preds, Block[] mcu) throws IOException, ImageReadException {
        for (int i = 0; i < this.sosSegment.numberOfComponents; ++i) {
            SOSSegment.Component scanComponent = this.sosSegment.components[i];
            SOFNSegment.Component frameComponent = null;
            for (int j = 0; j < this.sofnSegment.numberOfComponents; ++j) {
                if (this.sofnSegment.components[j].componentIdentifier != scanComponent.scanComponentSelector) continue;
                frameComponent = this.sofnSegment.components[j];
                break;
            }
            if (frameComponent == null) {
                throw new ImageReadException("Invalid component");
            }
            Block fullBlock = mcu[i];
            for (int y = 0; y < frameComponent.verticalSamplingFactor; ++y) {
                for (int x = 0; x < frameComponent.horizontalSamplingFactor; ++x) {
                    Arrays.fill(this.zz, 0);
                    int t = this.decode(is, this.huffmanDCTables[scanComponent.dcCodingTableSelector]);
                    int diff = this.receive(t, is);
                    diff = this.extend(diff, t);
                    this.zz[0] = preds[i] + diff;
                    preds[i] = this.zz[0];
                    int k = 1;
                    while (true) {
                        int rrrr;
                        int rs = this.decode(is, this.huffmanACTables[scanComponent.acCodingTableSelector]);
                        int ssss = rs & 0xF;
                        int r = rrrr = rs >> 4;
                        if (ssss == 0) {
                            if (r != 15) break;
                            k += 16;
                            continue;
                        }
                        this.zz[k += r] = this.receive(ssss, is);
                        this.zz[k] = this.extend(this.zz[k], ssss);
                        if (k == 63) break;
                        ++k;
                    }
                    int shift = 1 << this.sofnSegment.precision - 1;
                    int max = (1 << this.sofnSegment.precision) - 1;
                    float[] scaledQuantizationTable = this.scaledQuantizationTables[frameComponent.quantTabDestSelector];
                    ZigZag.zigZagToBlock(this.zz, this.blockInt);
                    for (int j = 0; j < 64; ++j) {
                        this.block[j] = (float)this.blockInt[j] * scaledQuantizationTable[j];
                    }
                    DCT.inverseDCT8x8(this.block);
                    int dstRowOffset = 8 * y * 8 * frameComponent.horizontalSamplingFactor + 8 * x;
                    int srcNext = 0;
                    for (int yy = 0; yy < 8; ++yy) {
                        for (int xx = 0; xx < 8; ++xx) {
                            float sample = this.block[srcNext++];
                            int result = (sample += (float)shift) < 0.0f ? 0 : (sample > (float)max ? max : JpegDecoder.fastRound(sample));
                            fullBlock.samples[dstRowOffset + xx] = result;
                        }
                        dstRowOffset += 8 * frameComponent.horizontalSamplingFactor;
                    }
                }
            }
        }
    }

    private static int fastRound(float x) {
        return (int)(x + 0.5f);
    }

    private int extend(int v, int t) {
        int vt = 1 << t - 1;
        while (v < vt) {
            vt = (-1 << t) + 1;
            v += vt;
        }
        return v;
    }

    private int receive(int ssss, JpegInputStream is) throws IOException, ImageReadException {
        int v = 0;
        for (int i = 0; i != ssss; ++i) {
            v = (v << 1) + is.nextBit();
        }
        return v;
    }

    private int decode(JpegInputStream is, DHTSegment.HuffmanTable huffmanTable) throws IOException, ImageReadException {
        int i = 1;
        int code = is.nextBit();
        while (code > huffmanTable.maxCode[i]) {
            ++i;
            code = code << 1 | is.nextBit();
        }
        int j = huffmanTable.valPtr[i];
        int value = huffmanTable.huffVal[j += code - huffmanTable.minCode[i]];
        return value;
    }

    public BufferedImage decode(ByteSource byteSource) throws IOException, ImageReadException {
        JpegUtils jpegUtils = new JpegUtils();
        jpegUtils.traverseJFIF(byteSource, this);
        if (this.imageReadException != null) {
            throw this.imageReadException;
        }
        if (this.ioException != null) {
            throw this.ioException;
        }
        return this.image;
    }
}

