#!/bin/sh
export PATH='/usr/obj/ports/hs-concurrent-extra-0.7.0.9/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: concurrent-extra
version: 0.7.0.9
id: concurrent-extra-0.7.0.9-7747d5cd8b6bdb4f2aa074d3a1ecd6da
key: concu_9OFxPvomtrN1KY01buq4VI
license: BSD3
copyright: (c) 2010-2012 Bas van Dijk & Roel van Dijk
maintainer: Bas van Dijk <v.dijk.bas@gmail.com>
            Roel van Dijk <vandijk.roel@gmail.com>
stability: experimental
homepage: https://github.com/basvandijk/concurrent-extra
synopsis: Extra concurrency primitives
description:
    The @concurrent-extra@ package offers among other things the
    following selection of synchronisation primitives:
    .
    * @Broadcast@: Wake multiple threads by broadcasting a value.
    .
    * @Event@: Wake multiple threads by signalling an event.
    .
    * @Lock@: Enforce exclusive access to a resource. Also known as a
    binary semaphore or mutex. The package additionally provides an
    alternative that works in the @STM@ monad.
    .
    * @RLock@: A lock which can be acquired multiple times by the same
    thread. Also known as a reentrant mutex.
    .
    * @ReadWriteLock@: Multiple-reader, single-writer locks. Used to
    protect shared resources which may be concurrently read, but only
    sequentially written.
    .
    * @ReadWriteVar@: Concurrent read, sequential write variables.
    .
    Please consult the API documentation of the individual modules for
    more detailed information.
    .
    This package was inspired by the concurrency libraries of Java and
    Python.
category: Concurrency
author: Bas van Dijk <v.dijk.bas@gmail.com>
        Roel van Dijk <vandijk.roel@gmail.com>
exposed: True
exposed-modules:
    Control.Concurrent.Lock Control.Concurrent.STM.Lock
    Control.Concurrent.RLock Control.Concurrent.Event
    Control.Concurrent.Broadcast Control.Concurrent.ReadWriteLock
    Control.Concurrent.ReadWriteVar
hidden-modules: Utils
trusted: False
import-dirs: /usr/local/lib/ghc/concurrent-extra-0.7.0.9
library-dirs: /usr/local/lib/ghc/concurrent-extra-0.7.0.9
data-dir: /usr/local/share/hs-concurrent-extra-0.7.0.9
hs-libraries: HSconcurrent-extra-0.7.0.9-9OFxPvomtrN1KY01buq4VI
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    stm-2.4.4-e969ad03f1a61caf3d689ab8ef7862f8
    unbounded-delays-0.1.0.9-8636ff14e3532228d9cf4bddb2b0654e
haddock-interfaces: /usr/local/share/doc/hs-concurrent-extra-0.7.0.9/html/concurrent-extra.haddock
haddock-html: /usr/local/share/doc/hs-concurrent-extra-0.7.0.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
