#!/bin/sh
p="${0%/*}/bin/ghc-pkg --no-user-package-db --global-package-db ${0%/*}/package.conf.d"
$p register --force - << 'EOF'
name: rts
version: 1.0
id: builtin_rts
key: rts
license: BSD3
maintainer: glasgow-haskell-users@haskell.org
exposed: True
trusted: False
library-dirs: /usr/local/lib/ghc/rts
hs-libraries: HSrts Cffi
extra-libraries:
    m
include-dirs: /usr/local/lib/ghc/include
includes:
    Stg.h
ld-options: "-Wl,-u,ghczmprim_GHCziTypes_Izh_static_info"
            "-Wl,-u,ghczmprim_GHCziTypes_Czh_static_info"
            "-Wl,-u,ghczmprim_GHCziTypes_Fzh_static_info"
            "-Wl,-u,ghczmprim_GHCziTypes_Dzh_static_info"
            "-Wl,-u,base_GHCziPtr_Ptr_static_info"
            "-Wl,-u,ghczmprim_GHCziTypes_Wzh_static_info"
            "-Wl,-u,base_GHCziInt_I8zh_static_info"
            "-Wl,-u,base_GHCziInt_I16zh_static_info"
            "-Wl,-u,base_GHCziInt_I32zh_static_info"
            "-Wl,-u,base_GHCziInt_I64zh_static_info"
            "-Wl,-u,base_GHCziWord_W8zh_static_info"
            "-Wl,-u,base_GHCziWord_W16zh_static_info"
            "-Wl,-u,base_GHCziWord_W32zh_static_info"
            "-Wl,-u,base_GHCziWord_W64zh_static_info"
            "-Wl,-u,base_GHCziStable_StablePtr_static_info"
            "-Wl,-u,ghczmprim_GHCziTypes_Izh_con_info"
            "-Wl,-u,ghczmprim_GHCziTypes_Czh_con_info"
            "-Wl,-u,ghczmprim_GHCziTypes_Fzh_con_info"
            "-Wl,-u,ghczmprim_GHCziTypes_Dzh_con_info"
            "-Wl,-u,base_GHCziPtr_Ptr_con_info"
            "-Wl,-u,base_GHCziPtr_FunPtr_con_info"
            "-Wl,-u,base_GHCziStable_StablePtr_con_info"
            "-Wl,-u,ghczmprim_GHCziTypes_False_closure"
            "-Wl,-u,ghczmprim_GHCziTypes_True_closure"
            "-Wl,-u,base_GHCziPack_unpackCString_closure"
            "-Wl,-u,base_GHCziIOziException_stackOverflow_closure"
            "-Wl,-u,base_GHCziIOziException_heapOverflow_closure"
            "-Wl,-u,base_ControlziExceptionziBase_nonTermination_closure"
            "-Wl,-u,base_GHCziIOziException_blockedIndefinitelyOnMVar_closure"
            "-Wl,-u,base_GHCziIOziException_blockedIndefinitelyOnSTM_closure"
            "-Wl,-u,base_GHCziIOziException_allocationLimitExceeded_closure"
            "-Wl,-u,base_ControlziExceptionziBase_nestedAtomically_closure"
            "-Wl,-u,base_GHCziEventziThread_blockedOnBadFD_closure"
            "-Wl,-u,base_GHCziWeak_runFinalizzerBatch_closure"
            "-Wl,-u,base_GHCziTopHandler_flushStdHandles_closure"
            "-Wl,-u,base_GHCziTopHandler_runIO_closure"
            "-Wl,-u,base_GHCziTopHandler_runNonIO_closure"
            "-Wl,-u,base_GHCziConcziIO_ensureIOManagerIsRunning_closure"
            "-Wl,-u,base_GHCziConcziIO_ioManagerCapabilitiesChanged_closure"
            "-Wl,-u,base_GHCziConcziSync_runSparks_closure"
            "-Wl,-u,base_GHCziConcziSignal_runHandlersPtr_closure"
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: ghc-prim
version: 0.4.0.0
id: ghc-prim-0.4.0.0-6cdc86811872333585fa98756aa7c51e
key: ghcpr_8TmvWUcS1U1IKHT0levwg3
license: BSD3
maintainer: libraries@haskell.org
synopsis: GHC primitives
description:
    GHC primitives.
category: GHC
exposed: True
exposed-modules:
    GHC.CString GHC.Classes GHC.Debug GHC.IntWord64 GHC.Magic
    GHC.PrimopWrappers GHC.Tuple GHC.Types GHC.Prim
trusted: False
import-dirs: /usr/local/lib/ghc/ghcpr_8TmvWUcS1U1IKHT0levwg3
library-dirs: /usr/local/lib/ghc/ghcpr_8TmvWUcS1U1IKHT0levwg3
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/ghc-prim-0.4.0.0
hs-libraries: HSghc-prim-0.4.0.0-8TmvWUcS1U1IKHT0levwg3
depends:
    builtin_rts
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/ghc-prim-0.4.0.0/ghc-prim.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/ghc-prim-0.4.0.0
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: integer-gmp
version: 1.0.0.0
id: integer-gmp-1.0.0.0-3c8c40657a9870f5c33be17496806d8d
key: integ_2aU3IZNMF9a7mQ0OzsZ0dS
license: BSD3
maintainer: hvr@gnu.org
synopsis: Integer library based on GMP
category: Numeric, Algebra
author: Herbert Valerio Riedel
exposed: True
exposed-modules:
    GHC.Integer GHC.Integer.Logarithms GHC.Integer.Logarithms.Internals
    GHC.Integer.GMP.Internals
hidden-modules: GHC.Integer.Type
trusted: False
import-dirs: /usr/local/lib/ghc/integ_2aU3IZNMF9a7mQ0OzsZ0dS
library-dirs: /usr/local/lib/ghc/integ_2aU3IZNMF9a7mQ0OzsZ0dS
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/integer-gmp-1.0.0.0
hs-libraries: HSinteger-gmp-1.0.0.0-2aU3IZNMF9a7mQ0OzsZ0dS
include-dirs: /usr/local/lib/ghc/integ_2aU3IZNMF9a7mQ0OzsZ0dS/include
depends:
    ghc-prim-0.4.0.0-6cdc86811872333585fa98756aa7c51e
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/integer-gmp-1.0.0.0/integer-gmp.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/integer-gmp-1.0.0.0
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: base
version: 4.8.2.0
id: base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
key: base_HQfYBxpPvuw8OunzQu6JGM
license: BSD3
maintainer: libraries@haskell.org
synopsis: Basic libraries
description:
    This package contains the "Prelude" and its support libraries,
    and a large collection of useful libraries ranging from data
    structures to parsing combinators and debugging utilities.
category: Prelude
exposed: True
exposed-modules:
    Control.Applicative Control.Arrow Control.Category
    Control.Concurrent Control.Concurrent.Chan Control.Concurrent.MVar
    Control.Concurrent.QSem Control.Concurrent.QSemN Control.Exception
    Control.Exception.Base Control.Monad Control.Monad.Fix
    Control.Monad.Instances Control.Monad.ST Control.Monad.ST.Lazy
    Control.Monad.ST.Lazy.Safe Control.Monad.ST.Lazy.Unsafe
    Control.Monad.ST.Safe Control.Monad.ST.Strict
    Control.Monad.ST.Unsafe Control.Monad.Zip Data.Bifunctor Data.Bits
    Data.Bool Data.Char Data.Coerce Data.Complex Data.Data Data.Dynamic
    Data.Either Data.Eq Data.Fixed Data.Foldable Data.Function
    Data.Functor Data.Functor.Identity Data.IORef Data.Int Data.Ix
    Data.List Data.Maybe Data.Monoid Data.Ord Data.Proxy Data.Ratio
    Data.STRef Data.STRef.Lazy Data.STRef.Strict Data.String
    Data.Traversable Data.Tuple Data.Type.Bool Data.Type.Coercion
    Data.Type.Equality Data.Typeable Data.Typeable.Internal Data.Unique
    Data.Version Data.Void Data.Word Debug.Trace Foreign Foreign.C
    Foreign.C.Error Foreign.C.String Foreign.C.Types Foreign.Concurrent
    Foreign.ForeignPtr Foreign.ForeignPtr.Safe
    Foreign.ForeignPtr.Unsafe Foreign.Marshal Foreign.Marshal.Alloc
    Foreign.Marshal.Array Foreign.Marshal.Error Foreign.Marshal.Pool
    Foreign.Marshal.Safe Foreign.Marshal.Unsafe Foreign.Marshal.Utils
    Foreign.Ptr Foreign.Safe Foreign.StablePtr Foreign.Storable GHC.Arr
    GHC.Base GHC.Char GHC.Conc GHC.Conc.IO GHC.Conc.Signal
    GHC.Conc.Sync GHC.ConsoleHandler GHC.Constants GHC.Desugar GHC.Enum
    GHC.Environment GHC.Err GHC.Exception GHC.Exts GHC.Fingerprint
    GHC.Fingerprint.Type GHC.Float GHC.Float.ConversionUtils
    GHC.Float.RealFracMethods GHC.Foreign GHC.ForeignPtr GHC.GHCi
    GHC.Generics GHC.IO GHC.IO.Buffer GHC.IO.BufferedIO GHC.IO.Device
    GHC.IO.Encoding GHC.IO.Encoding.CodePage GHC.IO.Encoding.Failure
    GHC.IO.Encoding.Iconv GHC.IO.Encoding.Latin1 GHC.IO.Encoding.Types
    GHC.IO.Encoding.UTF16 GHC.IO.Encoding.UTF32 GHC.IO.Encoding.UTF8
    GHC.IO.Exception GHC.IO.FD GHC.IO.Handle GHC.IO.Handle.FD
    GHC.IO.Handle.Internals GHC.IO.Handle.Text GHC.IO.Handle.Types
    GHC.IO.IOMode GHC.IOArray GHC.IORef GHC.IP GHC.Int GHC.List
    GHC.MVar GHC.Natural GHC.Num GHC.OldList GHC.PArr GHC.Pack
    GHC.Profiling GHC.Ptr GHC.Read GHC.Real GHC.RTS.Flags GHC.ST
    GHC.StaticPtr GHC.STRef GHC.Show GHC.SrcLoc GHC.Stable GHC.Stack
    GHC.Stats GHC.Storable GHC.TopHandler GHC.TypeLits GHC.Unicode
    GHC.Weak GHC.Word Numeric Numeric.Natural Prelude System.CPUTime
    System.Console.GetOpt System.Environment System.Exit System.IO
    System.IO.Error System.IO.Unsafe System.Info System.Mem
    System.Mem.StableName System.Mem.Weak System.Posix.Internals
    System.Posix.Types System.Timeout Text.ParserCombinators.ReadP
    Text.ParserCombinators.ReadPrec Text.Printf Text.Read Text.Read.Lex
    Text.Show Text.Show.Functions Unsafe.Coerce GHC.Event
hidden-modules: Control.Monad.ST.Imp Control.Monad.ST.Lazy.Imp
                Data.OldList Foreign.ForeignPtr.Imp
                System.Environment.ExecutablePath GHC.Event.Arr GHC.Event.Array
                GHC.Event.Clock GHC.Event.Control GHC.Event.EPoll
                GHC.Event.IntTable GHC.Event.Internal GHC.Event.KQueue
                GHC.Event.Manager GHC.Event.PSQ GHC.Event.Poll GHC.Event.Thread
                GHC.Event.TimerManager GHC.Event.Unique
trusted: False
import-dirs: /usr/local/lib/ghc/base_HQfYBxpPvuw8OunzQu6JGM
library-dirs: /usr/local/lib/ghc/base_HQfYBxpPvuw8OunzQu6JGM
              /usr/local/lib
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/base-4.8.2.0
hs-libraries: HSbase-4.8.2.0-HQfYBxpPvuw8OunzQu6JGM
extra-libraries:
    iconv
include-dirs: /usr/local/include
              /usr/local/lib/ghc/base_HQfYBxpPvuw8OunzQu6JGM/include
includes:
    HsBase.h
depends:
    builtin_rts ghc-prim-0.4.0.0-6cdc86811872333585fa98756aa7c51e
    integer-gmp-1.0.0.0-3c8c40657a9870f5c33be17496806d8d
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/base-4.8.2.0/base.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/base-4.8.2.0
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: terminfo
version: 0.4.0.1
id: terminfo-0.4.0.1-ff5b3d5838955b7711e16ccc720f06f4
key: termi_6iVf4EBnOgfIaaOCLRs8jl
license: BSD3
copyright: (c) Judah Jacobson
maintainer: Judah Jacobson <judah.jacobson@gmail.com>
stability: Stable
homepage: https://github.com/judah/terminfo
synopsis: Haskell bindings to the terminfo library.
description:
    This library provides an interface to the terminfo database (via bindings to the
    curses library).  <http://en.wikipedia.org/wiki/Terminfo Terminfo> allows POSIX
    systems to interact with a variety of terminals using a standard set of capabilities.
category: User Interfaces
author: Judah Jacobson
exposed: True
exposed-modules:
    System.Console.Terminfo System.Console.Terminfo.Base
    System.Console.Terminfo.Cursor System.Console.Terminfo.Color
    System.Console.Terminfo.Edit System.Console.Terminfo.Effects
    System.Console.Terminfo.Keys
trusted: False
import-dirs: /usr/local/lib/ghc/termi_6iVf4EBnOgfIaaOCLRs8jl
library-dirs: /usr/local/lib/ghc/termi_6iVf4EBnOgfIaaOCLRs8jl
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/terminfo-0.4.0.1
hs-libraries: HSterminfo-0.4.0.1-6iVf4EBnOgfIaaOCLRs8jl
extra-libraries:
    ncursesw
includes:
    ncurses.h term.h
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/terminfo-0.4.0.1/terminfo.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/terminfo-0.4.0.1
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: xhtml
version: 3000.2.1
id: xhtml-3000.2.1-e005917157f780654d68110616d034e8
key: xhtml_0ACfOp3hebWD9jGWE4v4Gh
license: BSD3
copyright: Bjorn Bringert 2004-2006, Andy Gill and the Oregon
           Graduate Institute of Science and Technology, 1999-2001
maintainer: Chris Dornan <chris@chrisdornan.com>
stability: Stable
homepage: https://github.com/haskell/xhtml
synopsis: An XHTML combinator library
description:
    This package provides combinators for producing
    XHTML 1.0, including the Strict, Transitional and
    Frameset variants.
category: Web, XML, Pretty Printer
author: Bjorn Bringert
exposed: True
exposed-modules:
    Text.XHtml Text.XHtml.Frameset Text.XHtml.Strict
    Text.XHtml.Transitional Text.XHtml.Debug Text.XHtml.Table
hidden-modules: Text.XHtml.Strict.Attributes
                Text.XHtml.Strict.Elements Text.XHtml.Frameset.Attributes
                Text.XHtml.Frameset.Elements Text.XHtml.Transitional.Attributes
                Text.XHtml.Transitional.Elements Text.XHtml.BlockTable
                Text.XHtml.Extras Text.XHtml.Internals
trusted: False
import-dirs: /usr/local/lib/ghc/xhtml_0ACfOp3hebWD9jGWE4v4Gh
library-dirs: /usr/local/lib/ghc/xhtml_0ACfOp3hebWD9jGWE4v4Gh
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/xhtml-3000.2.1
hs-libraries: HSxhtml-3000.2.1-0ACfOp3hebWD9jGWE4v4Gh
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/xhtml-3000.2.1/xhtml.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/xhtml-3000.2.1
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: transformers
version: 0.4.2.0
id: transformers-0.4.2.0-81450cd8f86b36eaa8fa0cbaf6efc3a3
key: trans_GZTjP9K5WFq01xC9BAGQpF
license: BSD3
maintainer: Ross Paterson <ross@soi.city.ac.uk>
synopsis: Concrete functor and monad transformers
description:
    A portable library of functor and monad transformers, inspired by
    the paper \"Functional Programming with Overloading and Higher-Order
    Polymorphism\", by Mark P Jones,
    in /Advanced School of Functional Programming/, 1995
    (<http://web.cecs.pdx.edu/~mpj/pubs/springschool.html>).
    .
    This package contains:
    .
    * the monad transformer class (in "Control.Monad.Trans.Class")
    and IO monad class (in "Control.Monad.IO.Class")
    .
    * concrete functor and monad transformers, each with associated
    operations and functions to lift operations associated with other
    transformers.
    .
    The package can be used on its own in portable Haskell code, in
    which case operations need to be manually lifted through transformer
    stacks (see "Control.Monad.Trans.Class" for some examples).
    Alternatively, it can be used with the non-portable monad classes in
    the @mtl@ or @monads-tf@ packages, which automatically lift operations
    introduced by monad transformers through other transformers.
category: Control
author: Andy Gill, Ross Paterson
exposed: True
exposed-modules:
    Control.Applicative.Backwards Control.Applicative.Lift
    Control.Monad.IO.Class Control.Monad.Signatures
    Control.Monad.Trans.Class Control.Monad.Trans.Cont
    Control.Monad.Trans.Except Control.Monad.Trans.Error
    Control.Monad.Trans.Identity Control.Monad.Trans.List
    Control.Monad.Trans.Maybe Control.Monad.Trans.Reader
    Control.Monad.Trans.RWS Control.Monad.Trans.RWS.Lazy
    Control.Monad.Trans.RWS.Strict Control.Monad.Trans.State
    Control.Monad.Trans.State.Lazy Control.Monad.Trans.State.Strict
    Control.Monad.Trans.Writer Control.Monad.Trans.Writer.Lazy
    Control.Monad.Trans.Writer.Strict Data.Functor.Classes
    Data.Functor.Compose Data.Functor.Constant Data.Functor.Product
    Data.Functor.Reverse Data.Functor.Sum
trusted: False
import-dirs: /usr/local/lib/ghc/trans_GZTjP9K5WFq01xC9BAGQpF
library-dirs: /usr/local/lib/ghc/trans_GZTjP9K5WFq01xC9BAGQpF
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/transformers-0.4.2.0
hs-libraries: HStransformers-0.4.2.0-GZTjP9K5WFq01xC9BAGQpF
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/transformers-0.4.2.0/transformers.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/transformers-0.4.2.0
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: array
version: 0.5.1.0
id: array-0.5.1.0-960bf9ae8875cc30355e086f8853a049
key: array_67iodizgJQIIxYVTp4emlA
license: BSD3
maintainer: libraries@haskell.org
synopsis: Mutable and immutable arrays
description:
    In addition to providing the "Data.Array" module
    <http://www.haskell.org/onlinereport/haskell2010/haskellch14.html as specified in the Haskell 2010 Language Report>,
    this package also defines the classes 'IArray' of
    immutable arrays and 'MArray' of arrays mutable within appropriate
    monads, as well as some instances of these classes.
category: Data Structures
exposed: True
exposed-modules:
    Data.Array Data.Array.Base Data.Array.IArray Data.Array.IO
    Data.Array.IO.Safe Data.Array.IO.Internals Data.Array.MArray
    Data.Array.MArray.Safe Data.Array.ST Data.Array.ST.Safe
    Data.Array.Storable Data.Array.Storable.Safe
    Data.Array.Storable.Internals Data.Array.Unboxed Data.Array.Unsafe
trusted: False
import-dirs: /usr/local/lib/ghc/array_67iodizgJQIIxYVTp4emlA
library-dirs: /usr/local/lib/ghc/array_67iodizgJQIIxYVTp4emlA
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/array-0.5.1.0
hs-libraries: HSarray-0.5.1.0-67iodizgJQIIxYVTp4emlA
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/array-0.5.1.0/array.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/array-0.5.1.0
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: deepseq
version: 1.4.1.1
id: deepseq-1.4.1.1-614b63b36dd6e29d2b35afff57c25311
key: deeps_6vMKxt5sPFR0XsbRWvvq59
license: BSD3
maintainer: libraries@haskell.org
synopsis: Deep evaluation of data structures
description:
    This package provides methods for fully evaluating data structures
    (\"deep evaluation\"). Deep evaluation is often used for adding
    strictness to a program, e.g. in order to force pending exceptions,
    remove space leaks, or force lazy I/O to happen. It is also useful
    in parallel programs, to ensure pending work does not migrate to the
    wrong thread.
    .
    The primary use of this package is via the 'deepseq' function, a
    \"deep\" version of 'seq'. It is implemented on top of an 'NFData'
    typeclass (\"Normal Form Data\", data structures with no unevaluated
    components) which defines strategies for fully evaluating different
    data types.
category: Control
exposed: True
exposed-modules:
    Control.DeepSeq
trusted: False
import-dirs: /usr/local/lib/ghc/deeps_6vMKxt5sPFR0XsbRWvvq59
library-dirs: /usr/local/lib/ghc/deeps_6vMKxt5sPFR0XsbRWvvq59
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/deepseq-1.4.1.1
hs-libraries: HSdeepseq-1.4.1.1-6vMKxt5sPFR0XsbRWvvq59
depends:
    array-0.5.1.0-960bf9ae8875cc30355e086f8853a049
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/deepseq-1.4.1.1/deepseq.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/deepseq-1.4.1.1
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: pretty
version: 1.1.2.0
id: pretty-1.1.2.0-5cc412214ea63f61ee84c4fbabdbe0ec
key: prett_JItwetRppk1H5Uq3xbjDGC
license: BSD3
maintainer: David Terei <code@davidterei.com>
stability: Stable
homepage: http://github.com/haskell/pretty
synopsis: Pretty-printing library
description:
    This package contains a pretty-printing library, a set of API's
    that provides a way to easily print out text in a consistent
    format of your choosing. This is useful for compilers and related
    tools.
    .
    This library was originally designed by John Hughes's and has since
    been heavily modified by Simon Peyton Jones.
category: Text
exposed: True
exposed-modules:
    Text.PrettyPrint Text.PrettyPrint.HughesPJ
    Text.PrettyPrint.HughesPJClass
trusted: False
import-dirs: /usr/local/lib/ghc/prett_JItwetRppk1H5Uq3xbjDGC
library-dirs: /usr/local/lib/ghc/prett_JItwetRppk1H5Uq3xbjDGC
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/pretty-1.1.2.0
hs-libraries: HSpretty-1.1.2.0-JItwetRppk1H5Uq3xbjDGC
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    deepseq-1.4.1.1-614b63b36dd6e29d2b35afff57c25311
    ghc-prim-0.4.0.0-6cdc86811872333585fa98756aa7c51e
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/pretty-1.1.2.0/pretty.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/pretty-1.1.2.0
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: template-haskell
version: 2.10.0.0
id: template-haskell-2.10.0.0-c7288e88d93340cb71c8be26e11aa4d4
key: templ_GJPvtLC64aA4c1Jl10o2qt
license: BSD3
maintainer: libraries@haskell.org
synopsis: Support library for Template Haskell
description:
    This package provides modules containing facilities for manipulating
    Haskell source code using Template Haskell.
    .
    See <http://www.haskell.org/haskellwiki/Template_Haskell> for more
    information.
category: Template Haskell
exposed: True
exposed-modules:
    Language.Haskell.TH Language.Haskell.TH.Lib Language.Haskell.TH.Ppr
    Language.Haskell.TH.PprLib Language.Haskell.TH.Quote
    Language.Haskell.TH.Syntax
hidden-modules: Language.Haskell.TH.Lib.Map
trusted: False
import-dirs: /usr/local/lib/ghc/templ_GJPvtLC64aA4c1Jl10o2qt
library-dirs: /usr/local/lib/ghc/templ_GJPvtLC64aA4c1Jl10o2qt
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/template-haskell-2.10.0.0
hs-libraries: HStemplate-haskell-2.10.0.0-GJPvtLC64aA4c1Jl10o2qt
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    pretty-1.1.2.0-5cc412214ea63f61ee84c4fbabdbe0ec
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/template-haskell-2.10.0.0/template-haskell.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/template-haskell-2.10.0.0
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: time
version: 1.5.0.1
id: time-1.5.0.1-1b9a502bb07a3e6f4d6935fbf9db7181
key: time_FTheb6LSxyX1UABIbBXRfn
license: BSD3
maintainer: <ashley@semantic.org>
stability: stable
homepage: https://github.com/haskell/time
synopsis: A time library
description:
    A time library
category: System
author: Ashley Yakeley
exposed: True
exposed-modules:
    Data.Time.Calendar Data.Time.Calendar.MonthDay
    Data.Time.Calendar.OrdinalDate Data.Time.Calendar.WeekDate
    Data.Time.Calendar.Julian Data.Time.Calendar.Easter Data.Time.Clock
    Data.Time.Clock.POSIX Data.Time.Clock.TAI Data.Time.LocalTime
    Data.Time.Format Data.Time
hidden-modules: Data.Time.Calendar.Private Data.Time.Calendar.Days
                Data.Time.Calendar.Gregorian Data.Time.Calendar.JulianYearDay
                Data.Time.Clock.Scale Data.Time.Clock.UTC Data.Time.Clock.CTimeval
                Data.Time.Clock.UTCDiff Data.Time.LocalTime.TimeZone
                Data.Time.LocalTime.TimeOfDay Data.Time.LocalTime.LocalTime
                Data.Time.Format.Parse Data.Time.Format.Locale
trusted: False
import-dirs: /usr/local/lib/ghc/time_FTheb6LSxyX1UABIbBXRfn
library-dirs: /usr/local/lib/ghc/time_FTheb6LSxyX1UABIbBXRfn
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/time-1.5.0.1
hs-libraries: HStime-1.5.0.1-FTheb6LSxyX1UABIbBXRfn
include-dirs: /usr/local/lib/ghc/time_FTheb6LSxyX1UABIbBXRfn/include
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    deepseq-1.4.1.1-614b63b36dd6e29d2b35afff57c25311
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/time-1.5.0.1/time.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/time-1.5.0.1
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: containers
version: 0.5.6.2
id: containers-0.5.6.2-59326c33e30ec8f6afd574cbac625bbb
key: conta_2C3ZI8RgPO2LBMidXKTvIU
license: BSD3
maintainer: fox@ucw.cz
synopsis: Assorted concrete container types
description:
    This package contains efficient general-purpose implementations
    of various basic immutable container types.  The declared cost of
    each operation is either worst-case or amortized, but remains
    valid even if structures are shared.
category: Data Structures
exposed: True
exposed-modules:
    Data.IntMap Data.IntMap.Lazy Data.IntMap.Strict Data.IntSet
    Data.Map Data.Map.Lazy Data.Map.Strict Data.Set Data.Graph
    Data.Sequence Data.Tree
hidden-modules: Data.IntMap.Base Data.IntSet.Base Data.Map.Base
                Data.Set.Base Data.Utils.BitUtil Data.Utils.StrictFold
                Data.Utils.StrictPair
trusted: False
import-dirs: /usr/local/lib/ghc/conta_2C3ZI8RgPO2LBMidXKTvIU
library-dirs: /usr/local/lib/ghc/conta_2C3ZI8RgPO2LBMidXKTvIU
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/containers-0.5.6.2
hs-libraries: HScontainers-0.5.6.2-2C3ZI8RgPO2LBMidXKTvIU
depends:
    array-0.5.1.0-960bf9ae8875cc30355e086f8853a049
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    deepseq-1.4.1.1-614b63b36dd6e29d2b35afff57c25311
    ghc-prim-0.4.0.0-6cdc86811872333585fa98756aa7c51e
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/containers-0.5.6.2/containers.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/containers-0.5.6.2
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: hoopl
version: 3.10.0.2
id: hoopl-3.10.0.2-e1d2f66d9c173061362d378e84471a99
key: hoopl_FCWMV1gJiCi02IwN4CnRgk
license: BSD3
maintainer: nr@cs.tufts.edu
homepage: http://ghc.cs.tufts.edu/hoopl/
synopsis: A library to support dataflow analysis and optimization
description:
    Higher-order optimization library
    .
    See /Norman Ramsey, Joao Dias, and Simon Peyton Jones./
    <http://research.microsoft.com/en-us/um/people/simonpj/Papers/c--/hoopl-haskell10.pdf "Hoopl: A Modular, Reusable Library for Dataflow Analysis and Transformation"> /(2010)/ for more details.
category: Compilers/Interpreters
author: Norman Ramsey, Joao Dias, Simon Marlow and Simon Peyton Jones
exposed: True
exposed-modules:
    Compiler.Hoopl Compiler.Hoopl.Internals Compiler.Hoopl.Wrappers
    Compiler.Hoopl.Passes.Dominator Compiler.Hoopl.Passes.DList
hidden-modules: Compiler.Hoopl.Checkpoint
                Compiler.Hoopl.Collections Compiler.Hoopl.Combinators
                Compiler.Hoopl.Dataflow Compiler.Hoopl.Debug Compiler.Hoopl.Block
                Compiler.Hoopl.Graph Compiler.Hoopl.Label Compiler.Hoopl.MkGraph
                Compiler.Hoopl.Fuel Compiler.Hoopl.Pointed Compiler.Hoopl.Shape
                Compiler.Hoopl.Show Compiler.Hoopl.Unique Compiler.Hoopl.XUtil
trusted: False
import-dirs: /usr/local/lib/ghc/hoopl_FCWMV1gJiCi02IwN4CnRgk
library-dirs: /usr/local/lib/ghc/hoopl_FCWMV1gJiCi02IwN4CnRgk
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/hoopl-3.10.0.2
hs-libraries: HShoopl-3.10.0.2-FCWMV1gJiCi02IwN4CnRgk
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    containers-0.5.6.2-59326c33e30ec8f6afd574cbac625bbb
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/hoopl-3.10.0.2/hoopl.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/hoopl-3.10.0.2
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: bytestring
version: 0.10.6.0
id: bytestring-0.10.6.0-8a126a308e25adafa4b7221965acccd5
key: bytes_6VWy06pWzJq9evDvK2d4w6
license: BSD3
copyright: Copyright (c) Don Stewart          2005-2009,
           (c) Duncan Coutts        2006-2015,
           (c) David Roundy         2003-2005,
           (c) Jasper Van der Jeugt 2010,
           (c) Simon Meier          2010-2013.
maintainer: Duncan Coutts <duncan@community.haskell.org>
homepage: https://github.com/haskell/bytestring
synopsis: Fast, compact, strict and lazy byte strings with a list interface
description:
    An efficient compact, immutable byte string type (both strict and lazy)
    suitable for binary or 8-bit character data.
    .
    The 'ByteString' type represents sequences of bytes or 8-bit characters.
    It is suitable for high performance use, both in terms of large data
    quantities, or high speed requirements. The 'ByteString' functions follow
    the same style as Haskell\'s ordinary lists, so it is easy to convert code
    from using 'String' to 'ByteString'.
    .
    Two 'ByteString' variants are provided:
    .
    * Strict 'ByteString's keep the string as a single large array. This
    makes them convenient for passing data between C and Haskell.
    .
    * Lazy 'ByteString's use a lazy list of strict chunks which makes it
    suitable for I\/O streaming tasks.
    .
    The @Char8@ modules provide a character-based view of the same
    underlying 'ByteString' types. This makes it convenient to handle mixed
    binary and 8-bit character content (which is common in many file formats
    and network protocols).
    .
    The 'Builder' module provides an efficient way to build up 'ByteString's
    in an ad-hoc way by repeated concatenation. This is ideal for fast
    serialisation or pretty printing.
    .
    There is also a 'ShortByteString' type which has a lower memory overhead
    and can can be converted to or from a 'ByteString', but supports very few
    other operations. It is suitable for keeping many short strings in memory.
    .
    'ByteString's are not designed for Unicode. For Unicode strings you should
    use the 'Text' type from the @text@ package.
    .
    These modules are intended to be imported qualified, to avoid name clashes
    with "Prelude" functions, e.g.
    .
    > import qualified Data.ByteString as BS
category: Data
author: Don Stewart,
        Duncan Coutts
exposed: True
exposed-modules:
    Data.ByteString Data.ByteString.Char8 Data.ByteString.Unsafe
    Data.ByteString.Internal Data.ByteString.Lazy
    Data.ByteString.Lazy.Char8 Data.ByteString.Lazy.Internal
    Data.ByteString.Short Data.ByteString.Short.Internal
    Data.ByteString.Builder Data.ByteString.Builder.Extra
    Data.ByteString.Builder.Prim Data.ByteString.Builder.Internal
    Data.ByteString.Builder.Prim.Internal Data.ByteString.Lazy.Builder
    Data.ByteString.Lazy.Builder.Extras
    Data.ByteString.Lazy.Builder.ASCII
hidden-modules: Data.ByteString.Builder.ASCII
                Data.ByteString.Builder.Prim.Binary
                Data.ByteString.Builder.Prim.ASCII
                Data.ByteString.Builder.Prim.Internal.Floating
                Data.ByteString.Builder.Prim.Internal.UncheckedShifts
                Data.ByteString.Builder.Prim.Internal.Base16
trusted: False
import-dirs: /usr/local/lib/ghc/bytes_6VWy06pWzJq9evDvK2d4w6
library-dirs: /usr/local/lib/ghc/bytes_6VWy06pWzJq9evDvK2d4w6
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/bytestring-0.10.6.0
hs-libraries: HSbytestring-0.10.6.0-6VWy06pWzJq9evDvK2d4w6
include-dirs: /usr/local/lib/ghc/bytes_6VWy06pWzJq9evDvK2d4w6/include
includes:
    fpstring.h
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    deepseq-1.4.1.1-614b63b36dd6e29d2b35afff57c25311
    ghc-prim-0.4.0.0-6cdc86811872333585fa98756aa7c51e
    integer-gmp-1.0.0.0-3c8c40657a9870f5c33be17496806d8d
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/bytestring-0.10.6.0/bytestring.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/bytestring-0.10.6.0
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: binary
version: 0.7.5.0
id: binary-0.7.5.0-623b5c82b24ad555874b44b934c389a3
key: binar_3uXFWMoAGBg0xKP9MHKRwi
license: BSD3
maintainer: Lennart Kolmodin, Don Stewart <dons00@gmail.com>
stability: provisional
homepage: https://github.com/kolmodin/binary
synopsis: Binary serialisation for Haskell values using lazy ByteStrings
description:
    Efficient, pure binary serialisation using lazy ByteStrings.
    Haskell values may be encoded to and from binary formats,
    written to disk as binary, or sent over the network.
    The format used can be automatically generated, or
    you can choose to implement a custom format if needed.
    Serialisation speeds of over 1 G\/sec have been observed,
    so this library should be suitable for high performance
    scenarios.
category: Data, Parsing
author: Lennart Kolmodin <kolmodin@gmail.com>
exposed: True
exposed-modules:
    Data.Binary Data.Binary.Put Data.Binary.Get
    Data.Binary.Get.Internal Data.Binary.Builder
    Data.Binary.Builder.Internal
hidden-modules: Data.Binary.Builder.Base Data.Binary.Class
                Data.Binary.Generic
trusted: False
import-dirs: /usr/local/lib/ghc/binar_3uXFWMoAGBg0xKP9MHKRwi
library-dirs: /usr/local/lib/ghc/binar_3uXFWMoAGBg0xKP9MHKRwi
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/binary-0.7.5.0
hs-libraries: HSbinary-0.7.5.0-3uXFWMoAGBg0xKP9MHKRwi
depends:
    array-0.5.1.0-960bf9ae8875cc30355e086f8853a049
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    bytestring-0.10.6.0-8a126a308e25adafa4b7221965acccd5
    containers-0.5.6.2-59326c33e30ec8f6afd574cbac625bbb
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/binary-0.7.5.0/binary.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/binary-0.7.5.0
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: unix
version: 2.7.1.0
id: unix-2.7.1.0-1eb46399eeea47e8c604fe462037f106
key: unix_KZL8h98IqDM57kQSPo1mKx
license: BSD3
maintainer: libraries@haskell.org
homepage: https://github.com/haskell/unix
synopsis: POSIX functionality
description:
    This package gives you access to the set of operating system
    services standardised by POSIX 1003.1b (or the IEEE Portable
    Operating System Interface for Computing Environments -
    IEEE Std. 1003.1).
    .
    The package is not supported under Windows (except under Cygwin).
category: System
exposed: True
exposed-modules:
    System.Posix System.Posix.ByteString System.Posix.Error
    System.Posix.Resource System.Posix.Time System.Posix.Unistd
    System.Posix.User System.Posix.Signals System.Posix.Signals.Exts
    System.Posix.Semaphore System.Posix.SharedMem
    System.Posix.ByteString.FilePath System.Posix.Directory
    System.Posix.Directory.ByteString System.Posix.DynamicLinker.Module
    System.Posix.DynamicLinker.Module.ByteString
    System.Posix.DynamicLinker.Prim
    System.Posix.DynamicLinker.ByteString System.Posix.DynamicLinker
    System.Posix.Files System.Posix.Files.ByteString System.Posix.IO
    System.Posix.IO.ByteString System.Posix.Env
    System.Posix.Env.ByteString System.Posix.Fcntl System.Posix.Process
    System.Posix.Process.Internals System.Posix.Process.ByteString
    System.Posix.Temp System.Posix.Temp.ByteString
    System.Posix.Terminal System.Posix.Terminal.ByteString
    System.OpenBSD.Process
hidden-modules: System.Posix.Directory.Common
                System.Posix.DynamicLinker.Common System.Posix.Files.Common
                System.Posix.IO.Common System.Posix.Process.Common
                System.Posix.Terminal.Common
trusted: False
import-dirs: /usr/local/lib/ghc/unix_KZL8h98IqDM57kQSPo1mKx
library-dirs: /usr/local/lib/ghc/unix_KZL8h98IqDM57kQSPo1mKx
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/unix-2.7.1.0
hs-libraries: HSunix-2.7.1.0-KZL8h98IqDM57kQSPo1mKx
extra-libraries:
    util pthread
include-dirs: /usr/local/lib/ghc/unix_KZL8h98IqDM57kQSPo1mKx/include
includes:
    HsUnix.h execvpe.h
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    bytestring-0.10.6.0-8a126a308e25adafa4b7221965acccd5
    time-1.5.0.1-1b9a502bb07a3e6f4d6935fbf9db7181
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/unix-2.7.1.0/unix.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/unix-2.7.1.0
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: filepath
version: 1.4.0.0
id: filepath-1.4.0.0-f97d1e4aebfd7a03be6980454fe31d6e
key: filep_Ey7a1in9roBAE8bUFJ5R9m
license: BSD3
copyright: Neil Mitchell 2005-2015
maintainer: Neil Mitchell <ndmitchell@gmail.com>
homepage: https://github.com/haskell/filepath#readme
synopsis: Library for manipulating FilePaths in a cross platform way.
description:
    This package provides functionality for manipulating @FilePath@ values, and is shipped with both <https://www.haskell.org/ghc/ GHC> and the <https://www.haskell.org/platform/ Haskell Platform>. It provides three modules:
    .
    * "System.FilePath.Posix" manipulates POSIX\/Linux style @FilePath@ values (with @\/@ as the path separator).
    .
    * "System.FilePath.Windows" manipulates Windows style @FilePath@ values (with either @\\@ or @\/@ as the path separator, and deals with drives).
    .
    * "System.FilePath" is an alias for the module appropriate to your platform.
    .
    All three modules provide the same API, and the same documentation (calling out differences in the different variants).
category: System
author: Neil Mitchell <ndmitchell@gmail.com>
exposed: True
exposed-modules:
    System.FilePath System.FilePath.Posix System.FilePath.Windows
trusted: False
import-dirs: /usr/local/lib/ghc/filep_Ey7a1in9roBAE8bUFJ5R9m
library-dirs: /usr/local/lib/ghc/filep_Ey7a1in9roBAE8bUFJ5R9m
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/filepath-1.4.0.0
hs-libraries: HSfilepath-1.4.0.0-Ey7a1in9roBAE8bUFJ5R9m
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/filepath-1.4.0.0/filepath.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/filepath-1.4.0.0
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: directory
version: 1.2.2.0
id: directory-1.2.2.0-de5c44596f448d2b2988d8588c5afdef
key: direc_0hFG6ZxK1nk4zsyOqbNHfm
license: BSD3
maintainer: libraries@haskell.org
synopsis: Platform-agnostic library for filesystem operations
description:
    This library provides a basic set of operations for manipulating files and
    directories in a portable way.
category: System
exposed: True
exposed-modules:
    System.Directory
trusted: False
import-dirs: /usr/local/lib/ghc/direc_0hFG6ZxK1nk4zsyOqbNHfm
library-dirs: /usr/local/lib/ghc/direc_0hFG6ZxK1nk4zsyOqbNHfm
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/directory-1.2.2.0
hs-libraries: HSdirectory-1.2.2.0-0hFG6ZxK1nk4zsyOqbNHfm
include-dirs: /usr/local/lib/ghc/direc_0hFG6ZxK1nk4zsyOqbNHfm/include
includes:
    HsDirectory.h
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    filepath-1.4.0.0-f97d1e4aebfd7a03be6980454fe31d6e
    time-1.5.0.1-1b9a502bb07a3e6f4d6935fbf9db7181
    unix-2.7.1.0-1eb46399eeea47e8c604fe462037f106
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/directory-1.2.2.0/directory.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/directory-1.2.2.0
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: haskeline
version: 0.7.2.1
id: haskeline-0.7.2.1-6931ebdbcc80b8ada5d923048ba5ed89
key: haske_GGvi737nHHfG6zm2y7Rimi
license: BSD3
copyright: (c) Judah Jacobson
maintainer: Judah Jacobson <judah.jacobson@gmail.com>
stability: Experimental
homepage: http://trac.haskell.org/haskeline
synopsis: A command-line interface for user input, written in Haskell.
description:
    Haskeline provides a user interface for line input in command-line
    programs.  This library is similar in purpose to readline, but since
    it is written in Haskell it is (hopefully) more easily used in other
    Haskell programs.
    .
    Haskeline runs both on POSIX-compatible systems and on Windows.
category: User Interfaces
author: Judah Jacobson
exposed: True
exposed-modules:
    System.Console.Haskeline System.Console.Haskeline.Completion
    System.Console.Haskeline.MonadException
    System.Console.Haskeline.History System.Console.Haskeline.IO
hidden-modules: System.Console.Haskeline.Backend
                System.Console.Haskeline.Backend.WCWidth
                System.Console.Haskeline.Command
                System.Console.Haskeline.Command.Completion
                System.Console.Haskeline.Command.History
                System.Console.Haskeline.Command.KillRing
                System.Console.Haskeline.Directory System.Console.Haskeline.Emacs
                System.Console.Haskeline.InputT System.Console.Haskeline.Key
                System.Console.Haskeline.LineState System.Console.Haskeline.Monads
                System.Console.Haskeline.Prefs System.Console.Haskeline.RunCommand
                System.Console.Haskeline.Term System.Console.Haskeline.Command.Undo
                System.Console.Haskeline.Vi System.Console.Haskeline.Recover
                System.Console.Haskeline.Backend.Posix
                System.Console.Haskeline.Backend.Posix.Encoder
                System.Console.Haskeline.Backend.DumbTerm
                System.Console.Haskeline.Backend.Terminfo
trusted: False
import-dirs: /usr/local/lib/ghc/haske_GGvi737nHHfG6zm2y7Rimi
library-dirs: /usr/local/lib/ghc/haske_GGvi737nHHfG6zm2y7Rimi
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/haskeline-0.7.2.1
hs-libraries: HShaskeline-0.7.2.1-GGvi737nHHfG6zm2y7Rimi
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    bytestring-0.10.6.0-8a126a308e25adafa4b7221965acccd5
    containers-0.5.6.2-59326c33e30ec8f6afd574cbac625bbb
    directory-1.2.2.0-de5c44596f448d2b2988d8588c5afdef
    filepath-1.4.0.0-f97d1e4aebfd7a03be6980454fe31d6e
    terminfo-0.4.0.1-ff5b3d5838955b7711e16ccc720f06f4
    transformers-0.4.2.0-81450cd8f86b36eaa8fa0cbaf6efc3a3
    unix-2.7.1.0-1eb46399eeea47e8c604fe462037f106
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/haskeline-0.7.2.1/haskeline.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/haskeline-0.7.2.1
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: bin-package-db
version: 0.0.0.0
id: bin-package-db-0.0.0.0-c2998655922e5892be4d23c583233dd1
key: binpa_JPOxOw4FLalDxRNtBqZ2ji
license: BSD3
maintainer: ghc-devs@haskell.org
synopsis: The GHC compiler's view of the GHC package database format
description:
    This library is shared between GHC and ghc-pkg and is used by
    GHC to read package databases.
    .
    It only deals with the subset of the package database that the
    compiler cares about: modules paths etc and not package
    metadata like description, authors etc. It is thus not a
    library interface to ghc-pkg and is *not* suitable for
    modifying GHC package databases.
    .
    The package database format and this library are constructed in
    such a way that while ghc-pkg depends on Cabal, the GHC library
    and program do not have to depend on Cabal.
exposed: True
exposed-modules:
    GHC.PackageDb
trusted: False
import-dirs: /usr/local/lib/ghc/binpa_JPOxOw4FLalDxRNtBqZ2ji
library-dirs: /usr/local/lib/ghc/binpa_JPOxOw4FLalDxRNtBqZ2ji
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/bin-package-db-0.0.0.0
hs-libraries: HSbin-package-db-0.0.0.0-JPOxOw4FLalDxRNtBqZ2ji
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    binary-0.7.5.0-623b5c82b24ad555874b44b934c389a3
    bytestring-0.10.6.0-8a126a308e25adafa4b7221965acccd5
    directory-1.2.2.0-de5c44596f448d2b2988d8588c5afdef
    filepath-1.4.0.0-f97d1e4aebfd7a03be6980454fe31d6e
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/bin-package-db-0.0.0.0/bin-package-db.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/bin-package-db-0.0.0.0
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: hpc
version: 0.6.0.2
id: hpc-0.6.0.2-18b1cadc9642b8279af277b34b8dc9fe
key: hpc_FUjQx3d1H3dEEtLFWv7hFw
license: BSD3
maintainer: ghc-devs@haskell.org
synopsis: Code Coverage Library for Haskell
description:
    This package provides the code coverage library for Haskell.
    .
    See <http://www.haskell.org/haskellwiki/Haskell_program_coverage> for more
    information.
category: Control
author: Andy Gill
exposed: True
exposed-modules:
    Trace.Hpc.Util Trace.Hpc.Mix Trace.Hpc.Tix Trace.Hpc.Reflect
trusted: False
import-dirs: /usr/local/lib/ghc/hpc_FUjQx3d1H3dEEtLFWv7hFw
library-dirs: /usr/local/lib/ghc/hpc_FUjQx3d1H3dEEtLFWv7hFw
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/hpc-0.6.0.2
hs-libraries: HShpc-0.6.0.2-FUjQx3d1H3dEEtLFWv7hFw
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    containers-0.5.6.2-59326c33e30ec8f6afd574cbac625bbb
    directory-1.2.2.0-de5c44596f448d2b2988d8588c5afdef
    filepath-1.4.0.0-f97d1e4aebfd7a03be6980454fe31d6e
    time-1.5.0.1-1b9a502bb07a3e6f4d6935fbf9db7181
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/hpc-0.6.0.2/hpc.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/hpc-0.6.0.2
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: process
version: 1.2.3.0
id: process-1.2.3.0-ca3fff48cdf67a08d7e3f92817538395
key: proce_52AgREEfSrnJLlkGV9YZZJ
license: BSD3
maintainer: libraries@haskell.org
synopsis: Process libraries
description:
    This package contains libraries for dealing with system processes.
category: System
exposed: True
exposed-modules:
    System.Cmd System.Process System.Process.Internals
trusted: False
import-dirs: /usr/local/lib/ghc/proce_52AgREEfSrnJLlkGV9YZZJ
library-dirs: /usr/local/lib/ghc/proce_52AgREEfSrnJLlkGV9YZZJ
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/process-1.2.3.0
hs-libraries: HSprocess-1.2.3.0-52AgREEfSrnJLlkGV9YZZJ
include-dirs: /usr/local/lib/ghc/proce_52AgREEfSrnJLlkGV9YZZJ/include
includes:
    runProcess.h
depends:
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    deepseq-1.4.1.1-614b63b36dd6e29d2b35afff57c25311
    directory-1.2.2.0-de5c44596f448d2b2988d8588c5afdef
    filepath-1.4.0.0-f97d1e4aebfd7a03be6980454fe31d6e
    unix-2.7.1.0-1eb46399eeea47e8c604fe462037f106
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/process-1.2.3.0/process.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/process-1.2.3.0
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: ghc
version: 7.10.3
id: ghc-7.10.3-2d53a5d119792e42b861416c805a1843
key: ghc_0AG9TOjDEtx4Ji3wSwHOBe
license: BSD3
maintainer: glasgow-haskell-users@haskell.org
homepage: http://www.haskell.org/ghc/
synopsis: The GHC API
description:
    GHC's functionality can be useful for more things than just
    compiling Haskell programs. Important use cases are programs
    that analyse (and perhaps transform) Haskell code. Others
    include loading Haskell code dynamically in a GHCi-like manner.
    For this reason, a lot of GHC's functionality is made available
    through this package.
category: Development
author: The GHC Team
exposed: False
exposed-modules:
    Avail BasicTypes ConLike DataCon PatSyn Demand Debug Exception
    GhcMonad Hooks Id IdInfo Lexeme Literal Llvm Llvm.AbsSyn
    Llvm.MetaData Llvm.PpLlvm Llvm.Types LlvmCodeGen LlvmCodeGen.Base
    LlvmCodeGen.CodeGen LlvmCodeGen.Data LlvmCodeGen.Ppr
    LlvmCodeGen.Regs LlvmMangler MkId Module Name NameEnv NameSet
    OccName RdrName SrcLoc UniqSupply Unique Var VarEnv VarSet
    UnVarGraph BlockId CLabel Cmm CmmBuildInfoTables CmmPipeline
    CmmCallConv CmmCommonBlockElim CmmContFlowOpt CmmExpr CmmInfo
    CmmLex CmmLint CmmLive CmmMachOp CmmNode CmmOpt CmmParse
    CmmProcPoint CmmSink CmmType CmmUtils CmmLayoutStack MkGraph
    PprBase PprC PprCmm PprCmmDecl PprCmmExpr Bitmap CodeGen.Platform
    CodeGen.Platform.ARM CodeGen.Platform.ARM64 CodeGen.Platform.NoRegs
    CodeGen.Platform.PPC CodeGen.Platform.PPC_Darwin
    CodeGen.Platform.SPARC CodeGen.Platform.X86 CodeGen.Platform.X86_64
    CgUtils StgCmm StgCmmBind StgCmmClosure StgCmmCon StgCmmEnv
    StgCmmExpr StgCmmForeign StgCmmHeap StgCmmHpc StgCmmArgRep
    StgCmmLayout StgCmmMonad StgCmmPrim StgCmmProf StgCmmTicky
    StgCmmUtils StgCmmExtCode SMRep CoreArity CoreFVs CoreLint CorePrep
    CoreSubst CoreSyn TrieMap CoreTidy CoreUnfold CoreUtils MkCore
    PprCore Check Coverage Desugar DsArrows DsBinds DsCCall DsExpr
    DsForeign DsGRHSs DsListComp DsMonad DsUtils Match MatchCon
    MatchLit HsBinds HsDecls HsDoc HsExpr HsImpExp HsLit PlaceHolder
    HsPat HsSyn HsTypes HsUtils BinIface BuildTyCl IfaceEnv IfaceSyn
    IfaceType LoadIface MkIface TcIface FlagChecker Annotations
    BreakArray CmdLineParser CodeOutput Config Constants DriverMkDepend
    DriverPhases PipelineMonad DriverPipeline DynFlags ErrUtils Finder
    GHC GhcMake GhcPlugins DynamicLoading HeaderInfo HscMain HscStats
    HscTypes InteractiveEval InteractiveEvalTypes PackageConfig
    Packages PlatformConstants Plugins TcPluginM PprTyThing StaticFlags
    StaticPtrTable SysTools TidyPgm Ctype HaddockUtils Lexer
    OptCoercion Parser RdrHsSyn ApiAnnotation ForeignCall PrelInfo
    PrelNames PrelRules PrimOp TysPrim TysWiredIn CostCentre ProfInit
    SCCfinal RnBinds RnEnv RnExpr RnHsDoc RnNames RnPat RnSource
    RnSplice RnTypes CoreMonad CSE FloatIn FloatOut LiberateCase
    OccurAnal SAT SetLevels SimplCore SimplEnv SimplMonad SimplUtils
    Simplify SimplStg StgStats UnariseStg Rules SpecConstr Specialise
    CoreToStg StgLint StgSyn CallArity DmdAnal WorkWrap WwLib FamInst
    Inst TcAnnotations TcArrows TcBinds TcClassDcl TcDefaults TcDeriv
    TcEnv TcExpr TcForeign TcGenDeriv TcGenGenerics TcHsSyn TcHsType
    TcInstDcls TcMType TcValidity TcMatches TcPat TcPatSyn TcRnDriver
    TcRnMonad TcRnTypes TcRules TcSimplify TcErrors TcTyClsDecls
    TcTyDecls TcType TcEvidence TcUnify TcInteract TcCanonical
    TcFlatten TcSMonad TcTypeNats TcSplice Class Coercion FamInstEnv
    FunDeps InstEnv TyCon CoAxiom Kind Type TypeRep Unify Bag Binary
    BooleanFormula BufWrite Digraph Encoding FastBool FastFunctions
    FastMutInt FastString FastTypes Fingerprint FiniteMap GraphBase
    GraphColor GraphOps GraphPpr IOEnv ListSetOps Maybes MonadUtils
    OrdList Outputable Pair Panic Pretty Serialized State Stream
    StringBuffer UniqFM UniqSet Util ExtsCompat46
    Vectorise.Builtins.Base Vectorise.Builtins.Initialise
    Vectorise.Builtins Vectorise.Monad.Base Vectorise.Monad.Naming
    Vectorise.Monad.Local Vectorise.Monad.Global
    Vectorise.Monad.InstEnv Vectorise.Monad Vectorise.Utils.Base
    Vectorise.Utils.Closure Vectorise.Utils.Hoisting
    Vectorise.Utils.PADict Vectorise.Utils.Poly Vectorise.Utils
    Vectorise.Generic.Description Vectorise.Generic.PAMethods
    Vectorise.Generic.PADict Vectorise.Generic.PData Vectorise.Type.Env
    Vectorise.Type.Type Vectorise.Type.TyConDecl
    Vectorise.Type.Classify Vectorise.Convert Vectorise.Vect
    Vectorise.Var Vectorise.Env Vectorise.Exp Vectorise Hoopl.Dataflow
    Hoopl AsmCodeGen TargetReg NCGMonad Instruction Size Reg RegClass
    PIC Platform CPrim X86.Regs X86.RegInfo X86.Instr X86.Cond X86.Ppr
    X86.CodeGen PPC.Regs PPC.RegInfo PPC.Instr PPC.Cond PPC.Ppr
    PPC.CodeGen SPARC.Base SPARC.Regs SPARC.Imm SPARC.AddrMode
    SPARC.Cond SPARC.Instr SPARC.Stack SPARC.ShortcutJump SPARC.Ppr
    SPARC.CodeGen SPARC.CodeGen.Amode SPARC.CodeGen.Base
    SPARC.CodeGen.CondCode SPARC.CodeGen.Gen32 SPARC.CodeGen.Gen64
    SPARC.CodeGen.Sanity SPARC.CodeGen.Expand RegAlloc.Liveness
    RegAlloc.Graph.Main RegAlloc.Graph.Stats RegAlloc.Graph.ArchBase
    RegAlloc.Graph.ArchX86 RegAlloc.Graph.Coalesce RegAlloc.Graph.Spill
    RegAlloc.Graph.SpillClean RegAlloc.Graph.SpillCost
    RegAlloc.Graph.TrivColorable RegAlloc.Linear.Main
    RegAlloc.Linear.JoinToTargets RegAlloc.Linear.State
    RegAlloc.Linear.Stats RegAlloc.Linear.FreeRegs
    RegAlloc.Linear.StackMap RegAlloc.Linear.Base
    RegAlloc.Linear.X86.FreeRegs RegAlloc.Linear.X86_64.FreeRegs
    RegAlloc.Linear.PPC.FreeRegs RegAlloc.Linear.SPARC.FreeRegs Dwarf
    Dwarf.Types Dwarf.Constants DsMeta Convert ByteCodeAsm ByteCodeGen
    ByteCodeInstr ByteCodeItbls ByteCodeLink Debugger LibFFI Linker
    ObjLink RtClosureInspect DebuggerUtils
trusted: False
import-dirs: /usr/local/lib/ghc/ghc_0AG9TOjDEtx4Ji3wSwHOBe
library-dirs: /usr/local/lib/ghc/ghc_0AG9TOjDEtx4Ji3wSwHOBe
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/ghc-7.10.3
hs-libraries: HSghc-7.10.3-0AG9TOjDEtx4Ji3wSwHOBe
include-dirs: /usr/local/lib/ghc/ghc_0AG9TOjDEtx4Ji3wSwHOBe/include
depends:
    array-0.5.1.0-960bf9ae8875cc30355e086f8853a049
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    bin-package-db-0.0.0.0-c2998655922e5892be4d23c583233dd1
    bytestring-0.10.6.0-8a126a308e25adafa4b7221965acccd5
    containers-0.5.6.2-59326c33e30ec8f6afd574cbac625bbb
    directory-1.2.2.0-de5c44596f448d2b2988d8588c5afdef
    filepath-1.4.0.0-f97d1e4aebfd7a03be6980454fe31d6e
    hoopl-3.10.0.2-e1d2f66d9c173061362d378e84471a99
    hpc-0.6.0.2-18b1cadc9642b8279af277b34b8dc9fe
    process-1.2.3.0-ca3fff48cdf67a08d7e3f92817538395
    template-haskell-2.10.0.0-c7288e88d93340cb71c8be26e11aa4d4
    time-1.5.0.1-1b9a502bb07a3e6f4d6935fbf9db7181
    transformers-0.4.2.0-81450cd8f86b36eaa8fa0cbaf6efc3a3
    unix-2.7.1.0-1eb46399eeea47e8c604fe462037f106
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/ghc-7.10.3/ghc.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/ghc-7.10.3
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
$p register --force - << 'EOF'
name: Cabal
version: 1.22.5.0
id: Cabal-1.22.5.0-2cd6172e43eefbacb02a1b75f729139e
key: Cabal_3ux67khMI118y6VpwrFnXN
license: BSD3
copyright: 2003-2006, Isaac Jones
           2005-2011, Duncan Coutts
maintainer: cabal-devel@haskell.org
homepage: http://www.haskell.org/cabal/
synopsis: A framework for packaging Haskell software
description:
    The Haskell Common Architecture for Building Applications and
    Libraries: a framework defining a common interface for authors to more
    easily build their Haskell applications in a portable way.
    .
    The Haskell Cabal is part of a larger infrastructure for distributing,
    organizing, and cataloging Haskell libraries and tools.
category: Distribution
author: Isaac Jones <ijones@syntaxpolice.org>
        Duncan Coutts <duncan@community.haskell.org>
exposed: True
exposed-modules:
    Distribution.Compat.CreatePipe Distribution.Compat.Environment
    Distribution.Compat.Exception Distribution.Compat.ReadP
    Distribution.Compiler Distribution.InstalledPackageInfo
    Distribution.License Distribution.Make Distribution.ModuleName
    Distribution.Package Distribution.PackageDescription
    Distribution.PackageDescription.Check
    Distribution.PackageDescription.Configuration
    Distribution.PackageDescription.Parse
    Distribution.PackageDescription.PrettyPrint
    Distribution.PackageDescription.Utils Distribution.ParseUtils
    Distribution.ReadE Distribution.Simple Distribution.Simple.Bench
    Distribution.Simple.Build Distribution.Simple.Build.Macros
    Distribution.Simple.Build.PathsModule
    Distribution.Simple.BuildPaths Distribution.Simple.BuildTarget
    Distribution.Simple.CCompiler Distribution.Simple.Command
    Distribution.Simple.Compiler Distribution.Simple.Configure
    Distribution.Simple.GHC Distribution.Simple.GHCJS
    Distribution.Simple.Haddock Distribution.Simple.HaskellSuite
    Distribution.Simple.Hpc Distribution.Simple.Install
    Distribution.Simple.InstallDirs Distribution.Simple.JHC
    Distribution.Simple.LHC Distribution.Simple.LocalBuildInfo
    Distribution.Simple.PackageIndex Distribution.Simple.PreProcess
    Distribution.Simple.PreProcess.Unlit Distribution.Simple.Program
    Distribution.Simple.Program.Ar Distribution.Simple.Program.Builtin
    Distribution.Simple.Program.Db Distribution.Simple.Program.Find
    Distribution.Simple.Program.GHC Distribution.Simple.Program.HcPkg
    Distribution.Simple.Program.Hpc Distribution.Simple.Program.Ld
    Distribution.Simple.Program.Run Distribution.Simple.Program.Script
    Distribution.Simple.Program.Strip Distribution.Simple.Program.Types
    Distribution.Simple.Register Distribution.Simple.Setup
    Distribution.Simple.SrcDist Distribution.Simple.Test
    Distribution.Simple.Test.ExeV10 Distribution.Simple.Test.LibV09
    Distribution.Simple.Test.Log Distribution.Simple.UHC
    Distribution.Simple.UserHooks Distribution.Simple.Utils
    Distribution.System Distribution.TestSuite Distribution.Text
    Distribution.Utils.NubList Distribution.Verbosity
    Distribution.Version Language.Haskell.Extension
hidden-modules: Distribution.Compat.Binary
                Distribution.Compat.CopyFile Distribution.Compat.TempFile
                Distribution.GetOpt Distribution.Simple.GHC.Internal
                Distribution.Simple.GHC.IPI641 Distribution.Simple.GHC.IPI642
                Distribution.Simple.GHC.ImplInfo Paths_Cabal
trusted: False
import-dirs: /usr/local/lib/ghc/Cabal_3ux67khMI118y6VpwrFnXN
library-dirs: /usr/local/lib/ghc/Cabal_3ux67khMI118y6VpwrFnXN
data-dir: /usr/local/share/x86_64-openbsd-ghc-7.10.3/Cabal-1.22.5.0
hs-libraries: HSCabal-1.22.5.0-3ux67khMI118y6VpwrFnXN
depends:
    array-0.5.1.0-960bf9ae8875cc30355e086f8853a049
    base-4.8.2.0-8dd7859ce039df9f3d3f4ff9dbf4bb93
    binary-0.7.5.0-623b5c82b24ad555874b44b934c389a3
    bytestring-0.10.6.0-8a126a308e25adafa4b7221965acccd5
    containers-0.5.6.2-59326c33e30ec8f6afd574cbac625bbb
    deepseq-1.4.1.1-614b63b36dd6e29d2b35afff57c25311
    directory-1.2.2.0-de5c44596f448d2b2988d8588c5afdef
    filepath-1.4.0.0-f97d1e4aebfd7a03be6980454fe31d6e
    pretty-1.1.2.0-5cc412214ea63f61ee84c4fbabdbe0ec
    process-1.2.3.0-ca3fff48cdf67a08d7e3f92817538395
    time-1.5.0.1-1b9a502bb07a3e6f4d6935fbf9db7181
    unix-2.7.1.0-1eb46399eeea47e8c604fe462037f106
haddock-interfaces: /usr/local/share/doc/ghc/html/libraries/Cabal-1.22.5.0/Cabal.haddock
haddock-html: /usr/local/share/doc/ghc/html/libraries/Cabal-1.22.5.0
pkgroot: "/usr/obj/ports/ghc-7.10.3/fake-amd64/usr/local/lib/ghc"

EOF
