/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.io.ASN1ParsingException;
import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class PolicyQualifierInfo {
    private OID oid;
    private byte[] encoded;
    private DERValue qualifier;

    public PolicyQualifierInfo(byte[] encoded) throws IOException {
        if (encoded == null) {
            throw new IOException("null bytes");
        }
        this.encoded = (byte[])encoded.clone();
        DERReader in = new DERReader(new ByteArrayInputStream(this.encoded));
        DERValue qualInfo = in.read();
        if (!qualInfo.isConstructed()) {
            throw new ASN1ParsingException("malformed PolicyQualifierInfo");
        }
        DERValue val = in.read();
        if (!(val.getValue() instanceof OID)) {
            throw new ASN1ParsingException("value read not an OBJECT IDENTIFIER");
        }
        this.oid = (OID)val.getValue();
        if (val.getEncodedLength() < val.getLength()) {
            this.qualifier = in.read();
        }
    }

    public final String getPolicyQualifierId() {
        return this.oid.toString();
    }

    public final byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public final byte[] getPolicyQualifier() {
        if (this.qualifier == null) {
            return new byte[0];
        }
        return this.qualifier.getEncoded();
    }

    public String toString() {
        return "PolicyQualifierInfo { policyQualifierId ::= " + this.oid + ", qualifier ::= " + this.qualifier + " }";
    }
}

