/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AttributeValue;
import java.awt.ImageCapabilities;

public class BufferCapabilities
implements Cloneable {
    private final ImageCapabilities front;
    private final ImageCapabilities back;
    private final FlipContents flip;

    public BufferCapabilities(ImageCapabilities frontCaps, ImageCapabilities backCaps, FlipContents flip) {
        if (frontCaps == null || backCaps == null) {
            throw new IllegalArgumentException();
        }
        this.front = frontCaps;
        this.back = backCaps;
        this.flip = flip;
    }

    public ImageCapabilities getFrontBufferCapabilities() {
        return this.front;
    }

    public ImageCapabilities getBackBufferCapabilities() {
        return this.back;
    }

    public boolean isPageFlipping() {
        return this.flip != null;
    }

    public FlipContents getFlipContents() {
        return this.flip;
    }

    public boolean isFullScreenRequired() {
        return true;
    }

    public boolean isMultiBufferAvailable() {
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw (Error)new InternalError().initCause(e);
        }
    }

    public static final class FlipContents
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"undefined", "background", "prior", "copied"};
        public static final FlipContents UNDEFINED = new FlipContents(0);
        public static final FlipContents BACKGROUND = new FlipContents(1);
        public static final FlipContents PRIOR = new FlipContents(2);
        public static final FlipContents COPIED = new FlipContents(3);

        private FlipContents(int value) {
            super(value, NAMES);
        }
    }
}

