/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class DomNodeIterator
implements NodeIterator,
TreeWalker {
    Node root;
    final int whatToShow;
    final NodeFilter filter;
    final boolean entityReferenceExpansion;
    final boolean walk;
    Node current;

    public DomNodeIterator(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion, boolean walk) {
        if (root == null) {
            throw new DOMException(9, "null root");
        }
        this.root = root;
        this.whatToShow = whatToShow;
        this.filter = filter;
        this.entityReferenceExpansion = entityReferenceExpansion;
        this.walk = walk;
        this.current = root;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public boolean getExpandEntityReferences() {
        return this.entityReferenceExpansion;
    }

    public Node nextNode() throws DOMException {
        Node ret;
        if (this.root == null) {
            throw new DOMException(11, "null root");
        }
        do {
            if (this.current.equals(this.root)) {
                ret = this.root.getFirstChild();
            } else if (this.walk) {
                ret = this.current.getFirstChild();
                if (ret == null) {
                    ret = this.current.getNextSibling();
                }
                if (ret == null) {
                    Node tmp = this.current;
                    ret = tmp.getParentNode();
                    while (!ret.equals(this.root) && tmp.equals(ret.getLastChild())) {
                        tmp = ret;
                        ret = tmp.getParentNode();
                    }
                    ret = ret.equals(this.root) ? null : ret.getNextSibling();
                }
            } else {
                ret = this.current.getNextSibling();
            }
            Node node2 = this.current = ret == null ? this.current : ret;
        } while (!this.accept(ret));
        return ret;
    }

    public Node previousNode() throws DOMException {
        Node ret;
        if (this.root == null) {
            throw new DOMException(11, "null root");
        }
        do {
            if (this.current.equals(this.root)) {
                ret = this.current.getLastChild();
                continue;
            }
            if (this.walk) {
                ret = this.current.getLastChild();
                if (ret == null) {
                    ret = this.current.getPreviousSibling();
                }
                if (ret != null) continue;
                Node tmp = this.current;
                ret = tmp.getParentNode();
                while (!ret.equals(this.root) && tmp.equals(ret.getFirstChild())) {
                    tmp = ret;
                    ret = tmp.getParentNode();
                }
                if (ret.equals(this.root)) {
                    ret = null;
                    continue;
                }
                ret = ret.getPreviousSibling();
                continue;
            }
            ret = this.current.getPreviousSibling();
        } while (!this.accept(ret));
        this.current = ret == null ? this.current : ret;
        return ret;
    }

    public Node getCurrentNode() {
        return this.current;
    }

    public void setCurrentNode(Node current) throws DOMException {
        if (current == null) {
            throw new DOMException(9, "null root");
        }
        this.current = current;
    }

    public Node parentNode() {
        Node ret = this.current.getParentNode();
        if (!this.accept(ret)) {
            ret = null;
        }
        this.current = ret == null ? this.current : ret;
        return ret;
    }

    public Node firstChild() {
        Node ret = this.current.getFirstChild();
        while (!this.accept(ret)) {
            ret = ret.getNextSibling();
        }
        this.current = ret == null ? this.current : ret;
        return ret;
    }

    public Node lastChild() {
        Node ret = this.current.getLastChild();
        while (!this.accept(ret)) {
            ret = ret.getPreviousSibling();
        }
        this.current = ret == null ? this.current : ret;
        return ret;
    }

    public Node previousSibling() {
        Node ret = this.current.getPreviousSibling();
        while (!this.accept(ret)) {
            ret = ret.getPreviousSibling();
        }
        this.current = ret == null ? this.current : ret;
        return ret;
    }

    public Node nextSibling() {
        Node ret = this.current.getNextSibling();
        while (!this.accept(ret)) {
            ret = ret.getNextSibling();
        }
        this.current = ret == null ? this.current : ret;
        return ret;
    }

    public void detach() {
        this.root = null;
    }

    boolean accept(Node node2) {
        boolean ret;
        if (node2 == null) {
            return true;
        }
        switch (node2.getNodeType()) {
            case 2: {
                ret = (this.whatToShow & 2) != 0;
                break;
            }
            case 4: {
                ret = (this.whatToShow & 8) != 0;
                break;
            }
            case 8: {
                ret = (this.whatToShow & 0x80) != 0;
                break;
            }
            case 9: {
                ret = (this.whatToShow & 0x100) != 0;
                break;
            }
            case 11: {
                ret = (this.whatToShow & 0x400) != 0;
                break;
            }
            case 10: {
                ret = (this.whatToShow & 0x200) != 0;
                break;
            }
            case 1: {
                ret = (this.whatToShow & 1) != 0;
                break;
            }
            case 6: {
                ret = (this.whatToShow & 0x20) != 0;
                break;
            }
            case 5: {
                ret = (this.whatToShow & 0x10) != 0;
                ret = ret && this.entityReferenceExpansion;
                break;
            }
            case 12: {
                ret = (this.whatToShow & 0x800) != 0;
                break;
            }
            case 7: {
                ret = (this.whatToShow & 0x40) != 0;
                break;
            }
            case 3: {
                ret = (this.whatToShow & 4) != 0;
                break;
            }
            default: {
                ret = true;
            }
        }
        if (ret && this.filter != null) {
            ret = this.filter.acceptNode(node2) == 1;
        }
        return ret;
    }
}

